/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Client;

import DummyCore.Client.DynamicModelBakery;
import DummyCore.Client.IItemRenderer;
import DummyCore.Client.IModelMatrixHandler;
import DummyCore.Client.ISimpleBlockRenderingHandler;
import DummyCore.Client.SBRHAwareModel;
import DummyCore.Utils.Notifier;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;

public class RenderAccessLibrary {
    public static final int RENDER_ID_NONE = -1;
    public static final int RENDER_ID_CUBE = 0;
    public static final int RENDER_ID_CROSS = 1;
    public static final int RENDER_ID_CUBE_AND_CROSS = 2;
    public static final int RENDER_ID_HORIZONTAL_CROSS = 3;
    public static final int RENDER_ID_CROSSES = 4;
    public static final int RENDER_ID_FACES_WITH_OFFSET = 5;
    public static final int RENDER_ID_CROPS = 6;
    public static final int RENDER_ID_FACES_WITH_HORIZONTAL_OFFSET = 7;
    public static final int RENDER_ID_CONNECTED_TO_BLOCK = 8;
    public static final int RENDER_ID_ANVIL = 9;
    public static final Hashtable<Integer, ArrayList<ISimpleBlockRenderingHandler>> renderers = new Hashtable();
    public static final Hashtable<Item, ArrayList<IItemRenderer>> irenderers = new Hashtable();
    public static final Hashtable<Item, IModelMatrixHandler> mHandlers = new Hashtable();
    public static ItemStack currentlyRenderedIS;
    public static ItemCameraTransforms.TransformType currentIIRTransform;

    public static void registerItemMatrixHandler(Item i, IModelMatrixHandler immh) {
        if (mHandlers.containsKey(i)) {
            Notifier.notifyErrorCustomMod("DCRenderLibrary", "Some mod has already registered " + i + " for it's IMMH" + irenderers.get(i) + "! DC will now override the registered handler, but this might cause problems! Contact the respective mod author!(Suspected:" + Loader.instance().activeModContainer().getModId() + "@" + Loader.instance().activeModContainer().getName() + "#" + Loader.instance().activeModContainer().getDisplayVersion() + ")");
        }
        mHandlers.put(i, immh);
    }

    public static void registerItemRenderingHandler(Item i, IItemRenderer iir) {
        if (irenderers.containsKey(i)) {
            Notifier.notifyErrorCustomMod("DCRenderLibrary", "Some mod has already registered " + i + " for it's IIR" + irenderers.get(i) + "! This might cause problems in the future! Contact the respective mod author!(Suspected:" + Loader.instance().activeModContainer().getModId() + "@" + Loader.instance().activeModContainer().getName() + "#" + Loader.instance().activeModContainer().getDisplayVersion() + ")");
            irenderers.get(i).add(0, iir);
        } else {
            ArrayList<IItemRenderer> lst = new ArrayList<IItemRenderer>();
            lst.add(iir);
            irenderers.put(i, lst);
        }
    }

    public static void registerRenderingHandler(ISimpleBlockRenderingHandler isbrh) {
        RenderAccessLibrary.registerRenderingHandler(isbrh.getRenderID(), isbrh);
    }

    public static void registerRenderingHandler(int id, ISimpleBlockRenderingHandler isbrh) {
        if (renderers.containsKey(id)) {
            Notifier.notifyErrorCustomMod("DCRenderLibrary", "Some mod has already registered " + id + " for it's ISBRH" + renderers.get(id) + "! This might cause problems in the future! Contact the respective mod author!(Suspected:" + Loader.instance().activeModContainer().getModId() + "@" + Loader.instance().activeModContainer().getName() + "#" + Loader.instance().activeModContainer().getDisplayVersion() + ")");
            renderers.get(id).add(isbrh);
        } else {
            ArrayList<ISimpleBlockRenderingHandler> lst = new ArrayList<ISimpleBlockRenderingHandler>();
            lst.add(isbrh);
            renderers.put(id, lst);
        }
    }

    public static IBakedModel createDynamicalModelForIS(SBRHAwareModel offendor, ItemStack stk) {
        currentlyRenderedIS = stk;
        SBRHAwareModel returned = offendor.copy();
        DynamicModelBakery dmb = new DynamicModelBakery(returned);
        dmb.doBakeModelForIS(stk);
        currentlyRenderedIS = null;
        return returned;
    }

    public static IBakedModel createDynamicalModelForWorldBlock(SBRHAwareModel offendor, IBlockState state, IBlockAccess world, BlockPos pos) {
        SBRHAwareModel returned = offendor.copy();
        DynamicModelBakery dmb = new DynamicModelBakery(returned, true, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        dmb.doBakeModelInWorld(state, world, pos);
        return returned;
    }

    public static void handleISRendering(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return;
        }
        Item itm = is.func_77973_b();
        if (!irenderers.containsKey(itm)) {
            return;
        }
        ArrayList<IItemRenderer> iirs = irenderers.get(itm);
        if (iirs.isEmpty()) {
            return;
        }
        for (IItemRenderer iir : iirs) {
            if (!iir.handleRenderType(is, currentIIRTransform)) continue;
            iir.renderItem(currentIIRTransform, is);
        }
    }

    public static Matrix4f handleTransformationFor(ItemStack is, ItemCameraTransforms.TransformType tt) {
        currentIIRTransform = tt;
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        Item itm = is.func_77973_b();
        if (!irenderers.containsKey(itm)) {
            return null;
        }
        ArrayList<IItemRenderer> iirs = irenderers.get(itm);
        if (iirs.isEmpty()) {
            return null;
        }
        for (IItemRenderer iir : iirs) {
            if (!iir.handleRenderType(is, currentIIRTransform)) continue;
            return iir.handleTransformsFor(is, currentIIRTransform);
        }
        return null;
    }

    public static boolean hasHandlerFor(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return false;
        }
        Item itm = is.func_77973_b();
        if (!irenderers.containsKey(itm)) {
            return false;
        }
        ArrayList<IItemRenderer> iirs = irenderers.get(itm);
        if (iirs.isEmpty()) {
            return false;
        }
        for (IItemRenderer iir : iirs) {
            if (!iir.handleRenderType(is, currentIIRTransform)) continue;
            return true;
        }
        return false;
    }
}

