/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Core.CoreInitialiser;
import DummyCore.Utils.Pair;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class DummyBlockAccess
implements IBlockAccess {
    public Block[][][] block;
    public byte[][][] meta;
    public TileEntity[][][] tile;
    public int xSize;
    public int ySize;
    public int zSize;
    public BiomeGenBase dummyBiome = BiomeGenBase.field_76771_b;
    public World defaultWorld;
    public Hashtable<Block, Integer[]> cachedMetas = new Hashtable();
    public int cycleTimer = 60;
    public Random cycleRandom = new Random();
    public Hashtable<Pair<Block, Integer>, Integer> cachedBlocksAmounts = new Hashtable();
    public int maxX;
    public int minX;
    public int maxY;
    public int minY;
    public int maxZ;
    public int minZ;
    public WorldWrapper wrapper = new WorldWrapper(this);

    public DummyBlockAccess(int sizeX, int sizeY, int sizeZ) {
        this.block = new Block[sizeX][sizeY][sizeZ];
        this.meta = new byte[sizeX][sizeY][sizeZ];
        this.tile = new TileEntity[sizeX][sizeY][sizeZ];
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.zSize = sizeZ;
        this.maxX = this.xSize;
        this.minX = 0;
        this.maxY = this.ySize;
        this.minY = 0;
        this.maxZ = this.zSize;
        this.minZ = 0;
        this.defaultWorld = CoreInitialiser.proxy.getClientWorld();
    }

    public static DummyBlockAccess fromStructureNBT(NBTTagCompound structureTag) {
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        Set keySet = structureTag.func_150296_c();
        Stack keys = new Stack();
        Stack<DummyBlockPosition> dbp = new Stack<DummyBlockPosition>();
        Iterator $i = keySet.iterator();
        while ($i.hasNext()) {
            keys.add($i.next());
        }
        while (!keys.isEmpty()) {
            String st;
            String s = (String)keys.pop();
            int dx = (int)Double.parseDouble(s.substring(0, s.indexOf(124)));
            int dy = (int)Double.parseDouble(s.substring(s.indexOf(124) + 1, s.lastIndexOf(124)));
            int dz = (int)Double.parseDouble(s.substring(s.lastIndexOf(124) + 1));
            if (dx < minX) {
                minX = dx;
            }
            if (dy < minY) {
                minY = dy;
            }
            if (dz < minZ) {
                minZ = dz;
            }
            if (dx > maxX) {
                maxX = dx;
            }
            if (dy > maxY) {
                maxY = dy;
            }
            if (dz > maxZ) {
                maxZ = dz;
            }
            String bid = (st = structureTag.func_74779_i(s)).indexOf(124) != -1 ? st.substring(0, st.indexOf(124)) : st;
            int meta = st.indexOf(124) != -1 ? Integer.parseInt(st.substring(st.indexOf(124) + 1)) : Short.MAX_VALUE;
            dbp.push(new DummyBlockPosition(dx, dy, dz, bid, meta));
        }
        DummyBlockAccess dba = new DummyBlockAccess(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        while (!dbp.isEmpty()) {
            DummyBlockPosition pos = (DummyBlockPosition)dbp.pop();
            String bid = pos.blockID;
            Block b = GameRegistry.findBlock((String)bid.substring(0, bid.indexOf(58)), (String)bid.substring(bid.indexOf(58) + 1));
            if (b.hasTileEntity(b.func_176203_a(pos.meta))) {
                TileEntity tile = b.createTileEntity(dba.defaultWorld, b.func_176203_a(pos.meta));
                dba.setTileEntity(pos.x - minX, pos.y - minY, pos.z - minZ, tile);
            }
            dba.setBlock(pos.x - minX, pos.y - minY, pos.z - minZ, b, pos.meta);
        }
        return dba;
    }

    public DummyBlockAccess setCycleTime(int i) {
        this.cycleTimer = i;
        return this;
    }

    public DummyBlockAccess setDefaultWorld(World w) {
        this.defaultWorld = w;
        return this;
    }

    public DummyBlockAccess setBiomeToRender(BiomeGenBase bgb) {
        this.dummyBiome = bgb;
        return this;
    }

    public boolean isInRange(int x, int y, int z) {
        return 0 <= x && x < this.xSize && 0 <= y && y < this.ySize && 0 <= z && z < this.zSize && x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY && z >= this.minZ && z < this.maxZ;
    }

    public void setBlock(int x, int y, int z, Block b) {
        if (this.isInRange(x, y, z)) {
            this.block[x][y][z] = b;
        }
    }

    public void setMetadata(int x, int y, int z, int m) {
        if (this.isInRange(x, y, z)) {
            this.meta[x][y][z] = (byte)m;
        }
    }

    public void setBlock(int x, int y, int z, Block b, int m) {
        if (!this.cachedBlocksAmounts.containsKey(new Pair<Block, Integer>(b, m))) {
            this.cachedBlocksAmounts.put(new Pair<Block, Integer>(b, m), 1);
        } else {
            this.cachedBlocksAmounts.put(new Pair<Block, Integer>(b, m), this.cachedBlocksAmounts.get(new Pair<Block, Integer>(b, m)) + 1);
        }
        this.setBlock(x, y, z, b);
        this.setMetadata(x, y, z, m);
    }

    public Block getBlock(int x, int y, int z) {
        return this.isInRange(x, y, z) ? (this.block[x][y][z] == null ? Blocks.field_150350_a : this.block[x][y][z]) : Blocks.field_150350_a;
    }

    public void setTileEntity(int x, int y, int z, TileEntity t) {
        if (this.isInRange(x, y, z)) {
            this.tile[x][y][z] = t;
        }
    }

    public TileEntity getTileEntity(int x, int y, int z) {
        return this.isInRange(x, y, z) ? this.tile[x][y][z] : null;
    }

    public int getLightBrightnessForSkyBlocks(int x, int y, int z, int side) {
        return 0;
    }

    public int getBlockMetadata(int x, int y, int z) {
        return this.isInRange(x, y, z) ? (this.meta[x][y][z] == -1 || this.meta[x][y][z] == Short.MAX_VALUE ? this.getMetadataFromWildcardForBlock(this.getBlock(x, y, z)) : this.meta[x][y][z]) : 0;
    }

    public int getMetadataFromWildcardForBlock(Block b) {
        if (!this.cachedMetas.containsKey(b)) {
            Integer[] i = CoreInitialiser.proxy.createPossibleMetadataCacheFromBlock(b);
            this.cachedMetas.put(b, i);
            return this.getMetadataFromWildcardForBlock(b);
        }
        this.cycleRandom.setSeed(this.defaultWorld.func_72905_C() + this.defaultWorld.func_72820_D() / (long)this.cycleTimer);
        Integer[] i = this.cachedMetas.get(b);
        return i[this.cycleRandom.nextInt(i.length)];
    }

    public int isBlockProvidingPowerTo(int x, int y, int z, int side) {
        return 0;
    }

    public boolean isAirBlock(int x, int y, int z) {
        return this.isInRange(x, y, z) ? this.block[x][y][z] == null || this.block[x][y][z].isAir((IBlockAccess)this, new BlockPos(x, y, z)) : true;
    }

    public BiomeGenBase getBiomeGenForCoords(int x, int z) {
        return this.dummyBiome;
    }

    public int getHeight() {
        return 0;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, EnumFacing side, boolean _default) {
        return this.isInRange(x, y, z) ? (this.block[x][y][z] == null ? _default : this.block[x][y][z].isSideSolid((IBlockAccess)this, new BlockPos(x, y, z), side)) : _default;
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.getTileEntity(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public int func_175626_b(BlockPos pos, int light) {
        return 0;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.isInRange(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) ? this.getBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_176221_a(this.getBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_176203_a(this.getBlockMetadata(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), (IBlockAccess)this, pos) : Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.isAirBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BiomeGenBase func_180494_b(BlockPos pos) {
        return this.getBiomeGenForCoords(pos.func_177958_n(), pos.func_177952_p());
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    public WorldType func_175624_G() {
        return WorldType.field_180271_f;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.isSideSolid(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side, _default);
    }

    public static class WorldWrapper
    extends World {
        public DummyBlockAccess access;

        public WorldWrapper(DummyBlockAccess dba) {
            super(null, null, CoreInitialiser.proxy.getWorldForDim((int)0).field_73011_w, null, true);
            this.access = dba;
        }

        protected WorldWrapper(ISaveHandler saveHandlerIn, WorldInfo info, WorldProvider providerIn, Profiler profilerIn, boolean client) {
            super(saveHandlerIn, info, providerIn, profilerIn, client);
        }

        public BiomeGenBase func_180494_b(BlockPos pos) {
            return this.access.func_180494_b(pos);
        }

        public BiomeGenBase getBiomeGenForCoordsBody(BlockPos pos) {
            return this.access.func_180494_b(pos);
        }

        public WorldChunkManager func_72959_q() {
            return CoreInitialiser.proxy.getWorldForDim(0).func_72959_q();
        }

        protected IChunkProvider func_72970_h() {
            return new ChunkProviderClient(CoreInitialiser.proxy.getWorldForDim(0));
        }

        public void func_72963_a(WorldSettings settings) {
        }

        public void func_72974_f() {
        }

        public Block func_175703_c(BlockPos pos) {
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), this.func_181545_F(), pos.func_177952_p());
            while (!this.access.func_175623_d(blockpos.func_177984_a())) {
                blockpos = blockpos.func_177984_a();
            }
            return this.access.func_180495_p(blockpos).func_177230_c();
        }

        public boolean func_175623_d(BlockPos pos) {
            return this.access.func_175623_d(pos);
        }

        public boolean func_175668_a(BlockPos pos, boolean allowEmpty) {
            return this.access.isInRange(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
            return this.access.isInRange(x * 16, 0, z * 16);
        }

        public Chunk func_72964_e(int chunkX, int chunkZ) {
            return CoreInitialiser.proxy.getWorldForDim(0).func_72964_e(chunkX, chunkZ);
        }

        public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
            this.access.setBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), newState.func_177230_c(), newState.func_177230_c().func_176201_c(newState));
            return true;
        }

        public void markAndNotifyBlock(BlockPos pos, Chunk chunk, IBlockState old, IBlockState new_, int flags) {
        }

        public boolean func_175698_g(BlockPos pos) {
            this.access.setBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Blocks.field_150350_a);
            return true;
        }

        public void func_72975_g(int x1, int z1, int x2, int z2) {
        }

        public void func_180496_d(BlockPos pos, Block blockIn) {
        }

        public int func_175705_a(EnumSkyBlock type, BlockPos pos) {
            return 15;
        }

        public float func_175724_o(BlockPos pos) {
            return 1.0f;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return this.access.func_180495_p(pos);
        }

        public boolean func_72935_r() {
            return true;
        }

        public void func_72956_a(Entity entityIn, String name, float volume, float pitch) {
        }

        public void func_85173_a(EntityPlayer player, String name, float volume, float pitch) {
        }

        public boolean func_72838_d(Entity entityIn) {
            return true;
        }

        public String func_72827_u() {
            return "DBWW";
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return this.access.func_175625_s(pos);
        }

        public void func_175690_a(BlockPos pos, TileEntity tileEntityIn) {
            if (this.access.func_175625_s(pos) != tileEntityIn) {
                this.access.setTileEntity(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), tileEntityIn);
            }
            tileEntityIn.func_145834_a((World)this);
            tileEntityIn.func_174878_a(pos);
        }

        public void func_175713_t(BlockPos pos) {
            this.access.setTileEntity(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), null);
        }

        protected int func_152379_p() {
            return 8;
        }
    }

    public static class DummyBlockPosition {
        public int x;
        public int y;
        public int z;
        public String blockID;
        public int meta;

        public DummyBlockPosition(int px, int py, int pz, String id, int m) {
            this.x = px;
            this.y = py;
            this.z = pz;
            this.blockID = id;
            this.meta = m;
        }
    }
}

