/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.LoadingUtils;
import DummyCore.Utils.MiscUtils;
import DummyCore.Utils.Notifier;
import DummyCore.Utils.SyncUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

public class DummyDataUtils {
    private static NBTTagCompound globalConfig;
    private static Hashtable<String, File> playerFiles;
    private static Hashtable<String, NBTTagCompound> playerConfigs;
    private static String getPath;
    private static boolean isWorking;
    private static File directory;
    private static final Class<DummyDataUtils> clazz;

    @SubscribeEvent
    public void serverWorldLoad(WorldEvent.Load event) {
        try {
            File f;
            World w = event.world;
            if (w != null && !w.field_72995_K && w.field_73011_w != null && w.field_73011_w.func_177502_q() == 0 && (f = event.world.func_72860_G().func_75765_b()) != null) {
                String fPath = f.getAbsolutePath();
                String dDataPath = fPath + "//DummyData//";
                directory = new File(dDataPath);
                directory.mkdirs();
                File globalDataDat = new File(directory + "//GlobalData.ddat");
                File f1 = new File(directory + "//PlayerData//");
                f1.mkdirs();
                getPath = dDataPath;
                globalConfig = DummyDataUtils.createOrLoadTag(globalDataDat);
                isWorking = true;
            }
        }
        catch (Exception e) {
            Notifier.notifyCustomMod("DummyCore", "Error loading DummyData!");
            e.printStackTrace();
            return;
        }
    }

    @SubscribeEvent
    public void serverWorldSave(WorldEvent.Save event) {
        try {
            File f;
            World w = event.world;
            if (w != null && !w.field_72995_K && w.field_73011_w != null && w.field_73011_w.func_177502_q() == 0 && (f = event.world.func_72860_G().func_75765_b()) != null) {
                String fPath = f.getAbsolutePath();
                String dDataPath = fPath + "//DummyData//";
                directory = new File(dDataPath);
                directory.mkdirs();
                File globalDataDat = new File(directory + "//GlobalData.ddat");
                DummyDataUtils.saveGlobalTag(globalDataDat);
            }
        }
        catch (Exception e) {
            Notifier.notifyCustomMod("DummyCore", "Error loading DummyData!");
            e.printStackTrace();
            return;
        }
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            EntityPlayer player = event.entityPlayer;
            boolean exists = true;
            File playerFile = DummyDataUtils.getDataFileForPlayer(player.func_70005_c_());
            if (playerFile.isDirectory()) {
                DummyDataUtils.restoreFileFromDir(playerFile);
                exists = false;
            }
            if (!playerFile.exists()) {
                exists = false;
                DummyDataUtils.createFile(playerFile);
            }
            if (exists) {
                NBTTagCompound tag = DummyDataUtils.loadNBTFromFile(playerFile);
                playerConfigs.put(player.func_70005_c_(), tag);
            } else {
                playerConfigs.put(player.func_70005_c_(), new NBTTagCompound());
            }
        }
    }

    @SubscribeEvent
    public void playerSave(PlayerEvent.SaveToFile event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            EntityPlayer player = event.entityPlayer;
            File playerFile = DummyDataUtils.getDataFileForPlayer(player.func_70005_c_());
            if (playerFile.isDirectory()) {
                DummyDataUtils.restoreFileFromDir(playerFile);
            }
            if (!playerFile.exists()) {
                DummyDataUtils.createFile(playerFile);
            }
            DummyDataUtils.writeNBTToFile(globalConfig, playerFile);
        }
    }

    @SubscribeEvent
    public void playerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            playerFiles.remove(event.player.func_70005_c_());
            playerConfigs.remove(event.player.func_70005_c_());
        }
    }

    private static void saveGlobalTag(File file) {
        if (file.isDirectory()) {
            DummyDataUtils.restoreFileFromDir(file);
        }
        if (!file.exists()) {
            DummyDataUtils.createFile(file);
        }
        DummyDataUtils.writeNBTToFile(globalConfig, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNBTToFile(NBTTagCompound tag, File file) {
        try {
            FileOutputStream oStream = new FileOutputStream(file);
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)oStream);
            }
            catch (IOException ioe) {
                LoadingUtils.makeACrash(file + " appears to be damaged, either fix it or delete it!", clazz, ioe, false);
            }
            finally {
                oStream.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            LoadingUtils.makeACrash(file + " does not exists. This is an impossible error and should be reported as soon as possible", clazz, fnfe, true);
        }
        catch (SecurityException se) {
            LoadingUtils.makeACrash(file + " Can't be accessed by Java, check your anti-virus and file privelleges!", clazz, se, true);
        }
        catch (IOException ioe) {
            LoadingUtils.makeACrash(file + " Can't be created, check your file system!", clazz, ioe, true);
        }
    }

    private static void restoreFileFromDir(File file) {
        Notifier.notifyError(file + " Is a directory, and should not be. Trying to resolve the issue...");
        try {
            file.delete();
            file.createNewFile();
        }
        catch (IOException ioe) {
            LoadingUtils.makeACrash(file + " Can't be created, check your file system!", clazz, ioe, true);
        }
        catch (SecurityException se) {
            LoadingUtils.makeACrash(file + " Can't be accessed by Java, check your anti-virus and file privelleges!", clazz, se, true);
        }
    }

    private static void createFile(File file) {
        try {
            file.createNewFile();
        }
        catch (IOException ioe) {
            LoadingUtils.makeACrash(file + " Can't be created, check your file system!", clazz, ioe, true);
        }
        catch (SecurityException se) {
            LoadingUtils.makeACrash(file + " Can't be accessed by Java, check your anti-virus and file privelleges!", clazz, se, true);
        }
    }

    private static NBTTagCompound createOrLoadTag(File file) {
        NBTTagCompound tag = new NBTTagCompound();
        boolean exists = true;
        if (file.isDirectory()) {
            DummyDataUtils.restoreFileFromDir(file);
            exists = false;
        }
        if (!file.exists()) {
            exists = false;
            DummyDataUtils.createFile(file);
        }
        if (exists) {
            tag = DummyDataUtils.loadNBTFromFile(file);
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NBTTagCompound loadNBTFromFile(File file) {
        block10: {
            NBTTagCompound nBTTagCompound;
            FileInputStream iStream = new FileInputStream(file);
            try {
                NBTTagCompound tag;
                nBTTagCompound = tag = CompressedStreamTools.func_74796_a((InputStream)iStream);
            }
            catch (IOException ioe) {
                try {
                    try {
                        LoadingUtils.makeACrash(file + " appears to be damaged, either fix it or delete it!", clazz, ioe, false);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        iStream.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    LoadingUtils.makeACrash(file + " does not exists. This is an impossible error and should be reported as soon as possible", clazz, fnfe, true);
                    break block10;
                }
                catch (SecurityException se) {
                    LoadingUtils.makeACrash(file + " Can't be accessed by Java, check your anti-virus and file privelleges!", clazz, se, true);
                    break block10;
                }
                catch (IOException ioe2) {
                    LoadingUtils.makeACrash(file + " Can't be created, check your file system!", clazz, ioe2, true);
                }
            }
            iStream.close();
            return nBTTagCompound;
        }
        return new NBTTagCompound();
    }

    public static void stop() {
        globalConfig = null;
        playerFiles.clear();
        playerConfigs.clear();
        getPath = "no path";
        isWorking = false;
        directory = null;
        MiscUtils.registeredClientData.clear();
        MiscUtils.registeredClientWorldData.clear();
        MiscUtils.registeredServerData.clear();
        MiscUtils.registeredServerWorldData.clear();
    }

    private static File getDataFileForPlayer(String playerName) {
        if (!playerFiles.containsKey(playerName)) {
            File ret = new File(getPath + "/PlayerData/" + playerName + ".ddat");
            if (!ret.exists()) {
                try {
                    ret.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            playerFiles.put(playerName, ret);
            return ret;
        }
        return playerFiles.get(playerName);
    }

    private static NBTTagCompound getDataConfigForPlayer(String playerName) {
        if (!DummyDataUtils.canWorkWithData()) {
            return null;
        }
        if (!playerConfigs.containsKey(playerName)) {
            playerConfigs.put(playerName, DummyDataUtils.createOrLoadTag(playerFiles.get(playerName)));
        }
        return playerConfigs.get(playerName);
    }

    public static void writeCustomDataForMod(String modid, String dataName, String dataString) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            MiscUtils.registeredClientWorldData.put(modid + "|" + dataName, dataString);
        } else {
            if (!DummyDataUtils.canWorkWithData()) {
                return;
            }
            globalConfig.func_74778_a(modid + "|" + dataName, dataString);
            MiscUtils.registeredServerWorldData.put(modid + "|" + dataName, dataString);
            DummyDataUtils.syncGlobalDataToClient(modid, dataName);
        }
    }

    public static void loadCustomDataForMod(String modid, String dataName) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            return;
        }
        if (!DummyDataUtils.canWorkWithData()) {
            return;
        }
        MiscUtils.registeredServerWorldData.put(modid + "|" + dataName, globalConfig.func_74779_i(modid + "|" + dataName));
        DummyDataUtils.syncGlobalDataToClient(modid, dataName);
    }

    public static void loadGlobalDataForMod(String modid) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            return;
        }
        if (!DummyDataUtils.canWorkWithData()) {
            return;
        }
        MiscUtils.registeredServerWorldData.put(modid + "|" + modid, globalConfig.func_74779_i(modid + "|" + modid));
        DummyDataUtils.syncGlobalDataToClient(modid, modid);
    }

    public static void writeGlobalDataForMod(String modid, String dataString) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            MiscUtils.registeredClientWorldData.put(modid + "|" + modid, dataString);
        } else {
            if (!DummyDataUtils.canWorkWithData()) {
                return;
            }
            globalConfig.func_74778_a(modid + "|" + modid, dataString);
            MiscUtils.registeredServerWorldData.put(modid + "|" + modid, dataString);
            DummyDataUtils.syncGlobalDataToClient(modid);
        }
    }

    public static String getGlobalDataForMod(String modid) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            return MiscUtils.registeredClientWorldData.get(modid + "|" + modid);
        }
        if (!MiscUtils.registeredServerWorldData.containsKey(modid + "|" + modid)) {
            DummyDataUtils.loadGlobalDataForMod(modid);
        }
        return MiscUtils.registeredServerWorldData.get(modid + "|" + modid);
    }

    public static String getCustomDataForMod(String modid, String dataName) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            return MiscUtils.registeredClientWorldData.get(modid + "|" + dataName);
        }
        if (!MiscUtils.registeredServerWorldData.containsKey(modid + "|" + dataName)) {
            DummyDataUtils.loadCustomDataForMod(modid, dataName);
        }
        return MiscUtils.registeredServerWorldData.get(modid + "|" + dataName);
    }

    public static void setDataForPlayer(String playerName, String modid, String dataName, String dataValue) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            MiscUtils.registeredClientData.put(playerName + "_" + modid + "|" + dataName, dataValue);
        } else {
            if (!DummyDataUtils.canWorkWithData()) {
                return;
            }
            NBTTagCompound tag = DummyDataUtils.getDataConfigForPlayer(playerName);
            tag.func_74778_a(modid + "|" + dataName, dataValue);
            MiscUtils.registeredServerData.put(playerName + "_" + modid + "|" + dataName, dataValue);
            DummyDataUtils.syncPlayerDataToClient(playerName, modid, dataName);
        }
    }

    public static void loadPlayerDataForMod(String playerName, String modid, String dataName) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            return;
        }
        if (!DummyDataUtils.canWorkWithData()) {
            return;
        }
        NBTTagCompound tag = DummyDataUtils.getDataConfigForPlayer(playerName);
        MiscUtils.registeredServerData.put(playerName + "_" + modid + "|" + dataName, tag.func_74779_i(modid + "|" + dataName));
        DummyDataUtils.syncPlayerDataToClient(playerName, modid, dataName);
    }

    public static String getDataForPlayer(String playerName, String modid, String dataName) {
        Side s = FMLCommonHandler.instance().getEffectiveSide();
        if (s == Side.CLIENT) {
            return MiscUtils.registeredClientData.get(playerName + "_" + modid + "|" + dataName);
        }
        if (!MiscUtils.registeredServerData.containsKey(playerName + "_" + modid + "|" + dataName)) {
            DummyDataUtils.loadPlayerDataForMod(playerName, modid, dataName);
        }
        return MiscUtils.registeredServerData.get(playerName + "_" + modid + "|" + dataName);
    }

    public static boolean canWorkWithData() {
        return isWorking;
    }

    public static void syncGlobalDataToClient(String modid, String dataName) {
        SyncUtils.addRequiresSync(modid, dataName);
    }

    public static void syncGlobalDataToClient(String modid) {
        SyncUtils.addRequiresSync(modid, modid);
    }

    public static void syncPlayerDataToClient(String playerName, String modid, String dataName) {
        SyncUtils.addRequiresSync(playerName, modid, dataName);
    }

    static {
        playerFiles = new Hashtable();
        playerConfigs = new Hashtable();
        clazz = DummyDataUtils.class;
    }
}

