/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Core.Core;
import DummyCore.Core.DCMod;
import DummyCore.Utils.Notifier;
import java.util.ArrayList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;

public class LoadingUtils {
    public static final ArrayList<String> knownBigASMModifiers = new ArrayList();

    public static void makeACrash(String message, Class<?> thrower, Throwable t, boolean shutdown) {
        DCMod[] ofsetters;
        Notifier.notify(shutdown ? Level.FATAL : Level.ERROR, "", "[ERROR]", "[DummyCoreLoader]", message);
        Notifier.notify(shutdown ? Level.FATAL : Level.ERROR, "", "[ERROR]", "[DummyCoreLoader]", "Loading errors were detected at state " + Loader.instance().getLoaderState() + "!");
        Notifier.notify(shutdown ? Level.FATAL : Level.ERROR, "", "[ERROR]", "[DummyCoreLoader]", "The class that has thrown the error: " + thrower);
        for (DCMod dCMod : ofsetters = LoadingUtils.tryDetermineOffendorsFromClasses(LoadingUtils.tryDetermineOffendorsFromTrace(t))) {
            Notifier.notify(shutdown ? Level.FATAL : Level.ERROR, "", "[ERROR]", "[DummyCoreLoader]", "Likely involved mod registered via DummyCore: " + dCMod);
        }
        for (DCMod dCMod : LoadingUtils.tryDetermineModOffendorsFromClasses(LoadingUtils.tryDetermineOffendorsFromTrace(t))) {
            Notifier.notify(shutdown ? Level.FATAL : Level.ERROR, "", "[ERROR]", "[DummyCoreLoader]", "Likely involved mod: " + dCMod.getName() + "[modid:" + dCMod.getModId() + ",modClasspath:" + (dCMod.getMod() != null ? dCMod.getMod().getClass() : "NULL{mod has no mod instance?}") + "]");
        }
        if (shutdown) {
            FMLCommonHandler.instance().getSidedDelegate().haltGame(message, t);
        }
    }

    public static void makeACrash(String message, Throwable t, boolean shutdown) {
        DCMod[] ofsetters;
        Notifier.notify(shutdown ? Level.FATAL : Level.ERROR, "", "[ERROR]", "[DummyCoreLoader]", "Loading errors were detected at state " + Loader.instance().getLoaderState() + "!");
        for (DCMod dCMod : ofsetters = LoadingUtils.tryDetermineOffendorsFromClasses(LoadingUtils.tryDetermineOffendorsFromTrace(t))) {
            Notifier.notify(shutdown ? Level.FATAL : Level.ERROR, "", "[ERROR]", "[DummyCoreLoader]", "Likely involved mod registered via DummyCore: " + dCMod);
        }
        for (DCMod dCMod : LoadingUtils.tryDetermineModOffendorsFromClasses(LoadingUtils.tryDetermineOffendorsFromTrace(t))) {
            Notifier.notify(shutdown ? Level.FATAL : Level.ERROR, "", "[ERROR]", "[DummyCoreLoader]", "Likely involved mod: " + dCMod.getName() + "[modid:" + dCMod.getModId() + ",modClasspath:" + (dCMod.getMod() != null ? dCMod.getMod().getClass() : "NULL{mod has no mod instance?}") + "]");
        }
        if (shutdown) {
            FMLCommonHandler.instance().getSidedDelegate().haltGame(message, t);
        }
    }

    public static Class<?>[] tryDetermineOffendorsFromTrace(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        Class[] offendors = new Class[elements.length];
        int i = -1;
        for (StackTraceElement ste : elements) {
            ++i;
            String clsName = ste.getClassName();
            try {
                Class<?> offendor = Class.forName(clsName);
                if (offendor == null) continue;
                offendors[i] = offendor;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return offendors;
    }

    public static DCMod[] tryDetermineOffendorsFromClasses(Class<?> ... detectedInTrace) {
        DCMod[] retMods = new DCMod[]{};
        for (Class<?> clazz : detectedInTrace) {
            if (!Core.isModRegistered(clazz)) continue;
            DCMod[] newArray = new DCMod[retMods.length + 1];
            System.arraycopy(retMods, 0, newArray, 0, retMods.length);
            newArray[newArray.length - 1] = Core.getModFromClass(clazz);
            retMods = newArray;
        }
        return retMods;
    }

    public static ModContainer[] tryDetermineModOffendorsFromClasses(Class<?> ... detectedInTrace) {
        ModContainer[] retMods = new ModContainer[]{};
        for (Class<?> clazz : detectedInTrace) {
            for (int i = 0; i < Loader.instance().getActiveModList().size(); ++i) {
                ModContainer mc = (ModContainer)Loader.instance().getActiveModList().get(i);
                if (mc.getMod() == null || !mc.getMod().getClass().equals(clazz)) continue;
                ModContainer[] newArray = new ModContainer[retMods.length + 1];
                System.arraycopy(retMods, 0, newArray, 0, retMods.length);
                newArray[newArray.length - 1] = mc;
                retMods = newArray;
            }
        }
        return retMods;
    }
}

