/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Client.IIRAwareModel;
import DummyCore.Client.IPosAwareModel;
import DummyCore.Client.RPAwareModel;
import DummyCore.Client.RenderAccessLibrary;
import DummyCore.Client.SBRHAwareModel;
import DummyCore.Utils.DummyConfig;
import DummyCore.Utils.IOldCubicBlock;
import DummyCore.Utils.Notifier;
import DummyCore.Utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;

public class OldTextureHandler {
    public static final ArrayList<Pair<String, Block>> oldBlocksToRender = new ArrayList();
    public static final Map<List<Object>, SBRHAwareModel> itemblockModels = new HashMap<List<Object>, SBRHAwareModel>();
    public static final ArrayList<Item> metadataIgnorantStacks = new ArrayList();
    public static final ArrayList<Pair<String, Item>> oldItemsToRender = new ArrayList();
    public static final Map<Item, RPAwareModel> itemsModels = new HashMap<Item, RPAwareModel>();
    public static final Map<Item, IIRAwareModel> iitemsModels = new HashMap<Item, IIRAwareModel>();

    public static boolean renderIS(ItemStack stk) {
        if (RenderAccessLibrary.hasHandlerFor(stk)) {
            RenderAccessLibrary.handleISRendering(stk);
            return true;
        }
        return false;
    }

    public static void addOldItem(String owner, Item i) {
        oldItemsToRender.add(new Pair<String, Item>(owner, i));
    }

    public static void addOldBlock(String owner, Block b) {
        oldBlocksToRender.add(new Pair<String, Block>(owner, b));
    }

    public static IBakedModel getIIRModel(ItemStack stk) {
        if (iitemsModels.containsKey(stk.func_77973_b())) {
            return (IBakedModel)iitemsModels.get(stk.func_77973_b());
        }
        IIRAwareModel iiram = new IIRAwareModel(stk.func_77973_b());
        iiram.rendered = stk;
        iitemsModels.put(stk.func_77973_b(), iiram);
        return iiram;
    }

    public static IBakedModel getModelForIS(ItemStack is, IBakedModel model) {
        if (is == null) {
            return model;
        }
        if (model == null) {
            if (is.func_77973_b() instanceof ItemBlock) {
                if (RenderAccessLibrary.irenderers.containsKey(is.func_77973_b())) {
                    return OldTextureHandler.getIIRModel(is);
                }
                int meta = metadataIgnorantStacks.contains(is.func_77973_b()) ? 0 : is.func_77960_j();
                List<Object> l = Arrays.asList(is.func_77973_b(), meta);
                if (itemblockModels.containsKey(l)) {
                    return itemblockModels.get(l).copy();
                }
            } else {
                if (itemsModels.containsKey(is.func_77973_b())) {
                    return itemsModels.get(is.func_77973_b()).copy();
                }
                if (RenderAccessLibrary.irenderers.containsKey(is.func_77973_b())) {
                    return OldTextureHandler.getIIRModel(is);
                }
            }
        }
        return model;
    }

    public static void reloadResourceManager(Map m) {
        if (DummyConfig.displaySorryNotificationUponRMReload) {
            Notifier.notifyWarn("DummyCore will now inject it's model wrappers into the game, thus allowing rendering of blocks without having to create .json files");
            Notifier.notifyWarn("Modbder is aware that this disallows the resource pack makers to edit the models of blocks added with this wrapper");
            Notifier.notifyWarn("However, Modbder is not going to create 2 .json files for each block added, so he chose to limit the resourcepack makers rather than wasting 90% of his time making useless jsons");
            Notifier.notifyWarn("If you are offended by this - Modbder is sorry, but he does not have much time to mess with jsons");
        }
        Notifier.notifyInfo("Starting to inject ISBRH IBakedModel wrappers...");
        itemblockModels.clear();
        metadataIgnorantStacks.clear();
        itemsModels.clear();
        RPAwareModel.mapped.clear();
        iitemsModels.clear();
        for (Pair<String, Block> pair : oldBlocksToRender) {
            Item i = Item.func_150898_a((Block)pair.getSecond());
            List<IBlockState> lst = ((IOldCubicBlock)IOldCubicBlock.class.cast(pair.getSecond())).listPossibleStates(pair.getSecond());
            if (lst == null || lst.isEmpty()) {
                m.put(pair.getSecond().func_176223_P(), new SBRHAwareModel(pair.getSecond(), pair.getSecond().func_176223_P()));
                metadataIgnorantStacks.add(i);
                itemblockModels.put(Arrays.asList(i, 0), new SBRHAwareModel(pair.getSecond(), pair.getSecond().func_176223_P()));
                continue;
            }
            for (IBlockState ibs : lst) {
                m.put(ibs, new SBRHAwareModel(pair.getSecond(), ibs));
                itemblockModels.put(Arrays.asList(i, pair.getSecond().func_176201_c(ibs)), new SBRHAwareModel(pair.getSecond(), ibs));
            }
        }
        Notifier.notifyInfo("Finished injecting ISBRH IBakedModel wrappers. Injected " + oldBlocksToRender.size() + " wrappers");
        Notifier.notifyInfo("Starting to inject item IBakedModel wrappers...");
        for (Pair<String, Block> pair : oldItemsToRender) {
            itemsModels.put((Item)pair.getSecond(), new RPAwareModel((Item)pair.getSecond()));
        }
        Notifier.notifyInfo("Finished injecting item IBakedModel wrappers. Injected " + oldItemsToRender.size() + " wrappers");
    }

    public static IBakedModel handleIWR(IBakedModel model, IBlockAccess world, BlockPos pos) {
        if (model instanceof IPosAwareModel) {
            return ((IPosAwareModel)IPosAwareModel.class.cast(model)).getModelFromWorldPos(world.func_180495_p(pos), world, pos);
        }
        return model;
    }
}

