/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.MiscUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class UnformedItemStack {
    public List<ItemStack> possibleStacks = new ArrayList<ItemStack>();

    public UnformedItemStack() {
    }

    public UnformedItemStack(String ... lst) {
        for (String s : lst) {
            this.possibleStacks.addAll(OreDictionary.getOres((String)s));
        }
        this.sort();
    }

    public UnformedItemStack(ItemStack is) {
        this.possibleStacks.add(is);
        this.sort();
    }

    public UnformedItemStack(String oreDictName) {
        this.possibleStacks.addAll(OreDictionary.getOres((String)oreDictName));
        this.sort();
    }

    public UnformedItemStack(List<?> lst) {
        for (Object obj1 : lst) {
            if (obj1 instanceof ItemStack) {
                this.possibleStacks.add((ItemStack)obj1);
                continue;
            }
            if (!(obj1 instanceof String)) continue;
            this.possibleStacks.addAll(OreDictionary.getOres((String)((String)obj1)));
        }
        this.sort();
    }

    public UnformedItemStack(ItemStack[] stk) {
        this.possibleStacks.addAll(Arrays.asList(stk));
        this.sort();
    }

    public UnformedItemStack(Block b) {
        this.possibleStacks.add(new ItemStack(b, 1, Short.MAX_VALUE));
        this.sort();
    }

    public UnformedItemStack(Item i) {
        this.possibleStacks.add(new ItemStack(i, 1, Short.MAX_VALUE));
        this.sort();
    }

    public UnformedItemStack(Object obj) {
        if (obj instanceof String[]) {
            for (String s : (String[])obj) {
                this.possibleStacks.addAll(OreDictionary.getOres((String)s));
            }
        }
        if (obj instanceof ItemStack) {
            this.possibleStacks.add((ItemStack)obj);
        }
        if (obj instanceof String) {
            this.possibleStacks.addAll(OreDictionary.getOres((String)((String)obj)));
        }
        if (obj instanceof List) {
            for (Object obj1 : (List)obj) {
                if (obj1 instanceof ItemStack) {
                    this.possibleStacks.add((ItemStack)obj1);
                    continue;
                }
                if (!(obj1 instanceof String)) continue;
                this.possibleStacks.addAll(OreDictionary.getOres((String)((String)obj1)));
            }
        }
        if (obj instanceof ItemStack[]) {
            this.possibleStacks.addAll(Arrays.asList((ItemStack[])obj));
        }
        if (obj instanceof Block) {
            this.possibleStacks.add(new ItemStack((Block)obj, 1, Short.MAX_VALUE));
        }
        if (obj instanceof Item) {
            this.possibleStacks.add(new ItemStack((Item)obj, 1, Short.MAX_VALUE));
        }
        this.sort();
    }

    public boolean matches(UnformedItemStack uis) {
        if (uis.possibleStacks.size() == this.possibleStacks.size()) {
            block0: for (int i = 0; i < this.possibleStacks.size(); ++i) {
                ItemStack is = this.possibleStacks.get(i);
                for (int j = 0; j < uis.possibleStacks.size(); ++j) {
                    ItemStack is1 = uis.possibleStacks.get(i);
                    if (MiscUtils.compareItemStacks(is, is1)) continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean itemStackMatches(ItemStack is) {
        if (is == null) {
            return false;
        }
        for (ItemStack s : this.possibleStacks) {
            if (!is.func_77969_a(s) && (!is.func_77973_b().equals(s.func_77973_b()) || s.func_77952_i() != Short.MAX_VALUE)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String str = "";
        for (ItemStack s : this.possibleStacks) {
            str = str + s;
        }
        return str;
    }

    public UnformedItemStack copy() {
        return new UnformedItemStack(this.possibleStacks);
    }

    public void nullify() {
        for (ItemStack s : this.possibleStacks) {
            s.field_77994_a = 0;
        }
    }

    public void sort() {
        ArrayList<ItemStack> possibleStacksCopy = new ArrayList<ItemStack>();
        possibleStacksCopy.addAll(this.possibleStacks);
        this.possibleStacks.clear();
        for (int i = 0; i < possibleStacksCopy.size(); ++i) {
            ItemStack is = (ItemStack)possibleStacksCopy.get(i);
            if (is == null || this.possibleStacks.contains(is)) continue;
            this.possibleStacks.add(is);
        }
        possibleStacksCopy.clear();
        possibleStacksCopy = null;
    }

    public ItemStack getISToDraw(long time) {
        int size = this.possibleStacks.size();
        if (size <= 0) {
            return null;
        }
        return this.possibleStacks.get((int)(time / 30L) % size);
    }

    public void writeToNBTTagCompound(NBTTagCompound tag) {
        NBTTagList items = new NBTTagList();
        for (ItemStack is : this.possibleStacks) {
            NBTTagCompound itemTag = new NBTTagCompound();
            is.func_77955_b(itemTag);
            items.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("unformedISList", (NBTBase)items);
    }

    public void readFromNBTTagCompound(NBTTagCompound tag) {
        NBTTagList items = tag.func_150295_c("unformedISList", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            this.possibleStacks.add(is);
        }
        this.sort();
    }
}

