/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.core.api.handler;

import cat.jiu.core.api.handler.IJsonSerializable;
import cat.jiu.core.api.handler.INBTSerializable;
import cat.jiu.core.api.handler.ISQLSerializable;
import cat.jiu.sql.SQLValues;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.minecraft.nbt.NBTTagCompound;

public interface ISerializable
extends IJsonSerializable,
INBTSerializable,
ISQLSerializable {
    default public <T> T writeTo(Class<T> type) {
        if (type == NBTTagCompound.class) {
            return (T)this.write(new NBTTagCompound());
        }
        if (type == JsonObject.class) {
            return (T)this.write(new JsonObject());
        }
        if (type == SQLValues.class) {
            return (T)this.write(new SQLValues());
        }
        return null;
    }

    default public <T> void readFrom(T e) {
        if (e instanceof NBTTagCompound) {
            this.read((NBTTagCompound)e);
        } else if (e instanceof JsonObject) {
            this.read((JsonObject)e);
        } else if (e instanceof ResultSet) {
            try {
                this.read((ResultSet)e);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }
}

