/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email;

import cat.jiu.email.EmailMain;
import cat.jiu.email.element.Email;
import cat.jiu.email.element.Inbox;
import cat.jiu.email.element.InboxText;
import cat.jiu.email.event.EmailSendEvent;
import cat.jiu.email.iface.IInboxText;
import cat.jiu.email.net.msg.MsgInboxToClient;
import cat.jiu.email.net.msg.MsgSend;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.JsonUtil;
import cat.jiu.email.util.SizeReport;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EmailAPI {
    private static final IInboxText SYSTEM = new InboxText("?????", new Object[0]);
    private static final List<String> whitelist = Lists.newArrayList();
    static String EmailPath = null;
    static String EmailRootPath = null;
    static String typePath = EmailAPI.getSaveEmailRootPath() + File.separator + "email" + File.separator + "type" + File.separator;
    static String exportPath = typePath + "export" + File.separator;
    public static final String globalEmailListPath = "./email.json";

    public static void sendPlayerEmail(EntityPlayer player, String addressee, Email email) {
        EmailAPI.sendEmail(player, EmailSendEvent.EmailSenderGroup.PLAYER, addressee, email);
    }

    public static void sendSystemEmail(EntityPlayer player, String addressee, Email email) {
        email.setSender(SYSTEM);
        EmailAPI.sendEmail(player, EmailSendEvent.EmailSenderGroup.SYSTEM, addressee, email);
    }

    public static void sendEmail(EntityPlayer player, EmailSendEvent.EmailSenderGroup group, String addresser, Email email) {
        if (player.field_70170_p.field_72995_K) {
            EmailMain.net.sendMessageToServer(new MsgSend(group, addresser, email));
        } else {
            EmailAPI.sendEmail(group, addresser, email);
        }
    }

    public static boolean sendEmail(EmailSendEvent.EmailSenderGroup group, String addresser, Email email) {
        EmailUtils.initNameAndUUID(EmailMain.server);
        Inbox inbox = Inbox.get(addresser);
        if (!EmailConfigs.isInfiniteSize() && email.hasItems() && !EmailAPI.checkEmailSize(inbox, email, email.getItems())) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EmailSendEvent(TickEvent.Phase.START, group, addresser, email))) {
            return false;
        }
        inbox.addEmail(email, true);
        MinecraftForge.EVENT_BUS.post((Event)new EmailSendEvent(TickEvent.Phase.END, group, addresser, email));
        if (EmailMain.server != null) {
            EntityPlayerMP player;
            try {
                player = EmailMain.server.func_184103_al().func_177451_a(UUID.fromString(addresser));
            }
            catch (Exception e) {
                player = EmailMain.server.func_184103_al().func_152612_a(addresser);
            }
            if (player != null) {
                EmailUtils.sendMessage((EntityPlayer)player, "info.email.from", email.getSender());
            }
        }
        return true;
    }

    private static boolean checkEmailSize(Inbox inbox, Email email, List<ItemStack> stacks) {
        SizeReport report = EmailUtils.checkEmailSize(email);
        if (!SizeReport.SUCCES.equals(report)) {
            return false;
        }
        long size = inbox.getInboxSize() + EmailUtils.getSize(email.writeTo(NBTTagCompound.class));
        return size < 0x200000L;
    }

    public static void addBlockReceiveWhitelist(String name) {
        if (!EmailAPI.isInBlockReceiveWhitelist(name)) {
            whitelist.add(name);
        }
    }

    public static boolean isInBlockReceiveWhitelist(String name) {
        return whitelist.contains(name);
    }

    public static String getSaveEmailRootPath() {
        if (EmailRootPath == null) {
            EmailRootPath = EmailConfigs.Save_To_Minecraft_Root_Directory || EmailMain.server == null ? "." : EmailMain.server.func_130014_f_().func_72860_G().func_75765_b().toString();
        }
        return EmailRootPath;
    }

    public static String getTypePath() {
        if (typePath == null) {
            typePath = EmailAPI.getSaveEmailRootPath() + File.separator + "email" + File.separator + "type" + File.separator;
        }
        return typePath;
    }

    public static String getExportPath() {
        if (exportPath == null) {
            exportPath = typePath + "export" + File.separator;
        }
        return exportPath;
    }

    public static String getSaveInboxPath() {
        if (EmailPath == null) {
            EmailPath = EmailAPI.getSaveEmailRootPath() + File.separator + "email" + File.separator;
        }
        return EmailPath;
    }

    public static void clearEmailPath() {
        EmailRootPath = null;
        EmailPath = null;
        typePath = null;
        exportPath = null;
    }

    public static boolean addToWhiteList(String name, UUID uid) {
        return EmailAPI.addToList(name, uid, false);
    }

    public static boolean addToWhiteList(EntityPlayer player) {
        return EmailAPI.addToWhiteList(player.func_70005_c_(), player.func_110124_au());
    }

    public static boolean addToBlackList(String name, UUID uid) {
        return EmailAPI.addToList(name, uid, true);
    }

    public static boolean addToBlackList(EntityPlayer player) {
        return EmailAPI.addToBlackList(player.func_70005_c_(), player.func_110124_au());
    }

    private static boolean addToList(String name, UUID uid, boolean black) {
        JsonElement e;
        Object e2;
        String theListName = black ? "BlackList" : "WhiteList";
        File jsonFile = new File(globalEmailListPath);
        JsonObject json = new JsonObject();
        if (jsonFile.exists() && (e2 = JsonUtil.parse(jsonFile)) != null && e2.isJsonObject()) {
            json = e2.getAsJsonObject();
        }
        JsonObject list = new JsonObject();
        if (json.has(theListName) && (e = json.get(theListName)).isJsonObject()) {
            list = e.getAsJsonObject();
        }
        list.addProperty(name, uid.toString());
        json.add(theListName, (JsonElement)list);
        return JsonUtil.toJsonFile(globalEmailListPath, json, false);
    }

    public static boolean isInWhiteList(EntityPlayer player) {
        return EmailAPI.isInList(player.func_70005_c_(), false) || EmailAPI.isInList(player.func_110124_au().toString(), false);
    }

    public static boolean isInWhiteList(UUID uid) {
        return EmailAPI.isInList(uid.toString(), false);
    }

    public static boolean isInWhiteList(String name) {
        return EmailAPI.isInList(name, false);
    }

    public static boolean isInBlackList(EntityPlayer player) {
        return EmailAPI.isInList(player.func_70005_c_(), true) || EmailAPI.isInList(player.func_110124_au().toString(), true);
    }

    public static boolean isInBlackList(UUID uid) {
        return EmailAPI.isInList(uid.toString(), true);
    }

    public static boolean isInBlackList(String name) {
        return EmailAPI.isInList(name, true);
    }

    private static boolean isInList(String str, boolean black) {
        JsonElement e;
        JsonObject json;
        Object jsonO;
        String inList = black ? "BlackList" : "WhiteList";
        File jsonFile = new File(globalEmailListPath);
        if (jsonFile.exists() && (jsonO = JsonUtil.parse(jsonFile)) != null && jsonO.isJsonObject() && (json = jsonO.getAsJsonObject()).has(inList) && (e = json.get(inList)).isJsonObject()) {
            if (e.getAsJsonObject().has(str)) {
                return true;
            }
            for (Map.Entry names : e.getAsJsonObject().entrySet()) {
                String listName = (String)names.getKey();
                String listUUID = ((JsonElement)names.getValue()).getAsString();
                if (!listName.equalsIgnoreCase(str) && !listUUID.equalsIgnoreCase(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean removeInWhiteList(EntityPlayer player) {
        return EmailAPI.removeInList(player.func_70005_c_(), false);
    }

    public static boolean removeInWhiteList(UUID uid) {
        return EmailAPI.removeInList(uid.toString(), false);
    }

    public static boolean removeInWhiteList(String name) {
        return EmailAPI.removeInList(name, false);
    }

    public static boolean removeInBlackList(EntityPlayer player) {
        return EmailAPI.removeInList(player.func_70005_c_(), true);
    }

    public static boolean removeInBlackList(UUID uid) {
        return EmailAPI.removeInList(uid.toString(), true);
    }

    public static boolean removeInBlackList(String name) {
        return EmailAPI.removeInList(name, true);
    }

    private static boolean removeInList(String name, boolean black) {
        JsonElement e;
        JsonObject json;
        Object jsonO;
        String inList = black ? "BlackList" : "WhiteList";
        File jsonFile = new File(globalEmailListPath);
        if (jsonFile.exists() && (jsonO = JsonUtil.parse(jsonFile)) != null && jsonO.isJsonObject() && (json = jsonO.getAsJsonObject()).has(inList) && (e = json.get(inList)).isJsonObject()) {
            JsonObject list = e.getAsJsonObject();
            if (list.has(name)) {
                list.remove(name);
                return JsonUtil.toJsonFile(globalEmailListPath, json, false);
            }
            for (Map.Entry names : Sets.newHashSet((Iterable)list.entrySet())) {
                String listName = (String)names.getKey();
                String listUUID = ((JsonElement)names.getValue()).getAsString();
                if (!listName.equalsIgnoreCase(name) && !listUUID.equalsIgnoreCase(name)) continue;
                list.remove(listName);
                return JsonUtil.toJsonFile(globalEmailListPath, json, false);
            }
        }
        return true;
    }

    public static void sendInboxToClient(Inbox inbox, EntityPlayerMP player) {
        EmailMain.execute(args -> EmailMain.net.sendMessageToPlayer(new MsgInboxToClient(inbox), player), 100L);
    }
}

