/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email;

import cat.jiu.core.api.handler.IFunction;
import cat.jiu.email.EmailAPI;
import cat.jiu.email.command.EmailCommands;
import cat.jiu.email.element.Cooling;
import cat.jiu.email.element.Inbox;
import cat.jiu.email.net.EmailNetworkHandler;
import cat.jiu.email.net.msg.MsgUnread;
import cat.jiu.email.net.msg.MsgUnreceive;
import cat.jiu.email.proxy.ServerProxy;
import cat.jiu.email.ui.EmailGuiHandler;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.EmailExecuteEvent;
import cat.jiu.email.util.EmailUtils;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="email", name="E-mail", version="1.0.3-a1", useMetadata=true, guiFactory="cat.jiu.email.util.client.ConfigGuiFactory", dependencies="after:jiucore", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class EmailMain {
    public static final String MODID = "email";
    public static final String NAME = "E-mail";
    public static final String OWNER = "small_jiu";
    public static final String VERSION = "1.0.3-a1";
    public static final EmailNetworkHandler net = new EmailNetworkHandler();
    public static final Logger log = LogManager.getLogger((String)"Email");
    public static final String SYSTEM = "?????";
    public static MinecraftServer server;
    public static final boolean SQLite_INIT;
    private static boolean isServerClosed;
    private static int unread;
    private static int unaccept;
    @SidedProxy(serverSide="cat.jiu.email.proxy.ServerProxy", clientSide="cat.jiu.email.proxy.ClientProxy", modId="email")
    public static ServerProxy proxy;

    public static boolean isServerClosed() {
        return isServerClosed;
    }

    public static int getUnread() {
        return unread;
    }

    public static void setUnread(int unread) {
        EmailMain.unread = unread;
    }

    public static int getUnaccept() {
        return unaccept;
    }

    public static void setAccept(int unaccept) {
        EmailMain.unaccept = unaccept;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new EmailGuiHandler();
        EmailAPI.addBlockReceiveWhitelist(SYSTEM);
        if (EmailConfigs.Send.Enable_Send_BlackList && EmailConfigs.Send.Enable_Send_WhiteList) {
            EmailConfigs.Send.Enable_Send_BlackList = false;
            EmailConfigs.Send.Enable_Send_WhiteList = false;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        server = event.getServer();
        isServerClosed = false;
        EmailAPI.clearEmailPath();
        EmailUtils.initNameAndUUID(event.getServer());
        EmailExecuteEvent.init();
        Cooling.load();
        event.registerServerCommand((ICommand)new EmailCommands());
    }

    @Mod.EventHandler
    public void onServerClosed(FMLServerStoppedEvent event) {
        server = null;
        Inbox.clearCache();
        isServerClosed = true;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            NBTTagCompound entityNBT = player.getEntityData();
            int time = 0;
            if (entityNBT.func_74764_b("Email_UnAcceptTime")) {
                time = entityNBT.func_74762_e("Email_UnAcceptTime");
            }
            if (time <= 0) {
                time = (int)EmailUtils.parseTick(0L, 0L, 0L, 15L, 0L);
                Inbox inbox = Inbox.get(player);
                if (inbox != null) {
                    int unread = inbox.getUnRead();
                    int unreceive = inbox.getUnReceived();
                    if (unread > 0) {
                        if (unreceive > 0) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.email.has_unread_and_unreceive", new Object[]{unread, unreceive}), true);
                            net.sendMessageToPlayer(new MsgUnreceive(unreceive), (EntityPlayerMP)player);
                            net.sendMessageToPlayer(new MsgUnread(unread), (EntityPlayerMP)player);
                        } else {
                            net.sendMessageToPlayer(new MsgUnread(unread), (EntityPlayerMP)player);
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.email.has_unread", new Object[]{unread}), true);
                        }
                    } else if (unreceive > 0) {
                        if (unread > 0) {
                            net.sendMessageToPlayer(new MsgUnreceive(unreceive), (EntityPlayerMP)player);
                            net.sendMessageToPlayer(new MsgUnread(unread), (EntityPlayerMP)player);
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.email.has_unread_and_unreceive", new Object[]{unread, unreceive}), true);
                        } else {
                            net.sendMessageToPlayer(new MsgUnreceive(unreceive), (EntityPlayerMP)player);
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.email.has_unreceive", new Object[]{unreceive}), true);
                        }
                    }
                }
            } else {
                --time;
            }
            entityNBT.func_74768_a("Email_UnAcceptTime", time);
        }
    }

    public static void execute(IFunction function) {
        EmailMain.execute(function, 50L);
    }

    public static void execute(IFunction function, long delay) {
        new Thread(() -> {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            function.run(new Object[0]);
        }).start();
    }

    static {
        isServerClosed = true;
        unread = 0;
        unaccept = 0;
        boolean init = false;
        try {
            Class.forName("org.sqlite.JDBC");
            init = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        SQLite_INIT = init;
    }
}

