/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.command;

import cat.jiu.email.EmailAPI;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.JsonToStackUtil;
import cat.jiu.email.util.JsonUtil;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

class CommandEmailExport
extends CommandBase {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    CommandEmailExport() {
    }

    public String func_71517_b() {
        return "export";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/email export [all]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("email.command.export.only_player", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (args.length >= 1 && args[0].equals("all")) {
            if (player.field_71071_by.func_70302_i_() < 1) {
                throw new CommandException("email.command.export.all.empty_item", new Object[0]);
            }
            JsonArray stacks = new JsonArray();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                stacks.add((JsonElement)JsonToStackUtil.toJson(stack));
            }
            String path = EmailAPI.getExportPath() + "inventory" + File.separator + dateFormat.format(new Date()) + ".json";
            JsonUtil.toJsonFile(path, stacks, false);
            try {
                player.func_145747_a(EmailUtils.createTextComponent(TextFormatting.GREEN, "email.command.export.all.success", new File(path).getCanonicalPath()));
            }
            catch (IOException e) {
                throw new CommandException(e.getLocalizedMessage(), new Object[0]);
            }
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            throw new CommandException("email.command.export.empty_item", new Object[0]);
        }
        ResourceLocation name = stack.func_77973_b().getRegistryName();
        String path = EmailAPI.getExportPath() + name.func_110624_b() + "@" + name.func_110623_a() + File.separator + dateFormat.format(new Date()) + ".json";
        JsonUtil.toJsonFile(path, JsonToStackUtil.toJson(stack), false);
        try {
            player.func_145747_a(EmailUtils.createTextComponent(TextFormatting.GREEN, "email.command.export.success", name.toString(), new File(path).getCanonicalPath()));
        }
        catch (IOException e) {
            throw new CommandException(e.getLocalizedMessage(), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return args.length == 1 ? Lists.newArrayList((Object[])new String[]{"all"}) : Collections.emptyList();
    }
}

