/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.command;

import cat.jiu.email.EmailAPI;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.EmailUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.command.CommandTreeBase;

class CommandEmailSendBlackList
extends CommandTreeBase {
    static final TextComponentTranslation black = new TextComponentTranslation("email.command.send.list.black", new Object[0]);

    CommandEmailSendBlackList() {
        super.addSubcommand((ICommand)new Add());
        super.addSubcommand((ICommand)new Remove());
    }

    public String func_71517_b() {
        return "blacklist";
    }

    public String func_71518_a(ICommandSender sender) {
        StringBuilder s = new StringBuilder("/email ");
        StringJoiner cmdName = new StringJoiner(", ", "<", ">");
        for (Map.Entry cmds : super.getCommandMap().entrySet()) {
            cmdName.add((CharSequence)cmds.getKey());
        }
        s.append(cmdName);
        return s.toString();
    }

    class Remove
    extends CommandBase {
        Remove() {
        }

        public String func_71517_b() {
            return "remove";
        }

        public String func_71518_a(ICommandSender sender) {
            return "email.command.send.black.remove";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (!EmailConfigs.Send.Enable_Send_BlackList) {
                throw new CommandException("email.command.send.list.unenable", new Object[]{black});
            }
            if (args.length < 1) {
                throw new CommandException(this.func_71518_a(sender), new Object[0]);
            }
            String argName = args[0];
            if (EmailAPI.isInBlackList(argName)) {
                boolean lag = EmailAPI.removeInBlackList(argName);
                if (!lag) {
                    throw new CommandException("email.command.send.list.error", new Object[0]);
                }
            } else {
                throw new CommandException("email.command.send.list.not_found_player", new Object[]{argName, black});
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("email.command.send.list.remove.success", new Object[]{argName, black}));
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
            return args.length == 1 ? Remove.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
        }
    }

    class Add
    extends CommandBase {
        Add() {
        }

        public String func_71517_b() {
            return "add";
        }

        public String func_71518_a(ICommandSender sender) {
            return "email.command.send.black.add";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (!EmailConfigs.Send.Enable_Send_BlackList) {
                throw new CommandException("email.command.send.list.unenable", new Object[]{black});
            }
            if (args.length < 1) {
                throw new CommandException(this.func_71518_a(sender), new Object[0]);
            }
            String argName = args[0];
            String name = null;
            UUID uid = null;
            EntityPlayerMP player = server.func_184103_al().func_152612_a(argName);
            if (player != null) {
                name = player.func_70005_c_();
                uid = player.func_110124_au();
            } else {
                EmailUtils.initNameAndUUID(server);
                UUID id = EmailUtils.getUUID(argName);
                if (id != null) {
                    uid = id;
                    name = EmailUtils.getName(uid);
                }
            }
            if (name != null && uid != null) {
                if (EmailAPI.isInBlackList(name) || EmailAPI.isInBlackList(uid)) {
                    throw new CommandException("email.command.send.list.already_exist", new Object[]{argName, black});
                }
                boolean lag = EmailAPI.addToBlackList(name, uid);
                if (!lag) {
                    throw new CommandException("email.command.send.list.error", new Object[0]);
                }
            } else {
                throw new CommandException("email.command.send.list.not_found_player", new Object[]{argName, black});
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("email.command.send.list.add.success", new Object[]{argName, black}));
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
            return args.length == 1 ? Add.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
        }
    }
}

