/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.element;

import cat.jiu.email.element.InboxText;
import cat.jiu.email.iface.IInboxText;
import cat.jiu.email.ui.SendEmailCoolingEvent;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.JsonUtil;
import cat.jiu.email.util.TimeMillis;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Cooling {
    private static final HashMap<String, Long> coolings = Maps.newHashMap();

    public static void cooling(String name) {
        Cooling.cooling(name, EmailUtils.getCoolingMillis());
    }

    public static void cooling(String name, TimeMillis time) {
        Cooling.cooling(name, time.millis);
    }

    public static void cooling(String name, long millis) {
        long m = System.currentTimeMillis() + millis;
        coolings.put(name, m);
        MinecraftForge.EVENT_BUS.post((Event)new SendEmailCoolingEvent(name, m));
        Cooling.save();
    }

    public static boolean isCooling(String name) {
        if (coolings.containsKey(name)) {
            return coolings.get(name) > System.currentTimeMillis();
        }
        return false;
    }

    public static long getCoolingTimeMillis(String name) {
        if (Cooling.isCooling(name)) {
            return coolings.get(name);
        }
        return 0L;
    }

    public static long getLastCoolingTimeMillis(String name) {
        if (Cooling.isCooling(name)) {
            return coolings.get(name) - System.currentTimeMillis();
        }
        return 0L;
    }

    public static IInboxText getLastCoolingTimeText(String name) {
        if (Cooling.isCooling(name)) {
            long last = Cooling.getLastCoolingTimeMillis(name);
            long t_t = last % 1000L;
            long t_s = last / 1000L;
            long t_m = 0L;
            if (t_s >= 60L) {
                t_m = t_s / 60L;
                t_s %= 60L;
            }
            long t_h = 0L;
            if (t_m >= 60L) {
                t_h = t_m / 60L;
                t_m %= 60L;
            }
            long t_d = 0L;
            if (t_h >= 24L) {
                t_d = t_h / 24L;
                t_h %= 24L;
            }
            String d = t_d < 10L ? "0" + t_d : Long.toString(t_d);
            String h = t_h < 10L ? "0" + t_h : Long.toString(t_h);
            String m = t_m < 10L ? "0" + t_m : Long.toString(t_m);
            String s = t_s < 10L ? "0" + t_s : Long.toString(t_s);
            String t = t_t < 10L ? "0" + t_t : Long.toString(t_t);
            return new InboxText("info.email.cooling", d, h, m, s, t);
        }
        return InboxText.empty;
    }

    public static void save() {
        JsonElement e;
        Object e2;
        File jsonFile = new File("./email.json");
        JsonObject json = new JsonObject();
        if (jsonFile.exists() && (e2 = JsonUtil.parse(jsonFile)) != null && e2.isJsonObject()) {
            json = e2.getAsJsonObject();
        }
        JsonObject list = new JsonObject();
        if (json.has("Cooling") && (e = json.get("Cooling")).isJsonObject()) {
            list = e.getAsJsonObject();
        }
        for (Map.Entry<String, Long> cooling : coolings.entrySet()) {
            list.addProperty(cooling.getKey(), (Number)cooling.getValue());
        }
        json.add("Cooling", (JsonElement)list);
        JsonUtil.toJsonFile("./email.json", json, false);
    }

    public static void load() {
        Object e;
        coolings.clear();
        File jsonFile = new File("./email.json");
        if (jsonFile.exists() && (e = JsonUtil.parse(jsonFile)) != null && e.isJsonObject() && e.getAsJsonObject().has("Cooling")) {
            for (Map.Entry cooling : e.getAsJsonObject().getAsJsonObject("Cooling").entrySet()) {
                coolings.put((String)cooling.getKey(), ((JsonElement)cooling.getValue()).getAsLong());
            }
        }
    }

    @Deprecated
    public static class CoolingMillis
    extends TimeMillis {
        public CoolingMillis(long millis) {
            this(0L, 0L, millis);
        }

        public CoolingMillis(long m, long s, long millis) {
            super(m, s, millis);
        }
    }
}

