/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.element;

import cat.jiu.core.api.handler.ISerializable;
import cat.jiu.email.element.InboxSound;
import cat.jiu.email.element.InboxText;
import cat.jiu.email.iface.IInboxSound;
import cat.jiu.email.iface.IInboxText;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.JsonToStackUtil;
import cat.jiu.email.util.TimeMillis;
import cat.jiu.sql.SQLValues;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class Email
implements ISerializable {
    protected IInboxText title;
    protected long create_time;
    protected String create_time_s;
    protected TimeMillis expiration_time;
    protected long expiration_time_l;
    protected IInboxText sender;
    protected IInboxSound sound;
    protected List<ItemStack> items;
    protected List<IInboxText> msgs;
    protected boolean read;
    protected boolean accept;
    protected long networkSize = -404L;
    public static final SimpleDateFormat old_dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    protected static NBTBase emptyTag = null;

    public Email(@Nonnull IInboxText title, @Nonnull IInboxText sender, IInboxSound sound, List<ItemStack> items, List<IInboxText> msgs) {
        this.title = title;
        this.create_time = System.currentTimeMillis();
        this.sender = sender;
        this.sound = sound;
        this.items = items;
        this.msgs = msgs;
    }

    public Email(NBTTagCompound nbt) {
        this.read(nbt);
    }

    public Email(JsonObject json) {
        this.read(json);
    }

    @Deprecated
    public String getTime() {
        return this.getCreateTimeAsString();
    }

    public long getCreateTimeAsTimestamp() {
        return this.create_time;
    }

    public String getCreateTimeAsString() {
        if (this.create_time_s == null) {
            this.create_time_s = EmailUtils.dateFormat.format(new Date(this.create_time));
        }
        return this.create_time_s;
    }

    public IInboxText getTitle() {
        return this.title;
    }

    public IInboxText getSender() {
        return this.sender;
    }

    public IInboxSound getSound() {
        return this.sound;
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isReceived() {
        return this.accept;
    }

    public List<ItemStack> getItems() {
        return Lists.newArrayList(this.items);
    }

    public List<IInboxText> getMsgs() {
        return this.msgs;
    }

    public long getEmailNetworkSize() {
        if (this.networkSize == -404L) {
            this.networkSize = EmailUtils.getSize(this.writeTo(NBTTagCompound.class));
        }
        return this.networkSize;
    }

    public void setSender(IInboxText sender) {
        this.sender = sender;
    }

    public void setTitle(IInboxText title) {
        this.title = title;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void setAccept(boolean accept) {
        this.accept = accept;
    }

    @Deprecated
    public void setTime(LocalDateTime time) {
        this.create_time = time.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        this.create_time_s = null;
    }

    @Deprecated
    public void setTime(Date time) {
        this.create_time = time.getTime();
        this.create_time_s = null;
    }

    public void setCreateTime(LocalDateTime time) {
        this.create_time = time.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        this.create_time_s = null;
    }

    public void setCreateTime(Date time) {
        this.create_time = time.getTime();
        this.create_time_s = null;
    }

    public void setCreateTimeToNow() {
        this.create_time = System.currentTimeMillis();
        this.create_time_s = null;
    }

    public void setExpirationTime(TimeMillis expiration_time) {
        if (this.expiration_time == null || this.expiration_time.millis == 0L) {
            this.expiration_time = expiration_time;
        }
    }

    public TimeMillis getExpirationTime() {
        return this.expiration_time;
    }

    public long getExpirationTimeAsTimestamp() {
        if (this.expiration_time_l == -404L || this.expiration_time_l <= 10L && this.expiration_time != null) {
            this.expiration_time_l = this.create_time + this.expiration_time.millis;
        }
        return this.expiration_time_l;
    }

    public ItemStack removeItem(int slot) {
        if (this.items != null && slot >= 0 && slot < this.items.size()) {
            return this.items.remove(slot);
        }
        return null;
    }

    public void clearItems() {
        if (this.items != null) {
            this.items.clear();
        }
    }

    public void addItems(List<ItemStack> stacks) {
        if (this.items == null) {
            this.items = Lists.newArrayList();
        }
        if (stacks != null && !stacks.isEmpty()) {
            for (int i = 0; i < stacks.size() && this.items.size() < 16; ++i) {
                this.items.add(stacks.get(i));
            }
        }
    }

    public void addItem(ItemStack stack) {
        if (this.items == null) {
            this.items = Lists.newArrayList();
        }
        if (stack != null && !stack.func_190926_b() && this.items.size() < 16) {
            this.items.add(stack);
        }
    }

    public ItemStack setItem(int slot, ItemStack newItem) {
        if (this.items != null && slot >= 0 && slot < this.items.size()) {
            return this.items.set(slot, newItem);
        }
        return null;
    }

    public void addMessage(String msg, Object ... args) {
        if (this.msgs == null) {
            this.msgs = Lists.newArrayList();
        }
        if (msg != null && !msg.isEmpty()) {
            this.msgs.add(new InboxText(msg, args));
        }
    }

    public boolean hasSound() {
        return this.sound != null;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public boolean hasMessages() {
        return this.msgs != null && !this.msgs.isEmpty();
    }

    public Email copy() {
        Email copy = new Email(this.title.copy(), this.sender.copy(), null, null, null);
        if (this.hasSound()) {
            copy.sound = this.sound.copy();
        }
        if (this.hasItems()) {
            copy.items = Lists.newArrayList(this.items);
        }
        if (this.hasMessages()) {
            copy.msgs = Lists.newArrayList(this.msgs);
        }
        return copy;
    }

    @Override
    public JsonObject write(JsonObject json) {
        if (json == null) {
            json = new JsonObject();
        }
        json.add("title", this.title.writeToJson());
        json.addProperty("time", (Number)this.create_time);
        if (this.expiration_time != null) {
            json.addProperty("expiration", (Number)this.expiration_time.millis);
        }
        json.add("sender", this.sender.writeToJson());
        if (this.read) {
            json.addProperty("read", Boolean.valueOf(true));
        }
        if (this.accept) {
            json.addProperty("accept", Boolean.valueOf(true));
        }
        if (this.hasSound()) {
            json.add("sound", (JsonElement)this.sound.write(new JsonObject()));
        }
        if (this.hasItems()) {
            json.add("items", (JsonElement)JsonToStackUtil.toJsonObject(this.items, false));
        }
        if (this.hasMessages()) {
            JsonObject msgs = new JsonObject();
            for (int i = 0; i < this.msgs.size(); ++i) {
                IInboxText msg = this.msgs.get(i);
                if (msg.getParameters() != null && msg.getParameters().length > 0) {
                    JsonArray arg = new JsonArray();
                    for (int j = 0; j < msg.getParameters().length; ++j) {
                        arg.add(String.valueOf(msg.getParameters()[j]));
                    }
                    msgs.add(msg.getText(), (JsonElement)arg);
                    continue;
                }
                msgs.add(msg.getText(), (JsonElement)JsonNull.INSTANCE);
            }
            json.add("msgs", (JsonElement)msgs);
        }
        return json;
    }

    @Override
    public void read(JsonObject json) {
        block19: {
            if (json == null || json.size() <= 0) break block19;
            this.title = new InboxText(json.get("title"));
            JsonElement time = json.get("time");
            if (time.isJsonPrimitive()) {
                JsonPrimitive p = time.getAsJsonPrimitive();
                if (p.isString()) {
                    try {
                        this.create_time = old_dateFormat.parse(p.getAsString()).getTime();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.create_time = System.currentTimeMillis();
                    }
                } else if (p.isNumber()) {
                    this.create_time = p.getAsLong();
                }
            }
            if (json.has("expiration")) {
                this.expiration_time = new TimeMillis(json.get("expiration").getAsLong());
                this.expiration_time_l = -404L;
            }
            this.sender = new InboxText(json.get("sender"));
            if (json.has("read")) {
                this.read = true;
            }
            if (json.has("accept")) {
                this.accept = true;
            }
            if (json.has("sound")) {
                this.sound = new InboxSound(json.get("sound").getAsJsonObject());
            }
            if (json.has("items")) {
                this.items = JsonToStackUtil.toStacks(json.get("items"));
            }
            if (json.has("msgs")) {
                this.msgs = Lists.newArrayList();
                JsonElement msgElement = json.get("msgs");
                if (msgElement.isJsonObject()) {
                    JsonObject msgs = msgElement.getAsJsonObject();
                    for (Map.Entry msg : msgs.entrySet()) {
                        String key = (String)msg.getKey();
                        JsonElement a = (JsonElement)msg.getValue();
                        if (a.isJsonArray()) {
                            JsonArray argJson = a.getAsJsonArray();
                            Object[] args = new Object[argJson.size()];
                            for (int i = 0; i < args.length; ++i) {
                                args[i] = argJson.get(i).getAsString();
                            }
                            this.msgs.add(new InboxText(key, args));
                            continue;
                        }
                        this.msgs.add(new InboxText(key, new Object[0]));
                    }
                } else if (msgElement.isJsonArray()) {
                    JsonArray msgs = msgElement.getAsJsonArray();
                    for (int i = 0; i < msgs.size(); ++i) {
                        this.msgs.add(new InboxText(msgs.get(i).getAsString(), new Object[0]));
                    }
                }
            }
        }
    }

    public static NBTBase getEmptyTag() {
        if (emptyTag == null) {
            emptyTag = new NBTTagByte(0);
        }
        return emptyTag;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound nbt) {
        int i;
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74782_a("title", this.title.writeToNBT());
        nbt.func_74772_a("time", this.create_time);
        if (this.expiration_time != null) {
            nbt.func_74772_a("expiration", this.expiration_time.millis);
        }
        nbt.func_74782_a("sender", this.sender.writeToNBT());
        if (this.read) {
            nbt.func_74757_a("read", true);
        }
        if (this.accept) {
            nbt.func_74757_a("accept", true);
        }
        if (this.hasSound()) {
            nbt.func_74782_a("sound", (NBTBase)this.sound.write(new NBTTagCompound()));
        }
        if (this.hasItems()) {
            NBTTagCompound items = new NBTTagCompound();
            for (i = 0; i < this.items.size(); ++i) {
                items.func_74782_a(Integer.toString(i), (NBTBase)this.items.get(i).func_77955_b(new NBTTagCompound()));
            }
            nbt.func_74782_a("items", (NBTBase)items);
        }
        if (this.hasMessages()) {
            NBTTagCompound msgs = new NBTTagCompound();
            for (i = 0; i < this.msgs.size(); ++i) {
                Object msgNBT;
                IInboxText msg = this.msgs.get(i);
                if (msg.getParameters() != null && msg.getParameters().length > 0) {
                    NBTTagCompound msgNBT0 = new NBTTagCompound();
                    NBTTagList args = new NBTTagList();
                    for (int j = 0; j < msg.getParameters().length; ++j) {
                        args.func_74742_a((NBTBase)new NBTTagString(String.valueOf(msg.getParameters()[i])));
                    }
                    msgNBT0.func_74778_a("text", msg.getText());
                    msgNBT0.func_74782_a("args", (NBTBase)args);
                    msgNBT = msgNBT0;
                } else {
                    msgNBT = !"".equals(msg.getText()) ? new NBTTagString(msg.getText()) : Email.getEmptyTag();
                }
                msgs.func_74782_a(String.valueOf(i), msgNBT);
            }
            nbt.func_74782_a("msgs", (NBTBase)msgs);
        }
        return nbt;
    }

    @Override
    public void read(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_186856_d() > 0) {
            this.title = new InboxText(nbt.func_74781_a("title"));
            this.create_time = nbt.func_74763_f("time");
            if (nbt.func_74764_b("expiration")) {
                this.expiration_time = new TimeMillis(nbt.func_74763_f("expiration"));
                this.expiration_time_l = -404L;
            }
            this.sender = new InboxText(nbt.func_74781_a("sender"));
            if (nbt.func_74764_b("read")) {
                this.read = true;
            }
            if (nbt.func_74764_b("accept")) {
                this.accept = true;
            }
            if (nbt.func_74764_b("sound")) {
                this.sound = new InboxSound(nbt.func_74775_l("sound"));
            }
            if (nbt.func_74764_b("items")) {
                this.items = Lists.newArrayList();
                NBTTagCompound items = nbt.func_74775_l("items");
                for (String item : items.func_150296_c()) {
                    this.items.add(new ItemStack(items.func_74775_l(item)));
                }
            }
            if (nbt.func_74764_b("msgs")) {
                this.msgs = Lists.newArrayList();
                NBTTagCompound msgs = nbt.func_74775_l("msgs");
                List<String> keys = msgs.func_150296_c().stream().sorted((key0, key1) -> Integer.valueOf(key0).compareTo(Integer.valueOf(key1))).collect(Collectors.toList());
                keys.forEach(key -> {
                    NBTBase msg = msgs.func_74781_a(key);
                    if (msg instanceof NBTTagString) {
                        this.msgs.add(new InboxText(((NBTTagString)msg).func_150285_a_(), new Object[0]));
                    } else if (msg instanceof NBTTagCompound) {
                        NBTTagCompound text = (NBTTagCompound)msg;
                        NBTTagList argsNBT = text.func_150295_c("args", 8);
                        Object[] args = new Object[argsNBT.func_74745_c()];
                        for (int i = 0; i < args.length; ++i) {
                            args[i] = argsNBT.func_150307_f(i);
                        }
                        this.msgs.add(new InboxText(text.func_74779_i("text"), args));
                    } else if (msg instanceof NBTTagByte) {
                        this.msgs.add(InboxText.empty);
                    }
                });
            }
        }
    }

    @Override
    public SQLValues write(SQLValues value) {
        return value;
    }

    @Override
    public void read(ResultSet result) throws SQLException {
    }

    public String toString() {
        return this.writeTo(JsonObject.class).toString();
    }

    public Email clone() {
        return this.copy();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accept ? 1231 : 1237);
        result = 31 * result + (int)(this.create_time ^ this.create_time >>> 32);
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.msgs == null ? 0 : this.msgs.hashCode());
        result = 31 * result + (this.read ? 1231 : 1237);
        result = 31 * result + (this.sender == null ? 0 : this.sender.hashCode());
        result = 31 * result + (this.sound == null ? 0 : this.sound.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Email other = (Email)obj;
        if (this.accept != other.accept) {
            return false;
        }
        if (this.create_time != other.create_time) {
            return false;
        }
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        if (this.msgs == null ? other.msgs != null : !this.msgs.equals(other.msgs)) {
            return false;
        }
        if (this.read != other.read) {
            return false;
        }
        if (this.sender == null ? other.sender != null : !this.sender.equals(other.sender)) {
            return false;
        }
        if (this.sound == null ? other.sound != null : !this.sound.equals(other.sound)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

