/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.element;

import cat.jiu.core.api.handler.ISerializable;
import cat.jiu.email.EmailAPI;
import cat.jiu.email.EmailMain;
import cat.jiu.email.element.Email;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.JsonUtil;
import cat.jiu.sql.SQLValues;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public final class Inbox
implements ISerializable {
    private static final HashMap<String, Inbox> inboxCache = Maps.newHashMap();
    private final HashMap<String, Object> customValue = Maps.newHashMap();
    private final LinkedHashMap<Long, Email> emails = Maps.newLinkedHashMap();
    private final ArrayList<String> senderBlacklist = Lists.newArrayList();
    private final String owner;
    private boolean dev;
    private long emailHistoryCount = 0L;
    static final List<String> old_version_black_key = Arrays.asList("dev", "custom", "historySize", "blacklist");

    private Inbox(UUID owner, NBTTagCompound inboxTag) {
        this.owner = owner.toString();
        this.read(inboxTag);
    }

    private Inbox(UUID owner, JsonObject inboxJson) {
        this(owner.toString(), inboxJson);
    }

    private Inbox(String owner, JsonObject inboxJson) {
        this.owner = owner;
        this.read(inboxJson);
    }

    public Set<Long> getEmailIDs() {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        Sets.newLinkedHashSet(this.emails.keySet()).forEach(e -> {
            if (this.getEmail((long)e) == null) {
                this.deleteEmail((long)e);
            } else {
                ids.add(e);
            }
        });
        return ids;
    }

    public boolean isEmptyInbox() {
        return this.emails.isEmpty();
    }

    public boolean isEmptyCustomValues() {
        return this.customValue.isEmpty();
    }

    public String getOwner() {
        return this.owner;
    }

    public UUID getOwnerAsUUID() {
        try {
            return UUID.fromString(this.owner);
        }
        catch (Exception e) {
            return EmailUtils.getUUID(this.owner);
        }
    }

    public int emailCount() {
        return this.emails.size();
    }

    public int customValueCount() {
        return this.customValue.size();
    }

    public boolean isSendDevMsg() {
        return this.dev;
    }

    public void setSendDevMsg(boolean dev) {
        this.dev = dev;
    }

    public long getInboxSize() {
        NBTTagCompound nbt = this.writeTo(NBTTagCompound.class);
        nbt.func_82580_o("historySize");
        nbt.func_82580_o("blacklist");
        nbt.func_82580_o("dev");
        return EmailUtils.getSize(nbt);
    }

    public int getUnRead() {
        int i = 0;
        try {
            for (Long id : this.getEmailIDs()) {
                if (this.getEmail(id).isRead()) continue;
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return i;
    }

    public int getUnReceived() {
        int i = 0;
        try {
            for (Long id : this.getEmailIDs()) {
                Email email = this.getEmail(id);
                if (!email.hasItems() || email.isReceived()) continue;
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return i;
    }

    public boolean hasEmail(long id) {
        return this.emails.containsKey(id);
    }

    public Email getEmail(long id) {
        return this.hasEmail(id) ? this.emails.get(id) : null;
    }

    public Email deleteEmail(long id) {
        Email old = this.hasEmail(id) ? (Email)this.emails.remove(id) : null;
        return old;
    }

    public Email setEmail(long id, Email newEmail) {
        return this.hasEmail(id) ? this.emails.put(id, newEmail) : null;
    }

    public boolean addEmail(Email email) {
        return this.addEmail(email, false);
    }

    public boolean addEmail(Email email, boolean saveToDisk) {
        return this.emails.put(this.emailHistoryCount++, email) == null && (!saveToDisk || EmailUtils.saveInboxToDisk(this));
    }

    public void addCustom(String key, Object value) {
        this.customValue.put(key, value);
    }

    public Object getCustom(String key) {
        return this.customValue.get(key);
    }

    public Object removeCustom(String key) {
        return this.customValue.remove(key);
    }

    public boolean hasCustomValue(String key) {
        return this.customValue.containsKey(key);
    }

    public HashMap<String, Object> getCustomValue() {
        return Maps.newHashMap(this.customValue);
    }

    public void addSenderBlacklist(String name) {
        this.senderBlacklist.add(name);
    }

    public boolean removeSenderBlacklist(String name) {
        return this.senderBlacklist.remove(name);
    }

    public boolean isInSenderBlacklist(String name) {
        return this.senderBlacklist.contains(name);
    }

    public ArrayList<String> getSenderBlacklist() {
        return Lists.newArrayList(this.senderBlacklist);
    }

    public boolean saveToDisk() {
        if (EmailMain.proxy.isClient() && !Minecraft.func_71410_x().func_71387_A()) {
            EmailMain.log.error("Client can not save inbox to Server!");
            return false;
        }
        if (EmailConfigs.Save_Inbox_To_SQL) {
            return EmailUtils.saveInboxToDB(this);
        }
        return JsonUtil.toJsonFile(EmailAPI.getSaveInboxPath() + this.owner + ".json", this.writeTo(JsonObject.class), false);
    }

    public Inbox readFromDisk() {
        return this.readFromDisk(EmailUtils.getInboxJson(this.owner));
    }

    private Inbox readFromDisk(JsonObject json) {
        this.emails.clear();
        this.customValue.clear();
        this.dev = false;
        this.readFrom(json);
        return this;
    }

    @Override
    public JsonObject write(JsonObject json) {
        if (json == null) {
            json = new JsonObject();
        }
        if (this.dev) {
            json.addProperty("dev", Boolean.valueOf(true));
        }
        json.addProperty("historySize", (Number)(this.emailHistoryCount > 0L && this.emailHistoryCount > (long)this.emails.size() ? this.emailHistoryCount : (long)this.emails.size()));
        if (!this.senderBlacklist.isEmpty()) {
            JsonArray list = new JsonArray();
            this.senderBlacklist.forEach(s -> list.add(s));
            json.add("blacklist", (JsonElement)list);
        }
        if (!this.isEmptyInbox()) {
            JsonObject emails = new JsonObject();
            for (Map.Entry<Object, Object> entry : this.emails.entrySet()) {
                emails.add(String.valueOf(entry.getKey()), (JsonElement)((Email)entry.getValue()).writeTo(JsonObject.class));
            }
            json.add("emails", (JsonElement)emails);
        }
        if (!this.isEmptyCustomValues()) {
            JsonObject customObj = new JsonObject();
            for (Map.Entry<Object, Object> entry : this.customValue.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Integer) {
                    customObj.addProperty((String)entry.getKey(), (Number)((Integer)value));
                    continue;
                }
                if (value instanceof Boolean) {
                    customObj.addProperty((String)entry.getKey(), (Boolean)value);
                    continue;
                }
                customObj.addProperty((String)entry.getKey(), String.valueOf(value));
            }
            json.add("custom", (JsonElement)customObj);
        }
        return json;
    }

    @Override
    public void read(JsonObject json) {
        if (json != null && json.size() > 0) {
            long historySize;
            if (json.has("dev")) {
                this.dev = json.get("dev").getAsBoolean();
            }
            if (json.has("custom")) {
                for (Object custom : json.getAsJsonObject("custom").entrySet()) {
                    JsonElement value = (JsonElement)custom.getValue();
                    if (!value.isJsonPrimitive()) continue;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (primitive.isBoolean()) {
                        this.customValue.put((String)custom.getKey(), primitive.getAsBoolean());
                        continue;
                    }
                    if (primitive.isNumber()) {
                        this.customValue.put((String)custom.getKey(), primitive.getAsNumber());
                        continue;
                    }
                    this.customValue.put((String)custom.getKey(), primitive.getAsString());
                }
            }
            if (json.has("blacklist")) {
                json.getAsJsonArray("blacklist").forEach(e -> {
                    String name = e.getAsString();
                    if (!this.isInSenderBlacklist(name)) {
                        this.addSenderBlacklist(name);
                    }
                });
            }
            if (json.has("emails")) {
                JsonObject emails = json.getAsJsonObject("emails");
                for (Map.Entry email : emails.entrySet()) {
                    this.emails.put(Long.valueOf((String)email.getKey()), new Email(((JsonElement)email.getValue()).getAsJsonObject()));
                }
            } else {
                for (Map.Entry emails : json.entrySet()) {
                    if (old_version_black_key.contains(emails.getKey())) continue;
                    this.emails.put(Long.valueOf((String)emails.getKey()), new Email(((JsonElement)emails.getValue()).getAsJsonObject()));
                }
            }
            this.emailHistoryCount = this.emails.size();
            if (json.has("historySize") && (historySize = json.get("historySize").getAsLong()) > (long)this.emails.size()) {
                this.emailHistoryCount = historySize;
            }
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound nbt) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (this.dev) {
            nbt.func_74757_a("dev", true);
        }
        nbt.func_74772_a("historySize", this.emailHistoryCount > 0L && this.emailHistoryCount > (long)this.emails.size() ? this.emailHistoryCount : (long)this.emails.size());
        if (!this.isEmptyInbox()) {
            NBTTagCompound emails = new NBTTagCompound();
            for (Map.Entry<Object, Object> entry : this.emails.entrySet()) {
                emails.func_74782_a(String.valueOf(entry.getKey()), (NBTBase)((Email)entry.getValue()).writeTo(NBTTagCompound.class));
            }
            nbt.func_74782_a("emails", (NBTBase)emails);
        }
        if (!this.isEmptyCustomValues()) {
            NBTTagCompound cutsomTag = new NBTTagCompound();
            for (Map.Entry<Object, Object> entry : this.customValue.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Integer) {
                    cutsomTag.func_74768_a((String)entry.getKey(), ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    cutsomTag.func_74757_a((String)entry.getKey(), ((Boolean)value).booleanValue());
                    continue;
                }
                cutsomTag.func_74778_a((String)entry.getKey(), String.valueOf(value));
            }
            nbt.func_74782_a("custom", (NBTBase)cutsomTag);
        }
        if (!this.senderBlacklist.isEmpty()) {
            NBTTagList list = new NBTTagList();
            this.senderBlacklist.forEach(s -> list.func_74742_a((NBTBase)new NBTTagString(s)));
            nbt.func_74782_a("blacklist", (NBTBase)list);
        }
        return nbt;
    }

    @Override
    public void read(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_186856_d() > 0) {
            long historySize;
            NBTTagCompound emailTag;
            if (nbt.func_74764_b("dev")) {
                this.dev = nbt.func_74767_n("dev");
            }
            if (nbt.func_74764_b("custom")) {
                NBTTagCompound customTag = nbt.func_74775_l("custom");
                for (String custom : customTag.func_150296_c()) {
                    NBTBase customValue = customTag.func_74781_a(custom);
                    if (customValue instanceof NBTTagByte) {
                        this.customValue.put(custom, ((NBTTagByte)customValue).func_150290_f() == 1);
                        continue;
                    }
                    if (customValue instanceof NBTTagInt) {
                        this.customValue.put(custom, ((NBTTagInt)customValue).func_150287_d());
                        continue;
                    }
                    this.customValue.put(custom, customValue.toString());
                }
            }
            if (nbt.func_74764_b("emails") && (emailTag = nbt.func_74775_l("emails")).func_186856_d() > 0) {
                for (String emailKey : emailTag.func_150296_c()) {
                    this.emails.put(Long.valueOf(emailKey), new Email(emailTag.func_74775_l(emailKey)));
                }
            }
            this.emailHistoryCount = this.emails.size();
            if (nbt.func_74764_b("historySize") && (historySize = nbt.func_74763_f("historySize")) > (long)this.emails.size()) {
                this.emailHistoryCount = historySize;
            }
            if (nbt.func_74764_b("blacklist")) {
                nbt.func_150295_c("blacklist", 8).forEach(s -> {
                    String name = ((NBTTagString)s).func_150285_a_();
                    if (!this.isInSenderBlacklist(name)) {
                        this.addSenderBlacklist(name);
                    }
                });
            }
        }
    }

    @Override
    public SQLValues write(SQLValues value) {
        if (value == null) {
            value = new SQLValues();
        }
        value.put("uuid", this.getOwner());
        value.put("inbox", this.writeTo(JsonObject.class));
        return value;
    }

    @Override
    public void read(ResultSet result) throws SQLException {
        if (result.next()) {
            this.read(JsonUtil.parser.parse(result.getString("inbox")).getAsJsonObject());
        }
    }

    public String toString() {
        return this.write(new JsonObject()).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customValue == null ? 0 : this.customValue.hashCode());
        result = 31 * result + (this.dev ? 1231 : 1237);
        result = 31 * result + (int)(this.emailHistoryCount ^ this.emailHistoryCount >>> 32);
        result = 31 * result + (this.emails == null ? 0 : this.emails.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.senderBlacklist == null ? 0 : this.senderBlacklist.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Inbox other = (Inbox)obj;
        if (this.customValue == null ? other.customValue != null : !this.customValue.equals(other.customValue)) {
            return false;
        }
        if (this.dev != other.dev) {
            return false;
        }
        if (this.emailHistoryCount != other.emailHistoryCount) {
            return false;
        }
        if (this.emails == null ? other.emails != null : !this.emails.equals(other.emails)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        return !(this.senderBlacklist == null ? other.senderBlacklist != null : !this.senderBlacklist.equals(other.senderBlacklist));
    }

    public static Inbox get(@Nonnull EntityPlayer player) {
        return Inbox.get(player.func_110124_au().toString());
    }

    public static Inbox get(@Nonnull UUID uid) {
        return Inbox.get(uid.toString());
    }

    public static Inbox get(@Nonnull String owner) {
        block3: {
            if (inboxCache.containsKey(owner)) {
                return inboxCache.get(owner).readFromDisk();
            }
            try {
                owner = UUID.fromString(owner).toString();
            }
            catch (Exception e) {
                if (!EmailUtils.hasName(owner)) break block3;
                owner = EmailUtils.getUUID(owner).toString();
            }
        }
        Inbox inbox = new Inbox(owner, EmailUtils.getInboxJson(owner));
        inboxCache.put(owner, inbox);
        Inbox.checkExpirationEmail(inbox);
        return inbox;
    }

    public static Inbox get(@Nonnull UUID uid, NBTTagCompound inboxTag) {
        Inbox inbox;
        if (inboxTag == null) {
            return null;
        }
        if (inboxCache.containsKey(uid.toString())) {
            inbox = inboxCache.get(uid.toString());
            inbox.emails.clear();
            inbox.customValue.clear();
            inbox.dev = false;
            inbox.senderBlacklist.clear();
            inbox.read(inboxTag);
        } else {
            inbox = new Inbox(uid, inboxTag);
            inboxCache.put(uid.toString(), inbox);
        }
        Inbox.checkExpirationEmail(inbox);
        return inbox;
    }

    public static Inbox get(@Nonnull UUID uid, JsonObject inboxJson) {
        Inbox inbox;
        if (inboxJson == null) {
            return null;
        }
        if (inboxCache.containsKey(uid.toString())) {
            inbox = inboxCache.get(uid.toString()).readFromDisk(inboxJson);
        } else {
            inbox = new Inbox(uid, inboxJson);
            inboxCache.put(uid.toString(), inbox);
        }
        Inbox.checkExpirationEmail(inbox);
        return inbox;
    }

    public static void checkExpirationEmail(Inbox inbox) {
        long sys = System.currentTimeMillis();
        boolean hasExpiration = false;
        for (Long id : inbox.getEmailIDs()) {
            Email email = inbox.getEmail(id);
            if (email.getExpirationTime() == null || sys < email.getExpirationTimeAsTimestamp()) continue;
            inbox.deleteEmail(id);
            hasExpiration = true;
        }
        if (hasExpiration) {
            EmailUtils.saveInboxToDisk(inbox);
        }
    }

    public static void clearCache() {
        if (EmailMain.isServerClosed()) {
            inboxCache.clear();
        }
    }
}

