/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.element;

import cat.jiu.email.element.InboxTime;
import cat.jiu.email.iface.IInboxSound;
import cat.jiu.email.iface.IInboxTime;
import com.google.gson.JsonObject;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;

public class InboxSound
implements IInboxSound {
    protected SoundEvent sound;
    protected float volume;
    protected float pitch;
    protected IInboxTime time;

    public InboxSound(NBTTagCompound nbt) {
        this.read(nbt);
    }

    public InboxSound(JsonObject json) {
        this.read(json);
    }

    public InboxSound(IInboxTime soundTime, SoundEvent sound, float volume, float pitch) {
        this.setSound(sound);
        this.setSoundVolume(volume);
        this.setSoundPitch(pitch);
        this.setTime(soundTime);
    }

    @Override
    public SoundEvent getSound() {
        return this.sound;
    }

    @Override
    public InboxSound setSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    @Override
    public float getSoundVolume() {
        return this.volume;
    }

    @Override
    public InboxSound setSoundVolume(float volume) {
        this.volume = volume;
        return this;
    }

    @Override
    public float getSoundPitch() {
        return this.pitch;
    }

    @Override
    public InboxSound setSoundPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    @Override
    public IInboxTime getTime() {
        return this.time;
    }

    @Override
    public IInboxSound setTime(IInboxTime time) {
        this.time = time;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.pitch);
        result = 31 * result + (this.sound == null ? 0 : this.sound.hashCode());
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        result = 31 * result + Float.floatToIntBits(this.volume);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InboxSound other = (InboxSound)obj;
        if (Float.floatToIntBits(this.pitch) != Float.floatToIntBits(other.pitch)) {
            return false;
        }
        if (this.sound == null ? other.sound != null : !this.sound.equals(other.sound)) {
            return false;
        }
        if (this.time == null ? other.time != null : !this.time.equals(other.time)) {
            return false;
        }
        return Float.floatToIntBits(this.volume) == Float.floatToIntBits(other.volume);
    }

    @Deprecated
    public static InboxSound from(NBTTagCompound nbt) {
        if (nbt != null) {
            return new InboxSound(new InboxTime(nbt.func_74763_f("millis")), (SoundEvent)SoundEvent.field_187505_a.func_148754_a(nbt.func_74762_e("sound")), nbt.func_74760_g("volume"), nbt.func_74760_g("pitch"));
        }
        return null;
    }

    @Deprecated
    public static InboxSound from(JsonObject json) {
        if (json != null && json.size() > 0) {
            return new InboxSound(new InboxTime(json.get("millis").getAsLong()), (SoundEvent)SoundEvent.field_187505_a.func_148754_a(json.get("id").getAsInt()), json.get("volume").getAsFloat(), json.get("pitch").getAsFloat());
        }
        return null;
    }
}

