/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.element;

import cat.jiu.email.iface.IInboxTime;

public class InboxTime
implements IInboxTime {
    private final long original;
    private long tick;

    public InboxTime(long tick) {
        this(0L, 0L, tick);
    }

    public InboxTime(long m, long s, long tick) {
        this.original = this.tick = InboxTime.parseTick(0L, 0L, m, s, tick);
    }

    public static long parseTick(long day, long h, long m, long s, long tick) {
        return (((day * 24L + h) * 60L + m) * 60L + s) * 20L + tick;
    }

    @Override
    public long getAllTicks() {
        return this.original;
    }

    @Override
    public void update() {
        --this.tick;
    }

    @Override
    public InboxTime reset() {
        this.tick = this.original;
        return this;
    }

    @Override
    public long getDay() {
        return this.tick / 20L / 60L / 60L / 24L;
    }

    @Override
    public long getHour() {
        return this.tick / 20L / 60L / 60L % 24L;
    }

    @Override
    public long getMinute() {
        return this.tick / 20L / 60L % 60L;
    }

    @Override
    public long getSecond() {
        return this.tick / 20L % 60L;
    }

    @Override
    public long getTick() {
        return this.tick % 20L;
    }
}

