/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.event;

import cat.jiu.email.element.Email;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Cancelable
public class EmailSendEvent
extends Event {
    public final TickEvent.Phase phase;
    public final EmailSenderGroup group;
    public final String addresser;
    public final Email email;

    public EmailSendEvent(TickEvent.Phase phase, EmailSenderGroup group, String addresser, Email email) {
        this.phase = phase;
        this.group = group;
        this.addresser = addresser;
        this.email = email;
    }

    public final void setCanceled(boolean cancel) {
        if (this.phase == TickEvent.Phase.START) {
            super.setCanceled(cancel);
        }
    }

    public static enum EmailSenderGroup {
        SYSTEM,
        PLAYER;


        public static EmailSenderGroup getGroupByID(int id) {
            switch (id) {
                case 1: {
                    return PLAYER;
                }
            }
            return SYSTEM;
        }

        public static int getIDByGroup(EmailSenderGroup sender) {
            switch (sender) {
                case PLAYER: {
                    return 1;
                }
            }
            return 0;
        }

        public boolean isPlayerSend() {
            return this == PLAYER;
        }

        public boolean isSystemSend() {
            return this == SYSTEM;
        }
    }

    @Deprecated
    public static class Post
    extends Event {
        public final MinecraftServer server;
        public final EmailSenderGroup group;
        public final UUID addresser;
        public final Email email;

        public Post(MinecraftServer server, EmailSenderGroup group, UUID addresser, Email email) {
            this.server = server;
            this.group = group;
            this.addresser = addresser;
            this.email = email;
        }
    }

    @Deprecated
    @Cancelable
    public static class Pre
    extends Event {
        public final MinecraftServer server;
        public final EmailSenderGroup group;
        public final String addresserName;
        public final UUID addresserUID;
        public final Email email;

        public Pre(MinecraftServer server, EmailSenderGroup group, String addresserName, UUID addresserUID, Email email) {
            this.server = server;
            this.group = group;
            this.addresserName = addresserName;
            this.addresserUID = addresserUID;
            this.email = email;
        }
    }
}

