/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.iface;

import cat.jiu.email.element.Email;
import cat.jiu.email.element.InboxText;
import cat.jiu.email.event.InboxTextFormatEvent;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IInboxText {
    public String getText();

    public void setText(String var1);

    public Object[] getParameters();

    public void setParameters(Object ... var1);

    @SideOnly(value=Side.CLIENT)
    default public String format() {
        InboxTextFormatEvent event = new InboxTextFormatEvent(this.getText(), this.getParameters());
        if (MinecraftForge.EVENT_BUS.post((Event)event) && event.getFormatResult() != null) {
            return event.getFormatResult();
        }
        return I18n.func_135052_a((String)this.getText(), (Object[])IInboxText.format(this.getParameters()));
    }

    @SideOnly(value=Side.CLIENT)
    public static Object[] format(Object ... args) {
        Object[] arg = Arrays.copyOf(args, args.length);
        for (int i = 0; i < arg.length; ++i) {
            Object object = arg[i];
            if (!(object instanceof IInboxText)) continue;
            arg[i] = ((IInboxText)object).format();
        }
        return arg;
    }

    @SideOnly(value=Side.CLIENT)
    default public int getStringWidth(FontRenderer fr) {
        return fr.func_78256_a(this.format());
    }

    default public TextComponentTranslation toTextComponent() {
        return new TextComponentTranslation(this.getText(), this.getParameters());
    }

    default public NBTBase writeToNBT() {
        Object nbt = null;
        if (this.getParameters() != null && this.getParameters().length > 0) {
            nbt = new NBTTagCompound();
            ((NBTTagCompound)nbt).func_74778_a("key", this.getText());
            NBTTagList args = new NBTTagList();
            for (int i = 0; i < this.getParameters().length; ++i) {
                Object tag = this.getParameters()[i] instanceof IInboxText ? ((IInboxText)this.getParameters()[i]).writeToNBT() : new NBTTagString(String.valueOf(this.getParameters()[i]));
                args.func_74742_a(tag);
            }
            ((NBTTagCompound)nbt).func_74782_a("args", (NBTBase)args);
        } else {
            nbt = !"".equals(this.getText()) ? new NBTTagString(this.getText()) : Email.getEmptyTag();
        }
        return nbt;
    }

    default public void readFromNBT(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            this.setText(((NBTTagCompound)nbt).func_74779_i("key"));
            if (((NBTTagCompound)nbt).func_74764_b("args")) {
                NBTTagList args = ((NBTTagCompound)nbt).func_150295_c("args", 8);
                this.setParameters(new Object[args.func_74745_c()]);
                for (int i = 0; i < this.getParameters().length; ++i) {
                    NBTBase tag = args.func_179238_g(i);
                    this.getParameters()[i] = tag instanceof NBTTagCompound ? new InboxText(tag) : args.func_150307_f(i);
                }
            }
        } else if (nbt instanceof NBTTagString) {
            this.setText(((NBTTagString)nbt).func_150285_a_());
        }
    }

    default public JsonElement writeToJson() {
        Object e = null;
        if (this.getParameters() != null && this.getParameters().length > 0) {
            e = new JsonObject();
            e.getAsJsonObject().addProperty("key", this.getText());
            JsonArray args = new JsonArray();
            for (int i = 0; i < this.getParameters().length; ++i) {
                Object tag = this.getParameters()[i] instanceof IInboxText ? ((IInboxText)this.getParameters()[i]).writeToJson() : new JsonPrimitive(String.valueOf(this.getParameters()[i]));
                args.add(tag);
            }
            e.getAsJsonObject().add("args", (JsonElement)args);
        } else {
            e = !"".equals(this.getText()) ? new JsonPrimitive(this.getText()) : JsonNull.INSTANCE;
        }
        return e;
    }

    default public void readFromJson(JsonElement json) {
        if (json instanceof JsonObject) {
            this.setText(json.getAsJsonObject().get("key").getAsString());
            if (json.getAsJsonObject().has("args")) {
                JsonArray args = json.getAsJsonObject().getAsJsonArray("args");
                Object[] arg = new Object[args.size()];
                for (int i = 0; i < arg.length; ++i) {
                    JsonElement e = args.get(i);
                    arg[i] = e.isJsonObject() ? new InboxText(e) : e.getAsString();
                }
                this.setParameters(arg);
            }
        } else if (json instanceof JsonPrimitive) {
            this.setText(json.getAsString());
        }
    }

    default public IInboxText copy() {
        return new InboxText(this.writeToNBT());
    }
}

