/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.net.msg;

import cat.jiu.email.element.Inbox;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class MsgBlacklist
implements IMessage {
    protected String name;

    public MsgBlacklist() {
    }

    public MsgBlacklist(String name) {
        this.name = name;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.name = new PacketBuffer(buf).func_150793_b().func_74779_i("name");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        new PacketBuffer(buf).func_150786_a(nbt);
    }

    public abstract IMessage handler(MessageContext var1);

    public static class Remove
    extends MsgBlacklist {
        public Remove() {
        }

        public Remove(String name) {
            super(name);
        }

        @Override
        public IMessage handler(MessageContext ctx) {
            if (ctx.side.isServer()) {
                Inbox inbox = Inbox.get((EntityPlayer)ctx.getServerHandler().field_147369_b);
                inbox.removeSenderBlacklist(this.name);
                inbox.saveToDisk();
            }
            return null;
        }
    }

    public static class Add
    extends MsgBlacklist {
        public Add() {
        }

        public Add(String name) {
            super(name);
        }

        @Override
        public IMessage handler(MessageContext ctx) {
            Inbox inbox;
            if (ctx.side.isServer() && !(inbox = Inbox.get((EntityPlayer)ctx.getServerHandler().field_147369_b)).isInSenderBlacklist(this.name)) {
                inbox.addSenderBlacklist(this.name);
                inbox.saveToDisk();
            }
            return null;
        }
    }
}

