/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.net.msg;

import cat.jiu.email.EmailAPI;
import cat.jiu.email.element.Email;
import cat.jiu.email.element.Inbox;
import cat.jiu.email.event.EmailDeleteEvent;
import cat.jiu.email.util.EmailUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MsgDeleteEmail {

    public static class AllReceive
    implements IMessage {
        public void fromBytes(ByteBuf buf) {
        }

        public void toBytes(ByteBuf buf) {
        }

        public IMessage handler(MessageContext ctx) {
            if (ctx.side.isServer()) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                WorldServer world = player.func_71121_q();
                world.func_152344_a(() -> {
                    Inbox inbox = Inbox.get((EntityPlayer)player);
                    for (long i : inbox.getEmailIDs()) {
                        Email email = inbox.getEmail(i);
                        if (email.isReceived() && !MinecraftForge.EVENT_BUS.post((Event)new EmailDeleteEvent.Pre(inbox, i, false, true))) {
                            inbox.deleteEmail(i);
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new EmailDeleteEvent.Post(inbox, i, false, true));
                    }
                    EmailUtils.saveInboxToDisk(inbox);
                    EmailAPI.sendInboxToClient(inbox, player);
                });
            }
            return null;
        }
    }

    public static class AllRead
    implements IMessage {
        public void fromBytes(ByteBuf buf) {
        }

        public void toBytes(ByteBuf buf) {
        }

        public IMessage handler(MessageContext ctx) {
            if (ctx.side.isServer()) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                WorldServer world = player.func_71121_q();
                world.func_152344_a(() -> {
                    Inbox inbox = Inbox.get((EntityPlayer)player);
                    for (long i : inbox.getEmailIDs()) {
                        Email email = inbox.getEmail(i);
                        if (email.isRead() && !email.hasItems() && !MinecraftForge.EVENT_BUS.post((Event)new EmailDeleteEvent.Pre(inbox, i, true, false))) {
                            inbox.deleteEmail(i);
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new EmailDeleteEvent.Post(inbox, i, true, false));
                    }
                    EmailUtils.saveInboxToDisk(inbox);
                    EmailAPI.sendInboxToClient(inbox, player);
                });
            }
            return null;
        }
    }

    public static class Delete
    implements IMessage {
        protected long msgID;

        public Delete() {
        }

        public Delete(long msgID) {
            this.msgID = msgID;
        }

        public void fromBytes(ByteBuf buf) {
            this.msgID = buf.readLong();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.msgID);
        }

        public IMessage handler(MessageContext ctx) {
            if (ctx.side.isServer()) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                WorldServer world = player.func_71121_q();
                world.func_152344_a(() -> {
                    Inbox inbox = Inbox.get((EntityPlayer)player);
                    if (inbox.hasEmail(this.msgID) && !MinecraftForge.EVENT_BUS.post((Event)new EmailDeleteEvent.Pre(inbox, this.msgID, false, false))) {
                        inbox.deleteEmail(this.msgID);
                    }
                    EmailUtils.saveInboxToDisk(inbox);
                    EmailAPI.sendInboxToClient(inbox, player);
                    MinecraftForge.EVENT_BUS.post((Event)new EmailDeleteEvent.Post(inbox, this.msgID, false, false));
                });
            }
            return null;
        }
    }
}

