/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.net.msg;

import cat.jiu.email.EmailMain;
import cat.jiu.email.element.Inbox;
import cat.jiu.email.ui.container.ContainerEmailMain;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.SizeReport;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MsgInboxToClient
implements IMessage {
    protected Inbox inbox;
    protected SizeReport report = SizeReport.SUCCES;

    public MsgInboxToClient() {
    }

    public MsgInboxToClient(@Nonnull Inbox inbox) {
        this.inbox = inbox;
    }

    public void fromBytes(ByteBuf buf) {
        if (EmailConfigs.isInfiniteSize()) {
            PacketBuffer pb = new PacketBuffer(buf);
            int i = pb.readerIndex();
            byte b0 = pb.readByte();
            if (b0 != 0) {
                pb.readerIndex(i);
                try {
                    NBTTagCompound nbt = CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)pb), (NBTSizeTracker)new NBTSizeTracker(Long.MAX_VALUE));
                    if (nbt != null) {
                        this.inbox = Inbox.get(nbt.func_186857_a("owner"), nbt.func_74775_l("inbox"));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ByteBuf bufc = buf.copy();
            PacketBuffer pb = new PacketBuffer(bufc);
            int i = pb.readerIndex();
            byte b0 = pb.readByte();
            if (b0 != 0) {
                pb.readerIndex(i);
                try {
                    NBTTagCompound inboxTag = CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)pb), (NBTSizeTracker)new NBTSizeTracker(Long.MAX_VALUE));
                    if (inboxTag != null) {
                        if (inboxTag.func_74764_b("ToBig")) {
                            this.report = new SizeReport(inboxTag.func_74763_f("id"), inboxTag.func_74762_e("slot"), inboxTag.func_74762_e("size"));
                        } else {
                            this.inbox = Inbox.get(inboxTag.func_186857_a("owner"), inboxTag.func_74775_l("inbox"));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        if (EmailConfigs.isInfiniteSize()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_186854_a("owner", this.inbox.getOwnerAsUUID());
            NBTTagCompound inbox = this.inbox.writeTo(NBTTagCompound.class);
            inbox.func_82580_o("blacklist");
            inbox.func_82580_o("historySize");
            inbox.func_82580_o("dev");
            nbt.func_74782_a("inbox", (NBTBase)inbox);
            pb.func_150786_a(nbt);
        } else {
            SizeReport report = EmailUtils.checkInboxSize(this.inbox);
            if (!SizeReport.SUCCES.equals(report)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("ToBig", true);
                nbt.func_74772_a("id", report.id);
                nbt.func_74768_a("slot", report.slot);
                nbt.func_74772_a("size", report.size);
                pb.func_150786_a(nbt);
                return;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_186854_a("owner", this.inbox.getOwnerAsUUID());
            NBTTagCompound inbox = this.inbox.writeTo(NBTTagCompound.class);
            inbox.func_82580_o("blacklist");
            inbox.func_82580_o("historySize");
            inbox.func_82580_o("dev");
            nbt.func_74782_a("inbox", (NBTBase)inbox);
            pb.func_150786_a(nbt);
        }
    }

    public IMessage handler(MessageContext ctx) {
        if (ctx.side.isClient()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Container con = player.field_71070_bA;
            if (con instanceof ContainerEmailMain) {
                if (!SizeReport.SUCCES.equals(this.report)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "---------------------------------------------"));
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"info.email.error.to_big.0", (Object[])new Object[0])));
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"info.email.error.to_big.1", (Object[])new Object[]{this.report.id, this.report.slot, this.report.size})));
                    player.func_71053_j();
                } else {
                    EmailMain.setUnread(this.inbox.getUnRead());
                    EmailMain.setAccept(this.inbox.getUnReceived());
                    ((ContainerEmailMain)con).setInbox(this.inbox);
                    ((ContainerEmailMain)con).setRefresh(false);
                }
            }
        }
        return null;
    }

    public static class MsgOtherToClient
    implements IMessage {
        private final Map<String, Object> customValue = Maps.newHashMap();
        private final List<String> senderBlacklist = Lists.newArrayList();

        public MsgOtherToClient() {
        }

        public MsgOtherToClient(Inbox inbox) {
            this(inbox.getCustomValue(), inbox.getSenderBlacklist());
        }

        public MsgOtherToClient(Map<String, Object> customValue, List<String> senderBlacklist) {
            this.customValue.putAll(customValue);
            this.senderBlacklist.addAll(senderBlacklist);
        }

        public void fromBytes(ByteBuf buf) {
            try {
                NBTTagCompound nbt = new PacketBuffer(buf).func_150793_b();
                NBTTagCompound values = nbt.func_74775_l("values");
                values.func_150296_c().forEach(k -> this.customValue.put((String)k, values.func_74779_i(k)));
                NBTTagList blacks = nbt.func_150295_c("blacks", 8);
                blacks.forEach(e -> this.senderBlacklist.add(((NBTTagString)e).func_150285_a_()));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagCompound values = new NBTTagCompound();
            this.customValue.forEach((k, v) -> values.func_74778_a(k, String.valueOf(v)));
            nbt.func_74782_a("values", (NBTBase)values);
            NBTTagList blacks = new NBTTagList();
            this.senderBlacklist.forEach(e -> blacks.func_74742_a((NBTBase)new NBTTagString(e)));
            nbt.func_74782_a("blacks", (NBTBase)blacks);
            new PacketBuffer(buf).func_150786_a(nbt);
        }

        public IMessage handler(MessageContext ctx) {
            Container con;
            if (ctx.side.isClient() && (con = Minecraft.func_71410_x().field_71439_g.field_71070_bA) instanceof ContainerEmailMain) {
                this.customValue.forEach((k, v) -> ((ContainerEmailMain)con).getInbox().addCustom((String)k, v));
                this.senderBlacklist.forEach(e -> ((ContainerEmailMain)con).getInbox().addSenderBlacklist((String)e));
            }
            return null;
        }
    }
}

