/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.net.msg;

import cat.jiu.email.EmailMain;
import cat.jiu.email.element.Cooling;
import cat.jiu.email.element.Email;
import cat.jiu.email.element.Inbox;
import cat.jiu.email.element.InboxText;
import cat.jiu.email.event.EmailSendEvent;
import cat.jiu.email.net.msg.SendRenderText;
import cat.jiu.email.ui.container.ContainerEmailSend;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.SizeReport;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class MsgSend
implements IMessage {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    protected String addresser;
    protected EmailSendEvent.EmailSenderGroup group;
    protected Email email;

    public MsgSend() {
    }

    public MsgSend(EmailSendEvent.EmailSenderGroup group, String addressee, Email email) {
        this.group = group;
        this.addresser = addressee;
        this.email = email;
        this.email.setCreateTimeToNow();
    }

    public void fromBytes(ByteBuf buf) {
        try {
            NBTTagCompound nbt = new PacketBuffer(buf).func_150793_b();
            this.addresser = nbt.func_74779_i("addresser");
            this.group = EmailSendEvent.EmailSenderGroup.getGroupByID(nbt.func_74762_e("group"));
            this.email = new Email(nbt.func_74775_l("email"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("addresser", this.addresser);
        nbt.func_74768_a("group", EmailSendEvent.EmailSenderGroup.getIDByGroup(this.group));
        nbt.func_74782_a("email", (NBTBase)this.email.writeTo(NBTTagCompound.class));
        new PacketBuffer(buf).func_150786_a(nbt);
    }

    public IMessage handler(MessageContext ctx) {
        if (ctx.side.isServer()) {
            EmailUtils.initNameAndUUID(EmailMain.server);
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            if (this.group.isPlayerSend() && this.addresser.equals(sender.func_70005_c_()) && !EmailConfigs.Send.Enable_Send_To_Self) {
                this.sendMessage(sender, Level.ERROR, "info.email.error.send_self", new Object[0]);
                return null;
            }
            if (!(EmailUtils.hasName(this.addresser) || "@a".equals(this.addresser) || "@p".equals(this.addresser))) {
                this.sendMessage(sender, Level.ERROR, "info.email.error.not_found_player", this.addresser);
                return null;
            }
            if ("@a".equals(this.addresser) || "@p".equals(this.addresser)) {
                if (sender != null) {
                    boolean isOP = false;
                    if (sender.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)sender.func_146103_bH()) != null) {
                        isOP = true;
                    } else if (!sender.func_184102_h().func_71262_S() && ((IntegratedServer)sender.func_184102_h()).func_71344_c() && Minecraft.func_71410_x().field_71439_g.func_184840_I() >= 4) {
                        isOP = true;
                    }
                    boolean isOP_f = isOP;
                    new Thread(() -> {
                        if (isOP_f) {
                            long time = System.currentTimeMillis();
                            int sended = 0;
                            if (this.group.isPlayerSend()) {
                                ((ContainerEmailSend)sender.field_71070_bA).setLock(true);
                            }
                            if ("@a".equals(this.addresser)) {
                                for (UUID uid : EmailUtils.getAllUUID()) {
                                    this.sendEmail(sender, uid.toString(), false);
                                    ++sended;
                                }
                            } else if ("@p".equals(this.addresser)) {
                                for (GameProfile profile : sender.func_184102_h().func_152357_F()) {
                                    this.sendEmail(sender, profile.getId().toString(), false);
                                    ++sended;
                                }
                            }
                            if (this.group.isPlayerSend()) {
                                ((ContainerEmailSend)sender.field_71070_bA).setLock(false);
                            }
                            this.sendMessage(sender, Level.INFO, "info.email.send.abs", sended, System.currentTimeMillis() - time);
                        } else {
                            this.sendMessage(sender, Level.WARN, "info.email.send.not_op", this.addresser);
                        }
                    }).start();
                }
            } else {
                this.sendEmail(sender, this.addresser, true);
            }
        }
        return null;
    }

    private void sendEmail(EntityPlayerMP sender, String addresser, boolean lock) {
        Inbox inbox = Inbox.get(addresser);
        ContainerEmailSend container = null;
        List<ItemStack> stacks = null;
        if (this.group.isPlayerSend()) {
            container = (ContainerEmailSend)sender.field_71070_bA;
            if (lock) {
                container.setLock(true);
            }
            stacks = container.toItemList(false);
            this.email.addItems(stacks);
        }
        if (!EmailConfigs.isInfiniteSize() && !this.checkEmailSize(inbox, sender, stacks, lock)) {
            if (this.group.isPlayerSend() && lock) {
                container.setLock(false);
            }
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EmailSendEvent(TickEvent.Phase.START, this.group, addresser, this.email))) {
            return;
        }
        if (!inbox.isInSenderBlacklist(sender.func_70005_c_())) {
            this.sendMessage(addresser, inbox.addEmail(this.email, true), sender, lock);
        } else {
            if (this.group.isPlayerSend()) {
                container.putStack(this.email.getItems());
                if (lock) {
                    container.setLock(false);
                }
            }
            this.sendIsBlackMessage(sender, lock);
        }
        MinecraftForge.EVENT_BUS.post((Event)new EmailSendEvent(TickEvent.Phase.END, this.group, addresser, this.email));
    }

    private boolean checkEmailSize(Inbox inbox, EntityPlayerMP msgSender, List<ItemStack> stacks, boolean lock) {
        SizeReport report = EmailUtils.checkEmailSize(this.email);
        if (!SizeReport.SUCCES.equals(report)) {
            if (msgSender != null) {
                if (this.group.isPlayerSend()) {
                    ((ContainerEmailSend)msgSender.field_71070_bA).putStack(stacks);
                    if (lock) {
                        ((ContainerEmailSend)msgSender.field_71070_bA).setLock(false);
                    }
                    EmailMain.net.sendMessageToPlayer(new SendRenderText(new InboxText("info.email.error.send.to_big", report.slot, report.size)), msgSender);
                } else {
                    EmailUtils.sendMessage((EntityPlayer)msgSender, TextFormatting.RED, "info.email.error.send.to_big", report.slot, report.size);
                }
            } else {
                EmailMain.log.warn("Email item is to big, please remove some item or nbt. Slot: {}, Size: {} / 2097152 Bytes", (Object)report.slot, (Object)report.size);
            }
            return false;
        }
        long size = inbox.getInboxSize() + EmailUtils.getSize(this.email.writeTo(NBTTagCompound.class));
        if (size >= 0x200000L) {
            if (msgSender != null) {
                if (this.group.isPlayerSend()) {
                    ((ContainerEmailSend)msgSender.field_71070_bA).putStack(stacks);
                    if (lock) {
                        ((ContainerEmailSend)msgSender.field_71070_bA).setLock(false);
                    }
                    EmailMain.net.sendMessageToPlayer(new SendRenderText(new InboxText("info.email.error.send.to_big.email", size)), msgSender);
                } else {
                    EmailUtils.sendMessage((EntityPlayer)msgSender, TextFormatting.RED, "info.email.error.send.to_big.email", size);
                }
            } else {
                EmailMain.log.warn("Send email to big, Please reduce the e-mail size. Size: {} / 2097152 Bytes", (Object)size);
            }
            return false;
        }
        return true;
    }

    private void sendMessage(String addresser, boolean success, EntityPlayerMP msgSender, boolean lock) {
        if ("?????".equals(this.email.getSender().getText()) || this.group.isSystemSend()) {
            return;
        }
        try {
            addresser = EmailUtils.getName(UUID.fromString(addresser));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (success) {
            if (!this.group.isSystemSend() && msgSender != null) {
                if (this.group.isPlayerSend()) {
                    if (lock) {
                        ((ContainerEmailSend)msgSender.field_71070_bA).setLock(false);
                    }
                    Cooling.cooling(msgSender.func_70005_c_());
                    EmailMain.net.sendMessageToPlayer(new SendRenderText(Color.GREEN, new InboxText("info.email.send.success", addresser)), msgSender);
                } else {
                    EmailUtils.sendMessage((EntityPlayer)msgSender, TextFormatting.GREEN, "info.email.send.success", addresser);
                }
                EntityPlayer player = MsgSend.getOnlinePlayer(addresser, msgSender.func_184102_h());
                if (player != null) {
                    EmailUtils.sendMessage(player, "info.email.from", this.email.getSender());
                }
            }
            this.sendLog(this.email.getSender().getText(), addresser, EmailUtils.getUUID(addresser));
        } else if (!this.group.isSystemSend() && msgSender != null) {
            if (this.group.isPlayerSend()) {
                if (lock) {
                    ((ContainerEmailSend)msgSender.field_71070_bA).setLock(false);
                }
                EmailMain.net.sendMessageToPlayer(new SendRenderText(Color.RED, new InboxText("info.email.send.fail", new Object[0])), msgSender);
            } else {
                EmailUtils.sendMessage((EntityPlayer)msgSender, TextFormatting.RED, "info.email.send.fail", new Object[0]);
            }
        } else {
            EmailMain.log.info("Send e-mail fail, check log find the reason.");
        }
    }

    private void sendIsBlackMessage(EntityPlayerMP msgSender, boolean lock) {
        if (msgSender != null) {
            if (this.group.isPlayerSend()) {
                if (lock) {
                    ((ContainerEmailSend)msgSender.field_71070_bA).setLock(false);
                }
                EmailMain.net.sendMessageToPlayer(new SendRenderText(Color.RED, new InboxText("info.email.send.fail.blacklist", new Object[0])), msgSender);
            } else {
                EmailUtils.sendMessage((EntityPlayer)msgSender, TextFormatting.RED, "info.email.send.fail.blacklist", new Object[0]);
            }
        } else {
            EmailMain.log.info("Send email fail, you have been block by the Addressee!");
        }
    }

    public static EntityPlayer getOnlinePlayer(String s, MinecraftServer server) {
        PlayerList playerList;
        EntityPlayerMP player = null;
        if (server != null && s != null & !s.isEmpty() && (player = (playerList = server.func_184103_al()).func_152612_a(s)) == null) {
            try {
                player = playerList.func_177451_a(UUID.fromString(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return player;
    }

    private void sendMessage(EntityPlayerMP sender, Level level, String msg, Object ... arg) {
        if (this.group.isPlayerSend()) {
            Color color = level == Level.INFO ? Color.GREEN : (level == Level.WARN ? Color.YELLOW : Color.RED);
            EmailMain.net.sendMessageToPlayer(new SendRenderText(color, new InboxText(msg, arg)), sender);
        } else {
            EmailMain.log.log(level, msg.replace("%s", "{}"), arg);
        }
    }

    private void sendLog(String sender, String name, UUID uid) {
        try {
            uid = UUID.fromString(name);
            name = EmailUtils.getName(uid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        File filepath = new File("./logs/email.log");
        if (!filepath.exists()) {
            try {
                filepath.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StringBuilder msg = new StringBuilder().append(sender).append(" send a email to Player, name: ").append(name).append(", uuid: ").append(uid == null ? this.addresser : uid.toString());
        StringBuilder s = new StringBuilder().append("[").append(dateFormat.format(new Date())).append("] ").append((CharSequence)msg).append("\n");
        if (!this.group.isSystemSend()) {
            EmailMain.log.info((CharSequence)msg);
        }
        try (FileOutputStream fos = new FileOutputStream(filepath, true);
             OutputStreamWriter out = new OutputStreamWriter(fos);){
            out.write(s.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

