/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.net.msg;

import cat.jiu.email.element.InboxText;
import cat.jiu.email.iface.IInboxText;
import cat.jiu.email.util.EmailUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MsgSendPlayerMessage
implements IMessage {
    private TextFormatting color;
    private IInboxText text;

    public MsgSendPlayerMessage() {
    }

    public MsgSendPlayerMessage(IInboxText text) {
        this.text = text;
    }

    public MsgSendPlayerMessage(TextFormatting color, IInboxText text) {
        this.color = color;
        this.text = text;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            NBTTagCompound nbt = new PacketBuffer(buf).func_150793_b();
            if (nbt.func_74764_b("color")) {
                this.color = TextFormatting.func_96300_b((String)nbt.func_74779_i("color"));
            }
            this.text = new InboxText(nbt.func_74781_a("text"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.color != null) {
            nbt.func_74778_a("color", this.color.name());
        }
        nbt.func_74782_a("text", this.text.writeToNBT());
        new PacketBuffer(buf).func_150786_a(nbt);
    }

    public IMessage handler(MessageContext ctx) {
        if (ctx.side.isClient()) {
            ITextComponent tc = this.color != null ? EmailUtils.createTextComponent(this.color, this.text.format(), new Object[0]) : EmailUtils.createTextComponent(this.text.format(), new Object[0]);
            Minecraft.func_71410_x().field_71439_g.func_145747_a(tc);
        }
        return null;
    }
}

