/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.net.msg.refresh;

import cat.jiu.email.element.Inbox;
import cat.jiu.email.ui.container.ContainerInboxBlacklist;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MsgRefreshBlacklist
implements IMessage {
    private final List<String> senderBlacklist = Lists.newArrayList();

    public MsgRefreshBlacklist() {
    }

    public MsgRefreshBlacklist(Inbox inbox) {
        this.senderBlacklist.addAll(inbox.getSenderBlacklist());
    }

    public MsgRefreshBlacklist(List<String> senderBlacklist) {
        this.senderBlacklist.addAll(senderBlacklist);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            NBTTagCompound nbt = new PacketBuffer(buf).func_150793_b();
            NBTTagList blacks = nbt.func_150295_c("blacks", 8);
            blacks.forEach(e -> this.senderBlacklist.add(((NBTTagString)e).func_150285_a_()));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList blacks = new NBTTagList();
        this.senderBlacklist.forEach(e -> blacks.func_74742_a((NBTBase)new NBTTagString(e)));
        nbt.func_74782_a("blacks", (NBTBase)blacks);
        new PacketBuffer(buf).func_150786_a(nbt);
    }

    public IMessage handler(MessageContext ctx) {
        Container con;
        if (ctx.side.isClient() && (con = Minecraft.func_71410_x().field_71439_g.field_71070_bA) instanceof ContainerInboxBlacklist) {
            this.senderBlacklist.forEach(e -> ((ContainerInboxBlacklist)con).addBlacklist((String)e));
        }
        return null;
    }

    public static class Refresh
    implements IMessage {
        public void fromBytes(ByteBuf buf) {
        }

        public void toBytes(ByteBuf buf) {
        }

        public IMessage handler(MessageContext ctx) {
            if (ctx.side.isServer()) {
                return new MsgRefreshBlacklist(Inbox.get((EntityPlayer)ctx.getServerHandler().field_147369_b));
            }
            return null;
        }
    }
}

