/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.ui.container;

import cat.jiu.email.EmailMain;
import cat.jiu.email.element.Cooling;
import cat.jiu.email.net.msg.SendCooling;
import cat.jiu.email.ui.SendEmailCoolingEvent;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.JsonToStackUtil;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerEmailSend
extends Container {
    private final EntityPlayer player;
    private final ItemStackHandler handler = new ItemStackHandler(16);
    private static long cooling = 0L;
    boolean isLock = false;
    public long renderTicks = 0L;
    public String renderText;
    public Color renderColor;

    public ContainerEmailSend(World world, EntityPlayer player) {
        this.player = player;
        this.addHandlerSlot(this.handler, 17, 100, 8, 2);
        this.addPlayerInventorySlot(8, 151);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            if (Cooling.isCooling(player.func_70005_c_())) {
                long m;
                cooling = m = Cooling.getCoolingTimeMillis(mp.func_70005_c_());
                EmailMain.execute(a -> EmailMain.net.sendMessageToPlayer(new SendCooling(m), mp));
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected void addHandlerSlot(ItemStackHandler handler, int x, int y, int slotWidth, int slotHeight) {
        int slotIndex = 0;
        for (int slotY = 0; slotY < slotHeight; ++slotY) {
            for (int slotX = 0; slotX < slotWidth; ++slotX) {
                if (slotIndex >= handler.getSlots()) {
                    return;
                }
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)handler, slotIndex, x + 18 * slotX, y + 18 * slotY));
                ++slotIndex;
            }
        }
    }

    protected void addPlayerInventorySlot(int x, int y) {
        int slotIndex = 0;
        for (int slotX = 0; slotX < 9; ++slotX) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, slotIndex, x + 18 * slotX, y + 36 + 22));
            ++slotIndex;
        }
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, slotIndex, x + 18 * slotX, y + 18 * slotY));
                ++slotIndex;
            }
        }
    }

    @SubscribeEvent
    public void cooling(SendEmailCoolingEvent event) {
        if (this.player.func_70005_c_().equals(event.name)) {
            if (!this.player.field_70170_p.field_72995_K) {
                EmailMain.execute(a -> EmailMain.net.sendMessageToPlayer(new SendCooling(event.millis), (EntityPlayerMP)this.player));
            }
            cooling = event.millis;
        }
    }

    public boolean isCooling() {
        return cooling > System.currentTimeMillis();
    }

    public void setCooling(long millis) {
        cooling = millis;
    }

    public long getCoolingMillis() {
        return cooling;
    }

    public boolean isLock() {
        return this.isLock;
    }

    public void setLock(boolean isSending) {
        this.isLock = isSending;
        for (IContainerListener listener : this.field_75149_d) {
            listener.func_71112_a((Container)this, 1001, this.isLock ? 1 : 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 1001: {
                this.isLock = data == 1;
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.isEmpty() && !player.field_70170_p.field_72995_K) {
            EmailUtils.spawnAsEntity(player, this.handler);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack newStack = slot.func_75211_c();
        ItemStack oldStack = newStack.func_77946_l();
        boolean isMerged = false;
        isMerged = index < 16 ? super.func_75135_a(newStack, 16, 52, true) : super.func_75135_a(newStack, 0, 16, false);
        if (!isMerged) {
            return ItemStack.field_190927_a;
        }
        return oldStack;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public JsonObject toItemArray(boolean copy) {
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            stacks.add(this.handler.getStackInSlot(i));
            if (copy) continue;
            this.handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return JsonToStackUtil.toJsonObject(stacks, false);
    }

    public List<ItemStack> toItemList(boolean copy) {
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            stacks.add(this.handler.getStackInSlot(i));
            if (copy) continue;
            this.handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        return stacks;
    }

    public void putStack(List<ItemStack> items) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = i >= items.size() ? ItemStack.field_190927_a : items.get(i);
            this.func_75139_a(i).func_75215_d(stack);
        }
    }

    public void setRenderText(String text) {
        this.setRenderText(text, Color.RED);
    }

    public void setRenderText(String text, Color color) {
        this.setRenderText(text, color, EmailUtils.parseTick(0L, 0L, 0L, 15L, 0L));
    }

    public void setRenderText(String text, Color color, long ticks) {
        this.renderText = text;
        this.renderColor = color;
        this.renderTicks = ticks;
    }

    public void clearRenderText() {
        this.renderText = null;
        this.renderColor = null;
        this.renderTicks = 0L;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }
}

