/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.ui.gui;

import cat.jiu.email.EmailMain;
import cat.jiu.email.element.Email;
import cat.jiu.email.event.InboxDrawEvent;
import cat.jiu.email.event.InboxPlaySoundEvent;
import cat.jiu.email.iface.IInboxText;
import cat.jiu.email.net.msg.MsgDeleteEmail;
import cat.jiu.email.net.msg.MsgOpenGui;
import cat.jiu.email.net.msg.MsgReadEmail;
import cat.jiu.email.net.msg.MsgReceiveEmail;
import cat.jiu.email.net.msg.refresh.MsgRefreshInbox;
import cat.jiu.email.proxy.ClientProxy;
import cat.jiu.email.ui.container.ContainerEmailMain;
import cat.jiu.email.ui.gui.GuiBlacklist;
import cat.jiu.email.ui.gui.GuiPopupMenu;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.TextUtils;
import cat.jiu.email.util.client.EmailSenderSndSound;
import cat.jiu.email.util.client.GuiDynamicImage;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiEmailMain
extends GuiContainer {
    public static ResourceLocation BackGround = new ResourceLocation("email", "textures/gui/container/email_main.png");
    public static ResourceLocation load = new ResourceLocation("email", "textures/gui/load.png");
    private final ContainerEmailMain container;
    private GuiPopupMenu popupMenu = new GuiPopupMenu();
    private final GuiDynamicImage loadImage = new GuiDynamicImage(load, 18, false, 16, 16, 0, 0, 32, 32, 32, 576);
    private int id = -1;
    private long renderTick = 0L;
    private String renderText;
    private Color renderColor;
    private int renderX;
    private int renderY;
    private final int Candidate_Email_X;
    private final int Candidate_Email_Y;
    private int size;
    private long[] showEmails;
    private long[] emailIDs;
    private long currentEmail;
    private int emailPage;
    private int maxSelectedTextRows;
    private int showSelectedSpacing;
    private List<Message> showMessages;
    private int[] msgKeyMap;
    private int[] currentMsg;
    private int msgPage;
    int lastClickX;
    int lastClickY;
    private EmailSenderSndSound currentSound;
    private boolean isClose;
    private long popupMenuCurrentEmail;
    private int refreshCoolingTicks;

    private int nextID() {
        return this.id++;
    }

    public GuiEmailMain() {
        super((Container)new ContainerEmailMain());
        this.Candidate_Email_X = EmailConfigs.Main.Position.Candidate_Email.X;
        this.Candidate_Email_Y = EmailConfigs.Main.Position.Candidate_Email.Y;
        this.size = -1;
        this.showEmails = null;
        this.emailIDs = null;
        this.currentEmail = -1L;
        this.emailPage = 0;
        this.maxSelectedTextRows = EmailConfigs.Main.Selected_Text_Rows;
        this.showSelectedSpacing = EmailConfigs.Main.Selected_Text_Spacing;
        this.showMessages = Lists.newArrayList();
        this.msgKeyMap = null;
        this.currentMsg = null;
        this.msgPage = 0;
        this.lastClickX = 0;
        this.lastClickY = 0;
        this.isClose = false;
        this.popupMenuCurrentEmail = -1L;
        this.refreshCoolingTicks = 0;
        this.container = (ContainerEmailMain)this.field_147002_h;
        this.field_146999_f = EmailConfigs.Main.Size.Width;
        this.field_147000_g = EmailConfigs.Main.Size.Height;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.initTurnPageBtn(x, y);
        this.initFuntionBtn(x, y);
        this.initPopupMenu();
        String text = I18n.func_135052_a((String)"info.email.black", (Object[])new Object[0]);
        int weight = this.field_146289_q.func_78256_a(text);
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 190 - (weight + 4), y + 145, weight + 4, 12, text){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiEmailMain gui = GuiEmailMain.this;
                GuiEmailMain.this.field_146297_k.func_147108_a((GuiScreen)new GuiBlacklist((GuiScreen)gui));
            }
        });
    }

    private void initTurnPageBtn(int x, int y) {
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 82, y + 19, 9, 20, "\u21e7"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiEmailMain.this.goEmail(-1);
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 82, y + 83, 9, 20, "\u21e9"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiEmailMain.this.goEmail(1);
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 222, y + 31, 9, 20, "\u21e7"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiEmailMain.this.goMessage(-1);
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 222, y + 83, 9, 20, "\u21e9"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiEmailMain.this.goMessage(1);
            }
        });
    }

    private void initFuntionBtn(int x, int y) {
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 4, y + 106, 43, 12, I18n.func_135052_a((String)"info.email.delete_accept", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                EmailMain.net.sendMessageToServer(new MsgDeleteEmail.AllReceive());
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 4, y + 119, 43, 12, I18n.func_135052_a((String)"info.email.delete_read", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                EmailMain.net.sendMessageToServer(new MsgDeleteEmail.AllRead());
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 4, y + 132, 43, 12, I18n.func_135052_a((String)"info.email.dispatch", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                EmailMain.net.sendMessageToServer(new MsgOpenGui(1));
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 192, y + 106, 41, 12, I18n.func_135052_a((String)"info.email.delete", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (GuiEmailMain.this.currentEmail != -1L) {
                    EmailMain.net.sendMessageToServer(new MsgDeleteEmail.Delete(GuiEmailMain.this.currentEmail));
                }
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 192, y + 119, 41, 12, I18n.func_135052_a((String)"info.email.accept", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (GuiEmailMain.this.currentEmail != -1L) {
                    if (GuiEmailMain.this.container.getInboxSize() + 55L >= 0x200000L && !EmailConfigs.isInfiniteSize()) {
                        GuiEmailMain.this.emailIsOutStorageSize();
                        return;
                    }
                    EmailMain.net.sendMessageToServer(new MsgReceiveEmail.Receive(GuiEmailMain.this.currentEmail));
                }
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 192, y + 145, 41, 12, I18n.func_135052_a((String)"info.email.accept_all", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (!EmailConfigs.isInfiniteSize() && GuiEmailMain.this.container.getInboxSize() + (long)(GuiEmailMain.this.container.getInbox().getUnReceived() * 55) >= 0x200000L) {
                    GuiEmailMain.this.emailIsOutStorageSize();
                    return;
                }
                EmailMain.net.sendMessageToServer(new MsgReceiveEmail.All());
            }
        });
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 192, y + 132, 41, 12, I18n.func_135052_a((String)"info.email.read_all", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (!EmailConfigs.isInfiniteSize() && GuiEmailMain.this.container.getInboxSize() + (long)(GuiEmailMain.this.container.getInbox().getUnRead() * 51) > 0x200000L) {
                    GuiEmailMain.this.emailIsOutStorageSize();
                    return;
                }
                EmailMain.net.sendMessageToServer(new MsgReadEmail.All());
            }
        });
    }

    private void initPopupMenu() {
        this.popupMenu = new GuiPopupMenu();
        this.popupMenu.addPopupButton(new GuiButton(this.nextID(), 0, 0, 45, 12, I18n.func_135052_a((String)"info.email.delete", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (GuiEmailMain.this.popupMenuCurrentEmail != -1L) {
                    EmailMain.net.sendMessageToServer(new MsgDeleteEmail.Delete(GuiEmailMain.this.popupMenuCurrentEmail));
                    GuiEmailMain.this.popupMenu.setVisible(false);
                }
            }
        });
        this.popupMenu.addPopupButton(new GuiButton(this.nextID(), 0, 0, 45, 12, I18n.func_135052_a((String)"info.email.accept", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (GuiEmailMain.this.popupMenuCurrentEmail != -1L) {
                    if (GuiEmailMain.this.container.getInboxSize() + 55L >= 0x200000L && !EmailConfigs.isInfiniteSize()) {
                        GuiEmailMain.this.emailIsOutStorageSize();
                        return;
                    }
                    EmailMain.net.sendMessageToServer(new MsgReceiveEmail.Receive(GuiEmailMain.this.popupMenuCurrentEmail));
                }
            }
        });
        this.popupMenu.addPopupButton(new GuiButton(this.nextID(), 0, 0, 45, 12, I18n.func_135052_a((String)"info.email.read", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (GuiEmailMain.this.popupMenuCurrentEmail != -1L) {
                    if (GuiEmailMain.this.container.getInboxSize() + 51L >= 0x200000L && !EmailConfigs.isInfiniteSize()) {
                        GuiEmailMain.this.emailIsOutStorageSize();
                        return;
                    }
                    EmailMain.net.sendMessageToServer(new MsgReadEmail(GuiEmailMain.this.popupMenuCurrentEmail));
                }
            }
        });
        this.popupMenu.addPopupButton(new GuiButton(this.nextID(), 0, 0, 50, 12, I18n.func_135052_a((String)"info.email.read_accept", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (GuiEmailMain.this.popupMenuCurrentEmail != -1L) {
                    if (GuiEmailMain.this.container.getInboxSize() + 51L + 55L >= 0x200000L && !EmailConfigs.isInfiniteSize()) {
                        GuiEmailMain.this.emailIsOutStorageSize();
                        return;
                    }
                    EmailMain.net.sendMessageToServer(new MsgReadEmail(GuiEmailMain.this.popupMenuCurrentEmail));
                    EmailMain.net.sendMessageToServer(new MsgReceiveEmail.Receive(GuiEmailMain.this.popupMenuCurrentEmail));
                }
            }
        });
    }

    public void emailIsOutStorageSize() {
        this.setRenderText(EmailUtils.parseTick(0L, 0L, 0L, 10L, 0L), I18n.func_135052_a((String)"info.email.out_size", (Object[])new Object[0]), Color.RED, 65, 145);
    }

    public void setRenderText(long showTick, @Nonnull String text, @Nonnull Color color, int x, int y) {
        this.renderTick = showTick;
        this.renderText = text;
        this.renderColor = color;
        this.renderX = x;
        this.renderY = y;
    }

    public void clearRenderText() {
        this.renderTick = 0L;
    }

    private void goEmail(int page) {
        if (this.emailIDs == null) {
            return;
        }
        if (this.size > 5) {
            this.emailPage += page;
            int maxPage = this.size - 5;
            if (this.emailPage > this.size) {
                this.emailPage = this.size;
            }
            if (this.emailPage < 0) {
                this.emailPage = 0;
            }
            if (this.emailPage > maxPage) {
                this.emailPage = maxPage;
            }
            this.showEmails = Arrays.copyOfRange(this.emailIDs, this.emailPage, 5 + this.emailPage);
        } else {
            this.showEmails = Arrays.copyOf(this.emailIDs, this.emailIDs.length);
        }
    }

    public void setMaxSelectedTextRows(int maxrows) {
        this.maxSelectedTextRows = maxrows;
    }

    public int getMaxSelectedTextRows() {
        return this.maxSelectedTextRows;
    }

    public void setSelectedTextSpacing(int spacing) {
        this.showSelectedSpacing = spacing;
    }

    public int getSelectedTextSpacing() {
        return this.showSelectedSpacing;
    }

    private void goMessage(int page) {
        if (this.msgKeyMap == null) {
            return;
        }
        if (this.showMessages.size() > this.maxSelectedTextRows) {
            this.msgPage += page;
            int maxPage = this.showMessages.size() - this.maxSelectedTextRows;
            if (this.msgPage > this.showMessages.size()) {
                this.msgPage = this.showMessages.size();
            }
            if (this.msgPage < 0) {
                this.msgPage = 0;
            }
            if (this.msgPage > maxPage) {
                this.msgPage = maxPage;
            }
            this.currentMsg = Arrays.copyOfRange(this.msgKeyMap, this.msgPage, this.maxSelectedTextRows + this.msgPage);
        } else {
            this.currentMsg = Arrays.copyOf(this.msgKeyMap, this.msgKeyMap.length);
        }
    }

    private void init() {
        if (this.size == -1) {
            this.size = this.container.getInbox().emailCount();
        }
        if (this.emailIDs == null && this.size > 0) {
            this.emailIDs = this.container.getInbox().getEmailIDs().stream().sorted((l0, l1) -> l1.compareTo((Long)l0)).mapToLong(Long::longValue).toArray();
            this.emailPage = 0;
            this.goEmail(0);
        }
        if (this.size != this.container.getInbox().emailCount()) {
            this.size = this.container.getInbox().emailCount();
            this.emailIDs = this.container.getInbox().getEmailIDs().stream().sorted((l0, l1) -> l1.compareTo((Long)l0)).mapToLong(Long::longValue).toArray();
        }
    }

    public void func_146274_d() throws IOException {
        if (this.container.isRefresh()) {
            return;
        }
        super.func_146274_d();
        int key = Mouse.getEventDWheel();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        if (GuiEmailMain.isInRange(x, y, 82, 41, 8, 40) || GuiEmailMain.isInRange(x, y, 17, 10, 63, 90)) {
            int page = 0;
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                page += 2;
            }
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                ++page;
            }
            if (key == 120) {
                this.goEmail(-1 - page);
            } else if (key == -120) {
                this.goEmail(1 + page);
            }
        } else if (GuiEmailMain.isInRange(x, y, 221, 53, 8, 28) || GuiEmailMain.isInRange(x, y, 92, 30, 128, 74)) {
            int page = 0;
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                page += 2;
            }
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                ++page;
            }
            if (key == 120) {
                this.goMessage(-1 - page);
            } else if (key == -120) {
                this.goMessage(1 + page);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.container.isRefresh()) {
            return;
        }
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        if (GuiEmailMain.isInRange(this.lastClickX, this.lastClickY, left + 76, top + 41, 8, 40) || GuiEmailMain.isInRange(this.lastClickX, this.lastClickY, left + 18, top + 19, 57, 86)) {
            if (keyCode == 200) {
                this.goEmail(-1);
            } else if (keyCode == 208) {
                this.goEmail(1);
            }
        } else if (GuiEmailMain.isInRange(this.lastClickX, this.lastClickY, left + 216, top + 53, 8, 28) || GuiEmailMain.isInRange(this.lastClickX, this.lastClickY, left + 87, top + 30, 128, 74)) {
            if (keyCode == 200) {
                this.goMessage(-1);
            } else if (keyCode == 208) {
                this.goMessage(1);
            }
        } else if (ClientProxy.REFESH_INBOX.func_151463_i() == keyCode) {
            this.refresh();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BackGround);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2, (this.field_146295_m - this.field_147000_g) / 2, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179094_E();
        if (this.currentSound != null && this.currentSound.func_147667_k()) {
            this.stopSound();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        if (this.container.isRefresh()) {
            return;
        }
        if (GuiEmailMain.isInRange(mouseX, mouseY, this.getGuiLeft() + 5, this.getGuiTop() + 5, 7, 7)) {
            super.func_146279_a(I18n.func_135052_a((String)(this.refreshCoolingTicks <= 0 ? "info.email.refresh" : "info.email.refresh.cooling"), (Object[])new Object[0]), mouseX, mouseY);
        }
        for (GuiButton btn : this.field_146292_n) {
            this.func_73730_a(btn.field_146128_h, btn.field_146128_h + btn.field_146120_f - 2, btn.field_146129_i + btn.field_146121_g - 1, Color.BLACK.getRGB());
        }
        for (int i = 0; !this.popupMenu.isVisible() && i < 5 && this.showEmails != null && i < this.showEmails.length; ++i) {
            if (!GuiEmailMain.isInRange(mouseX, mouseY, this.getGuiLeft() + this.Candidate_Email_X, this.getGuiTop() + this.Candidate_Email_Y + 19 * i, 60, 17) || !this.container.getInbox().hasEmail(this.showEmails[i])) continue;
            Email email = this.container.getInbox().getEmail(this.showEmails[i]);
            ArrayList tip = Lists.newArrayList();
            tip.add(email.getTitle().format());
            tip.add("");
            tip.add(TextFormatting.GRAY + email.getCreateTimeAsString());
            tip.add(I18n.func_135052_a((String)"info.email.main.from", (Object[])new Object[]{email.getSender().format()}));
            tip.add("");
            tip.add(I18n.func_135052_a((String)"info.email.email_size", (Object[])new Object[]{email.getEmailNetworkSize()}));
            if (email.getExpirationTime() != null) {
                tip.add("");
                long time = email.getExpirationTimeAsTimestamp();
                if (System.currentTimeMillis() >= time) {
                    tip.add(String.format("%s: %s", I18n.func_135052_a((String)"email.config.expiration", (Object[])new Object[0]), TextFormatting.RED + I18n.func_135052_a((String)"email.config.expiration.ed", (Object[])new Object[0])));
                } else {
                    long last = time - System.currentTimeMillis();
                    long s = last / 1000L;
                    long m = s / 60L;
                    long h = m / 60L;
                    long d = h / 24L;
                    tip.add(I18n.func_135052_a((String)"info.email.remain_expiration_time", (Object[])new Object[]{d, h %= 24L, m %= 60L, s %= 60L}));
                }
            }
            super.func_146283_a((List)tip, mouseX, mouseY + 10);
            break;
        }
        this.popupMenu.drawPopupMenu(this.popupMenuCurrentEmail, this.field_146297_k, mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.container.isRefresh()) {
            int x = (this.field_146294_l - this.field_146999_f) / 2;
            int y = (this.field_146295_m - this.field_147000_g) / 2;
            this.loadImage.draw(x + 3, y + 146);
            this.drawCenteredString(I18n.func_135052_a((String)"info.email.refreshing", (Object[])new Object[0]), x + 9 + 40, y + 150, Color.RED.getRGB());
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new InboxDrawEvent(this, InboxDrawEvent.Type.INBOX, TickEvent.Phase.START, this.container.getInbox(), -1L, mouseX, mouseY));
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawInbox(mouseX, mouseY);
            GlStateManager.func_179094_E();
            MinecraftForge.EVENT_BUS.post((Event)new InboxDrawEvent(this, InboxDrawEvent.Type.INBOX, TickEvent.Phase.END, this.container.getInbox(), -1L, mouseX, mouseY));
        }
    }

    protected void drawInbox(int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.renderTick > 0L) {
            this.field_146289_q.func_78276_b(this.renderText, x + this.renderX, y + this.renderY, this.renderColor.getRGB());
            --this.renderTick;
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.email.storage", (Object[])new Object[0]), x + 5, y + 148, Color.BLACK.getRGB());
        Color sizeColor = Color.GREEN;
        if (!EmailConfigs.isInfiniteSize()) {
            long size = this.container.getInboxSize();
            if (size >= 1398122L) {
                sizeColor = Color.RED;
            } else if (size >= 699061L) {
                sizeColor = Color.YELLOW;
            }
        }
        int storageWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"info.email.storage", (Object[])new Object[0])) + 5;
        String bytes = EmailConfigs.isInfiniteSize() ? TextUtils.makeFabulous("Infinite") : "2097183";
        int bytesWidth = this.field_146297_k.field_71466_p.func_78256_a(bytes);
        this.field_146289_q.func_175065_a(bytes, (float)(x + 6 + storageWidth), (float)(y + 156), Color.BLACK.getRGB(), EmailConfigs.isInfiniteSize());
        this.field_146289_q.func_175065_a("Bytes", (float)(x + 7 + bytesWidth + 1 + storageWidth), (float)(y + 156), Color.BLACK.getRGB(), false);
        this.drawAlignRightString(String.valueOf(this.container.getInboxSize()), x + 6 + storageWidth + bytesWidth, y + 145, sizeColor.getRGB(), true);
        this.func_73730_a(x + 5 + storageWidth, x + 5 + bytesWidth + storageWidth, y + 154, Color.BLACK.getRGB());
        this.field_146297_k.func_110434_K().func_110577_a(BackGround);
        Gui.func_152125_a((int)(x + 6), (int)(y + 6), (float)111.0f, (float)169.0f, (int)55, (int)55, (int)6, (int)6, (float)256.0f, (float)256.0f);
        if (this.container.getInbox() == null || this.container.getInbox().emailCount() <= 0) {
            return;
        }
        this.init();
        if (this.showEmails == null) {
            return;
        }
        this.field_146289_q.func_78276_b("$:" + this.container.getInbox().getUnReceived(), x + 25, y + 3, Color.RED.getRGB());
        this.field_146289_q.func_78276_b("*:" + this.container.getInbox().getUnRead(), x + 50, y + 3, Color.RED.getRGB());
        for (int i = 0; i < this.showEmails.length; ++i) {
            if (!this.container.getInbox().hasEmail(this.showEmails[i])) continue;
            Email email = this.container.getInbox().getEmail(this.showEmails[i]);
            MinecraftForge.EVENT_BUS.post((Event)new InboxDrawEvent(this, InboxDrawEvent.Type.CANDIDATE, TickEvent.Phase.START, this.container.getInbox(), this.showEmails[i], mouseX, mouseY));
            if (email.hasItems()) {
                this.field_146289_q.func_78276_b("$", x + this.Candidate_Email_X + 51, y + this.Candidate_Email_Y + 19 * i + 1, email.isReceived() ? Color.GREEN.getRGB() : Color.RED.getRGB());
            }
            this.field_146289_q.func_78276_b("*", x + this.Candidate_Email_X + 56, y + this.Candidate_Email_Y + 19 * i + 1, email.isRead() ? Color.GREEN.getRGB() : Color.RED.getRGB());
            super.func_73732_a(this.field_146289_q, String.valueOf(this.showEmails[i]), x + this.Candidate_Email_X - 8, y + this.Candidate_Email_Y + 5 + 19 * i, Color.WHITE.getRGB());
            String sender = email.getSender().format();
            if (this.field_146289_q.func_78256_a(sender) > EmailConfigs.Main.Number_Of_Words.Candidate_Email.Sender) {
                sender = this.field_146289_q.func_78269_a(sender, EmailConfigs.Main.Number_Of_Words.Candidate_Email.Sender) + "...";
            }
            this.field_146289_q.func_78276_b(sender, x + this.Candidate_Email_X + 1, y + this.Candidate_Email_Y + 19 * i + 1, Color.WHITE.getRGB());
            this.field_146289_q.func_78276_b(email.getCreateTimeAsString().substring(5, email.getCreateTimeAsString().length() - 3), x + this.Candidate_Email_X + 1, y + this.Candidate_Email_Y + 10 + 19 * i, Color.BLACK.getRGB());
            MinecraftForge.EVENT_BUS.post((Event)new InboxDrawEvent(this, InboxDrawEvent.Type.CANDIDATE, TickEvent.Phase.END, this.container.getInbox(), this.showEmails[i], mouseX, mouseY));
        }
        if (this.currentEmail >= 0L && this.container.getInbox().hasEmail(this.currentEmail)) {
            String title;
            MinecraftForge.EVENT_BUS.post((Event)new InboxDrawEvent(this, InboxDrawEvent.Type.CURRENT, TickEvent.Phase.START, this.container.getInbox(), this.currentEmail, mouseX, mouseY));
            Email email = this.getCurrentEmail();
            String sender = email.getSender().format();
            if (this.field_146289_q.func_78256_a(sender) > EmailConfigs.Main.Number_Of_Words.Current_Email.Sender) {
                sender = this.field_146289_q.func_78269_a(sender, EmailConfigs.Main.Number_Of_Words.Current_Email.Sender) + "...";
            }
            if (this.field_146289_q.func_78256_a(title = email.getTitle().format()) > EmailConfigs.Main.Number_Of_Words.Current_Email.Title - (email.hasSound() ? 13 : 0)) {
                title = this.field_146289_q.func_78269_a(title, EmailConfigs.Main.Number_Of_Words.Current_Email.Title - (email.hasSound() ? 13 : 0)) + "...";
            }
            this.field_146289_q.func_78276_b(title, x + 7 + EmailConfigs.Main.Position.Current_Email.Title.X, y + EmailConfigs.Main.Position.Current_Email.Title.Y, Color.WHITE.getRGB());
            this.field_146289_q.func_78276_b(sender, x + 6 + EmailConfigs.Main.Position.Current_Email.Sender.X, y + EmailConfigs.Main.Position.Current_Email.Sender.Y, Color.WHITE.getRGB());
            this.drawAlignRightString(email.getCreateTimeAsString().substring(2, email.getCreateTimeAsString().length() - 3), x + 5 + 64 + EmailConfigs.Main.Position.Current_Email.Title.Time.X, y + EmailConfigs.Main.Position.Current_Email.Title.Time.Y, Color.WHITE.getRGB(), false);
            super.func_73732_a(this.field_146289_q, String.valueOf(this.currentEmail), x + 7 + EmailConfigs.Main.Position.Current_Email.MsgID.X, y + EmailConfigs.Main.Position.Current_Email.MsgID.Y, Color.WHITE.getRGB());
            int msgIndex = -1;
            for (int i = 0; i < this.currentMsg.length; ++i) {
                int index = this.currentMsg[i];
                Message msg = this.showMessages.get(index);
                if (msgIndex != msg.row) {
                    this.field_146289_q.func_78276_b(Integer.toString(msg.row + 1), x + 7 + (EmailConfigs.Main.Position.Current_Email.Row.X - this.field_146289_q.func_78256_a(Integer.toString(msg.row)) / 2), y - 1 + EmailConfigs.Main.Position.Current_Email.Row.Y + (this.field_146297_k.field_71466_p.field_78288_b + EmailConfigs.Main.Selected_Text_Spacing) * i, Color.BLACK.getRGB());
                    msgIndex = msg.row;
                } else {
                    boolean unicodeFlag = this.field_146289_q.func_82883_a();
                    this.field_146289_q.func_78264_a(false);
                    if (index + 1 >= this.showMessages.size() || this.showMessages.get((int)(index + 1)).row != msgIndex) {
                        this.field_146289_q.func_78276_b("\u255a", x + 5 + (EmailConfigs.Main.Position.Current_Email.Row.X - this.field_146289_q.func_78256_a(Integer.toString(msg.row)) / 2), y - 1 + EmailConfigs.Main.Position.Current_Email.Row.Y + (this.field_146297_k.field_71466_p.field_78288_b + EmailConfigs.Main.Selected_Text_Spacing) * i, Color.BLACK.getRGB());
                    } else {
                        this.field_146289_q.func_78276_b("\u2560", x + 5 + (EmailConfigs.Main.Position.Current_Email.Row.X - this.field_146289_q.func_78256_a(Integer.toString(msg.row)) / 2), y - 1 + EmailConfigs.Main.Position.Current_Email.Row.Y + (this.field_146297_k.field_71466_p.field_78288_b + EmailConfigs.Main.Selected_Text_Spacing) * i, Color.BLACK.getRGB());
                    }
                    this.field_146289_q.func_78264_a(unicodeFlag);
                }
                this.field_146289_q.func_78276_b(msg.msg, x + 7 + EmailConfigs.Main.Position.Current_Email.Msg.X, y - 1 + EmailConfigs.Main.Position.Current_Email.Msg.Y + (this.field_146297_k.field_71466_p.field_78288_b + EmailConfigs.Main.Selected_Text_Spacing) * i, Color.BLACK.getRGB());
            }
            if (email.hasItems()) {
                if (this.container.getCurrenEmail() == this.currentEmail) {
                    this.container.putStack(email.getItems());
                }
            } else if (!this.container.isEmpty()) {
                this.container.clear();
            }
            if (email.hasSound()) {
                this.field_146297_k.func_110434_K().func_110577_a(BackGround);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(x + 218, y + 4, 236, 0, 3, 12);
                Gui.func_152125_a((int)(x + 218 + 3), (int)(y + 5), (float)(1 + (this.currentSound != null ? 55 : 0)), (float)169.0f, (int)55, (int)55, (int)10, (int)10, (float)256.0f, (float)256.0f);
                if (GuiEmailMain.isInRange(mouseX, mouseY, x + 218, y + 4, 13, 12)) {
                    this.func_146279_a(I18n.func_135052_a((String)("info.email.play_sound" + (this.currentSound != null ? ".stop" : "")), (Object[])new Object[0]), mouseX, mouseY);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new InboxDrawEvent(this, InboxDrawEvent.Type.CURRENT, TickEvent.Phase.END, this.container.getInbox(), this.currentEmail, mouseX, mouseY));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.stopSound();
        this.isClose = true;
    }

    protected void func_73864_a(int mouseX, int mouseY, int btn) throws IOException {
        if (this.container.isRefresh()) {
            return;
        }
        this.lastClickX = mouseX;
        this.lastClickY = mouseY;
        if (GuiEmailMain.isInRange(mouseX, mouseY, this.getGuiLeft() + 5, this.getGuiTop() + 5, 7, 7) && this.refreshCoolingTicks <= 0) {
            this.refresh();
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return;
        }
        if (this.popupMenu.mouseClicked(this.field_146297_k, mouseX, mouseY, btn)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, btn);
        if (this.container.getInbox() == null || this.container.getInbox().emailCount() <= 0 || this.showEmails == null) {
            return;
        }
        for (int index = 0; index < 5; ++index) {
            if (!GuiEmailMain.isInRange(mouseX, mouseY, this.getGuiLeft() + this.Candidate_Email_X, this.getGuiTop() + this.Candidate_Email_Y + 19 * index, 60, 17)) continue;
            if (index >= this.showEmails.length) break;
            if (!this.container.getInbox().hasEmail(this.showEmails[index])) continue;
            if (btn == 0) {
                this.showEmail(index);
                break;
            }
            if (btn != 1) break;
            this.popupMenuCurrentEmail = this.showEmails[index];
            this.popupMenu.setCreatePoint(mouseX, mouseY);
            this.popupMenu.setVisible(true);
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            break;
        }
        if (GuiEmailMain.isInRange(mouseX, mouseY, this.getGuiLeft() + 218, this.getGuiTop() + 4, 13, 12) && this.currentEmail >= 0L && this.getCurrentEmail() != null && this.getCurrentEmail().hasSound()) {
            if (this.currentSound == null) {
                this.currentSound = new EmailSenderSndSound(this.getCurrentEmail().getSound(), this.currentEmail);
                MinecraftForge.EVENT_BUS.post((Event)new InboxPlaySoundEvent.Start(this.getCurrentEmail().getSound(), this.currentEmail));
                this.field_146297_k.func_147118_V().func_147682_a((ISound)this.currentSound);
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            } else {
                this.stopSound();
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        }
        boolean showPopupMenu = true;
        for (int index = 0; btn == 1 && index < 5; ++index) {
            if (!GuiEmailMain.isInRange(this.lastClickX, this.lastClickY, this.getGuiLeft() + this.Candidate_Email_X, this.getGuiTop() + this.Candidate_Email_Y + 17 * index - 1, 54, 15)) continue;
            if (index >= this.showEmails.length) break;
            showPopupMenu = false;
        }
        if (showPopupMenu) {
            this.popupMenu.setVisible(false);
        }
    }

    private void showEmail(int index) {
        Email email = this.container.getInbox().getEmail(this.showEmails[index]);
        if (email != null) {
            if (!email.isRead()) {
                if (this.container.getInboxSize() + 51L >= 0x200000L && !EmailConfigs.isInfiniteSize()) {
                    this.emailIsOutStorageSize();
                    return;
                }
                EmailMain.net.sendMessageToServer(new MsgReadEmail(this.showEmails[index]));
            }
            this.clearRenderText();
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (this.showEmails[index] != this.currentEmail) {
                this.stopSound();
            }
            this.currentEmail = this.showEmails[index];
            this.container.setCurrenEmail(this.currentEmail);
            if (this.container.getInbox().hasEmail(this.currentEmail)) {
                if (email.hasMessages()) {
                    int j;
                    this.formatMessage(email.getMsgs());
                    this.msgKeyMap = new int[this.showMessages.size()];
                    for (j = 0; j < this.showMessages.size(); ++j) {
                        this.msgKeyMap[j] = j;
                    }
                    this.currentMsg = new int[this.showMessages.size() > this.maxSelectedTextRows ? this.maxSelectedTextRows : this.showMessages.size()];
                    for (j = 0; j < this.showMessages.size() && j < this.currentMsg.length; ++j) {
                        this.currentMsg[j] = j;
                    }
                } else {
                    this.msgKeyMap = new int[0];
                    this.currentMsg = new int[0];
                    this.showMessages.clear();
                }
                this.msgPage = 0;
            }
        }
    }

    private void formatMessage(List<IInboxText> msgs) {
        this.showMessages.clear();
        int width = EmailConfigs.Main.Number_Of_Words.Current_Email.Message;
        if (EmailConfigs.Main.Enable_Vanilla_Wrap_Text) {
            for (int row = 0; row < msgs.size(); ++row) {
                String msg = msgs.get(row).format();
                if (msg.startsWith("&il")) {
                    msg = "    " + msg.substring(3);
                }
                ArrayList m = Lists.newArrayList();
                List formatMsg = this.field_146289_q.func_78271_c(msg, width);
                for (int index = 0; index < formatMsg.size(); ++index) {
                    m.add(new Message(row, index, (String)formatMsg.get(index)));
                }
                this.showMessages.addAll(m);
            }
        } else {
            for (int row = 0; row < msgs.size(); ++row) {
                String msg = msgs.get(row).format();
                if (msg.startsWith("&il")) {
                    msg = "    " + msg.substring(3);
                }
                if (this.field_146289_q.func_78256_a(msg) >= width) {
                    char[] chs = msg.toCharArray();
                    StringBuilder s = new StringBuilder();
                    int index = 0;
                    for (int k = 0; k < chs.length; ++k) {
                        s.append(chs[k]);
                        String formatStr = s.toString();
                        if (this.field_146289_q.func_78256_a(formatStr) < width) continue;
                        this.showMessages.add(new Message(row, index++, formatStr));
                        s.setLength(0);
                    }
                    if (s.length() <= 0) continue;
                    this.showMessages.add(new Message(row, index++, s.toString()));
                    continue;
                }
                this.showMessages.add(new Message(row, 0, msg));
            }
        }
    }

    private void refresh() {
        if (this.refreshCoolingTicks <= 0) {
            EmailMain.net.sendMessageToServer(new MsgRefreshInbox());
            this.container.setRefresh(true);
            this.currentMsg = null;
            this.currentEmail = -1L;
            this.currentSound = null;
            this.emailIDs = null;
            this.emailPage = -1;
            this.showEmails = null;
            this.popupMenuCurrentEmail = -1L;
            this.refreshCoolingTicks = 100;
            new Thread(() -> {
                while (!this.isClose && this.refreshCoolingTicks > 0) {
                    try {
                        Thread.sleep(50L);
                        --this.refreshCoolingTicks;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    protected Email getCurrentEmail() {
        return this.container.getInbox().getEmail(this.currentEmail);
    }

    public void stopSound() {
        if (this.currentSound != null) {
            if (this.field_146297_k.func_147118_V().func_147692_c((ISound)this.currentSound)) {
                this.field_146297_k.func_147118_V().func_147683_b((ISound)this.currentSound);
            }
            this.currentSound = null;
            MinecraftForge.EVENT_BUS.post((Event)new InboxPlaySoundEvent.Stop(this.currentEmail));
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public void func_73730_a(int startX, int endX, int y, int color) {
        super.func_73730_a(startX, endX, y, color);
    }

    public void func_73728_b(int x, int startY, int endY, int color) {
        super.func_73728_b(x, startY, endY, color);
    }

    public void drawAlignRightString(String text, int x, int y, int color, boolean drawShadow) {
        for (int i = text.length(); i > 0; --i) {
            char c = text.charAt(i - 1);
            float width = this.field_146289_q.func_78263_a(c);
            x = (int)((float)x - width);
            this.field_146289_q.func_175065_a(String.valueOf(c), (float)x, (float)y, color, drawShadow);
        }
    }

    public void drawCenteredString(String text, int x, int y, int color) {
        FontRenderer fr = this.field_146289_q;
        fr.func_175065_a(text, (float)(x - fr.func_78256_a(text) / 2), (float)y, color, false);
    }

    public void drawCenteredStringWithShadow(String text, int x, int y, int color) {
        FontRenderer fr = this.field_146289_q;
        fr.func_175065_a(text, (float)(x - fr.func_78256_a(text) / 2), (float)y, color, true);
    }

    public static boolean isInRange(int mouseX, int mouseY, int x, int y, int width, int height) {
        int maxX = x + width;
        int maxY = y + height;
        return mouseX >= x && mouseY >= y && mouseX <= maxX && mouseY <= maxY;
    }

    private static class Message {
        public final int row;
        public final int index;
        public final String msg;

        public Message(int row, int index, String msg) {
            this.row = row;
            this.index = index;
            this.msg = msg;
        }

        public String toString() {
            return "row:" + this.row + ",index:" + this.index + ", msg:" + this.msg;
        }
    }
}

