/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.ui.gui;

import cat.jiu.email.EmailAPI;
import cat.jiu.email.EmailMain;
import cat.jiu.email.element.Email;
import cat.jiu.email.element.InboxText;
import cat.jiu.email.net.msg.MsgOpenGui;
import cat.jiu.email.ui.container.ContainerEmailSend;
import cat.jiu.email.ui.gui.GuiEmailMain;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.EmailUtils;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiEmailSend
extends GuiContainer {
    public static final ResourceLocation BackGround = new ResourceLocation("email", "textures/gui/container/email_send.png");
    public static final ResourceLocation ANVIL_RESOURCE = new ResourceLocation("textures/gui/container/anvil.png");
    private GuiTextField nameField;
    private GuiTextField titleField;
    private final GuiTextField[] textFields;
    private int componentId = -1;
    private final ContainerEmailSend container = (ContainerEmailSend)this.field_147002_h;
    private long renderTicks = 0L;
    private String renderText;
    private Color renderColor;
    private int currenTextField = -1;

    private int nextID() {
        return this.componentId++;
    }

    public GuiEmailSend(World world, EntityPlayer player) {
        super((Container)new ContainerEmailSend(world, player));
        this.field_146999_f = 176;
        this.field_147000_g = 233;
        this.textFields = new GuiTextField[5];
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.nameField = new NameGuiTextField(this.nextID(), this.field_146289_q, this.getGuiLeft() + 39, this.getGuiTop() + 6, 109, 11);
        this.nameField.func_146193_g(-1);
        this.nameField.func_146204_h(-1);
        this.nameField.func_146203_f(100);
        this.nameField.func_146185_a(false);
        this.titleField = new GuiTextField(this.nextID(), this.field_146289_q, this.getGuiLeft() + 39, this.getGuiTop() + 20, 109, 11);
        this.titleField.func_146193_g(-1);
        this.titleField.func_146204_h(-1);
        this.titleField.func_146203_f(100);
        this.titleField.func_146185_a(false);
        this.initText();
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButton(this.nextID(), x + 149, y + 5, 22, 13, I18n.func_135052_a((String)"info.email.send", (Object[])new Object[0])){

            public void func_146118_a(int mouseX, int mouseY) {
                if (!GuiEmailSend.this.container.isCooling()) {
                    if (GuiEmailSend.this.container.isLock()) {
                        return;
                    }
                    String name = GuiEmailSend.this.nameField.func_146179_b();
                    if (name == null || name.isEmpty()) {
                        GuiEmailSend.this.setRenderText(I18n.func_135052_a((String)"info.email.error.empty_name", (Object[])new Object[0]), Color.RED);
                        return;
                    }
                    String title = GuiEmailSend.this.titleField.func_146179_b();
                    if (title == null || title.isEmpty()) {
                        title = "info.email.default_title";
                    }
                    if (GuiEmailSend.this.textsIsEmpty() && GuiEmailSend.this.container.isEmpty()) {
                        GuiEmailSend.this.setRenderText(I18n.func_135052_a((String)"info.email.error.empty_msgs_item", (Object[])new Object[0]), Color.RED);
                        return;
                    }
                    ArrayList msgs = Lists.newArrayList();
                    if (!GuiEmailSend.this.textsIsEmpty()) {
                        for (int i = 0; i < GuiEmailSend.this.textFields.length; ++i) {
                            String msg = GuiEmailSend.this.textFields[i].func_146179_b();
                            if (msg.isEmpty()) {
                                msgs.add(InboxText.empty);
                                continue;
                            }
                            StringBuilder sb = new StringBuilder();
                            for (int k = 0; k < msg.length(); ++k) {
                                char ch = msg.charAt(k);
                                if (ch == '&' && k + 1 < msg.length()) {
                                    if (GuiEmailSend.this.isFormatChar(msg.charAt(k + 1))) {
                                        sb.append('\u00a7');
                                    }
                                    sb.append(ch);
                                    continue;
                                }
                                sb.append(ch);
                            }
                            msgs.add(new InboxText(sb.toString(), new Object[0]));
                        }
                    } else {
                        msgs.add(new InboxText("info.email.default_msg", new Object[0]));
                    }
                    EmailAPI.sendPlayerEmail((EntityPlayer)GuiEmailSend.this.field_146297_k.field_71439_g, name, new Email(new InboxText(title, new Object[0]), new InboxText(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), new Object[0]), null, null, msgs));
                    GuiEmailSend.this.clearRenderText();
                }
            }
        });
        if (EmailConfigs.Send.Enable_Inbox_Button) {
            this.field_146292_n.add(new GuiButton(this.nextID(), x + 149, y + 20, 22, 10, I18n.func_135052_a((String)"info.email.receiving", (Object[])new Object[0])){

                public void func_146118_a(int mouseX, int mouseY) {
                    if (GuiEmailSend.this.container.isLock()) {
                        return;
                    }
                    EmailMain.net.sendMessageToServer(new MsgOpenGui(0));
                }
            });
        }
    }

    private void initText() {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i] = new GuiTextField(this.nextID(), this.field_146289_q, x + 9, y + 34 + 12 * i, 155, 12);
            GuiTextField field = this.textFields[i];
            field.func_146193_g(Color.WHITE.getRGB());
            field.func_146204_h(Color.WHITE.getRGB());
            field.func_146203_f(256);
            field.func_146185_a(false);
        }
    }

    private boolean isFormatChar(char c) {
        for (TextFormatting format : TextFormatting.values()) {
            if (format.field_96329_z != c) continue;
            return true;
        }
        return false;
    }

    public boolean textsIsEmpty() {
        for (int i = 0; i < this.textFields.length; ++i) {
            String msg = this.textFields[i].func_146179_b();
            if (msg == null || msg.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setRenderText(String text) {
        this.setRenderText(text, Color.RED);
    }

    public void setRenderText(String text, Color color) {
        this.setRenderText(text, color, EmailUtils.parseTick(0L, 0L, 0L, 15L, 0L));
    }

    public void setRenderText(String text, Color color, long ticks) {
        this.renderText = text;
        this.renderColor = color;
        this.renderTicks = ticks;
    }

    public void clearRenderText() {
        this.renderText = null;
        this.renderColor = null;
        this.renderTicks = 0L;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.email.addressee", (Object[])new Object[0]) + ":", 6, 6, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.email.title", (Object[])new Object[0]) + ":", 10, 21, Color.BLACK.getRGB());
        if (this.renderTicks > 0L && this.renderText != null && this.renderColor != null) {
            if (this.renderTicks <= 0L) {
                this.clearRenderText();
            }
            this.field_146289_q.func_78276_b(this.renderText, 88 - this.field_146289_q.func_78256_a(this.renderText) / 2, 138, this.renderColor.getRGB());
            --this.renderTicks;
        }
        if (this.container.renderTicks > 0L && this.container.renderText != null && this.container.renderColor != null) {
            if (this.container.renderTicks <= 0L) {
                this.clearRenderText();
            }
            this.field_146289_q.func_78276_b(this.container.renderText, 88 - this.field_146289_q.func_78256_a(this.container.renderText) / 2, 138, this.container.renderColor.getRGB());
            --this.container.renderTicks;
        }
        if (this.container.isCooling()) {
            long millis = this.container.getCoolingMillis() - System.currentTimeMillis();
            long t_0 = millis % 1000L;
            long t_mi = t_0 % 50L;
            long t_t = t_0 / 50L;
            long t_s = millis / 1000L;
            long t_m = 0L;
            if (t_s >= 60L) {
                t_m = t_s / 60L;
                t_s %= 60L;
            }
            long t_h = 0L;
            if (t_m >= 60L) {
                t_h = t_m / 60L;
                t_m %= 60L;
            }
            long t_d = 0L;
            if (t_h >= 24L) {
                t_d = t_h / 24L;
                t_h %= 24L;
            }
            String d = t_d < 10L ? "0" + t_d : Long.toString(t_d);
            String h = t_h < 10L ? "0" + t_h : Long.toString(t_h);
            String m = t_m < 10L ? "0" + t_m : Long.toString(t_m);
            String s = t_s < 10L ? "0" + t_s : Long.toString(t_s);
            String t = t_t < 10L ? "0" + t_t : Long.toString(t_t);
            String mi = t_t < 10L ? "0" + t_t : Long.toString(t_mi);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.email.cooling", (Object[])new Object[]{d, h, m, s, t, mi}), 45, 60, Color.RED.getRGB());
        }
        if (this.titleField.func_146179_b().isEmpty()) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.email.default_title", (Object[])new Object[0]), 39, 21, Color.BLACK.getRGB());
        }
        if (this.textsIsEmpty()) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.email.default_msg", (Object[])new Object[0]), 10, 34, Color.BLACK.getRGB());
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.container.isLock()) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        boolean lag = false;
        lag = this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
        if (lag) {
            this.currenTextField = 0;
        }
        if (lag = this.titleField.func_146192_a(mouseX, mouseY, mouseButton)) {
            this.currenTextField = 1;
        }
        for (int i = 0; i < this.textFields.length; ++i) {
            lag = this.textFields[i].func_146192_a(mouseX, mouseY, mouseButton);
            if (!lag) continue;
            this.currenTextField = 1 + i + 1;
        }
    }

    private GuiTextField getTextField(int id) {
        switch (id) {
            case 0: {
                return this.nameField;
            }
            case 1: {
                return this.titleField;
            }
            case 2: {
                return this.textFields[0];
            }
            case 3: {
                return this.textFields[1];
            }
            case 4: {
                return this.textFields[2];
            }
            case 5: {
                return this.textFields[3];
            }
            case 6: {
                return this.textFields[4];
            }
        }
        return null;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        GuiTextField curren;
        if (this.container.isLock() && (keyCode == 18 || keyCode == 1)) {
            return;
        }
        boolean flag = false;
        boolean lag = false;
        lag = this.nameField.func_146201_a(typedChar, keyCode);
        if (lag) {
            flag = true;
        }
        if (lag = this.titleField.func_146201_a(typedChar, keyCode)) {
            flag = true;
        }
        for (GuiTextField textField : this.textFields) {
            lag = textField.func_146201_a(typedChar, keyCode);
            if (!lag) continue;
            flag = true;
        }
        if (keyCode == 200 && (curren = this.getTextField(this.currenTextField - 1)) != null) {
            this.func_73864_a(curren.field_146209_f + curren.field_146218_h - 1, curren.field_146210_g + curren.field_146219_i - 1, 0);
            flag = true;
        }
        if (keyCode == 208 && (curren = this.getTextField(this.currenTextField + 1)) != null) {
            this.func_73864_a(curren.field_146209_f + curren.field_146218_h - 1, curren.field_146210_g + curren.field_146219_i - 1, 0);
            flag = true;
        }
        if (!flag) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int y;
        int x;
        super.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        this.titleField.func_146194_f();
        this.nameField.func_146194_f();
        for (GuiTextField tf : this.textFields) {
            tf.func_146194_f();
            this.field_146289_q.func_175065_a(tf.func_146179_b().length() + "/" + tf.func_146208_g(), (float)(tf.field_146209_f + tf.field_146218_h + 13), (float)(tf.field_146210_g + 2), Color.WHITE.getRGB(), true);
        }
        if (EmailConfigs.Send.Enable_Inbox_Button && GuiEmailMain.isInRange(mouseX, mouseY, (x = (this.field_146294_l - this.field_146999_f) / 2) + 149, (y = (this.field_146295_m - this.field_147000_g) / 2) + 20, 22, 10)) {
            super.func_146279_a(TextFormatting.RED + I18n.func_135052_a((String)"info.email.send.warn", (Object[])new Object[0]), mouseX, y + 48);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BackGround);
        super.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179094_E();
        super.func_73729_b(x + 163, y + 100, 176 + (this.container.isLock() ? 9 : 0), 0, 7, 7);
    }

    public static void drawAlignRightString(FontRenderer fr, String text, int x, int y, int color, boolean drawShadow) {
        for (int i = text.length(); i > 0; --i) {
            char c = text.charAt(i - 1);
            float width = fr.func_78263_a(c);
            x = (int)((float)x - width);
            fr.func_175065_a(String.valueOf(c), (float)x, (float)y, color, drawShadow);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class NameGuiTextField
    extends GuiTextField {
        private int index = 0;
        protected int absIndex = 0;

        public NameGuiTextField(int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height) {
            super(componentId, fontrendererObj, x, y, par5Width, par6Height);
        }

        public boolean func_146201_a(char typedChar, int keyCode) {
            boolean lag = super.func_146201_a(typedChar, keyCode);
            if (!lag && this.func_146206_l() && keyCode == 15) {
                List playerList = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73010_i;
                if (this.index < playerList.size()) {
                    String name = ((EntityPlayer)playerList.get(this.index)).func_70005_c_();
                    if (name.equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) && EmailConfigs.Send.Enable_Send_To_Self) {
                        super.func_146180_a(name);
                        ++this.index;
                        return lag;
                    }
                    super.func_146180_a(name);
                    lag = true;
                    ++this.index;
                } else if (this.index < playerList.size() + 2) {
                    ++this.absIndex;
                    if (this.absIndex == 1) {
                        super.func_146180_a("@p");
                    } else if (this.absIndex == 2) {
                        super.func_146180_a("@a");
                    }
                    if (this.absIndex >= 2) {
                        this.absIndex = 0;
                        this.index = 0;
                    }
                }
            }
            return lag;
        }

        public void func_146194_f() {
            super.func_146194_f();
            if ("@p".equals(this.func_146179_b())) {
                GuiEmailSend.drawAlignRightString(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)"info.email.@p", (Object[])new Object[0]), this.field_146209_f + this.field_146218_h - 2, this.field_146210_g, Color.BLACK.getRGB(), false);
            } else if ("@a".equals(this.func_146179_b())) {
                GuiEmailSend.drawAlignRightString(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)"info.email.@a", (Object[])new Object[0]), this.field_146209_f + this.field_146218_h - 2, this.field_146210_g, Color.BLACK.getRGB(), false);
            }
        }
    }
}

