/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.util;

import cat.jiu.email.EmailMain;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="email", name="jiu/email/main", category="config_main")
@Mod.EventBusSubscriber(modid="email")
public final class EmailConfigs {
    @Config.LangKey(value="email.config.infinite_size")
    @Config.Comment(value={"enable inbox infinite storage cache, \n\u6402cWarning: only enable on Single player."})
    public static boolean Enable_Inbox_Infinite_Storage_Cache = false;
    @Config.RequiresWorldRestart
    @Config.LangKey(value="email.config.save_to_root_directory")
    @Config.Comment(value={"save email to minecraft root directory\nsave email to world directory if false\ncan cross you saves send email if true"})
    public static boolean Save_To_Minecraft_Root_Directory = false;
    @Config.RequiresWorldRestart
    @Config.LangKey(value="email.config.save_inbox_to_sql")
    @Config.Comment(value={"save inbox to sql file(inboxs.db)\n\u6402cWarning: you need backup old inbox files!"})
    public static boolean Save_Inbox_To_SQL = false;
    @Config.LangKey(value="email.config.main")
    @Config.Comment(value={"email main"})
    public static Main Main = new Main();
    @Config.LangKey(value="email.config.send")
    @Config.Comment(value={"email send"})
    public static Send Send = new Send();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("email")) {
            if (EmailConfigs.Send.Enable_Send_BlackList && EmailConfigs.Send.Enable_Send_WhiteList) {
                EmailConfigs.Send.Enable_Send_BlackList = false;
                EmailConfigs.Send.Enable_Send_WhiteList = false;
            }
            ConfigManager.sync((String)"email", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static boolean isInfiniteSize() {
        return EmailMain.proxy.isClient() && Minecraft.func_71410_x().func_71356_B() && Enable_Inbox_Infinite_Storage_Cache;
    }

    public static class Pos {
        public int X;
        public int Y;

        public Pos(int x, int y) {
            this.X = x;
            this.Y = y;
        }
    }

    public static class Send {
        @Config.LangKey(value="email.config.send.blacklist")
        @Config.Comment(value={"enable send email black list, \n\u6402cCannot enable at the same time as White List"})
        public boolean Enable_Send_BlackList = false;
        @Config.LangKey(value="email.config.send.whitelist")
        @Config.Comment(value={"enable send email white list, \n\u6402cCannot enable at the same time as Black List"})
        public boolean Enable_Send_WhiteList = false;
        @Config.LangKey(value="email.config.send.send_to_self")
        @Config.Comment(value={"enable send email to self"})
        public boolean Enable_Send_To_Self = false;
        @Config.LangKey(value="email.config.send.cooling")
        @Config.Comment(value={"enable send email need cooling"})
        public boolean Enable_Send_Cooling = true;
        @Config.LangKey(value="email.config.send.inbox_button")
        @Config.Comment(value={"enable send email gui inbox button"})
        public boolean Enable_Inbox_Button = false;
        @Config.LangKey(value="email.config.send.cooling.time")
        @Config.Comment(value={"send email cooling time"})
        public Cooling cooling = new Cooling();

        public class Cooling {
            @Config.LangKey(value="email.config.time.day")
            @Config.Comment(value={"send cooling of day"})
            @Config.RangeInt(min=0)
            public int Day = 0;
            @Config.LangKey(value="email.config.time.hour")
            @Config.Comment(value={"send cooling of hour"})
            @Config.RangeInt(min=0)
            public int Hour = 0;
            @Config.LangKey(value="email.config.time.minute")
            @Config.Comment(value={"send cooling of minute"})
            @Config.RangeInt(min=0)
            public int Minute = 0;
            @Config.LangKey(value="email.config.time.second")
            @Config.Comment(value={"send cooling of second"})
            @Config.RangeInt(min=2)
            public int Second = 5;
            @Config.LangKey(value="email.config.time.tick")
            @Config.Comment(value={"send cooling of tick"})
            @Config.RangeInt(min=0)
            public int Tick = 0;
            @Config.LangKey(value="email.config.time.millis")
            @Config.Comment(value={"send cooling of millis"})
            @Config.RangeInt(min=0)
            public int Millis = 0;
        }
    }

    public static class Main {
        @Config.LangKey(value="email.config.main.show_text_rows")
        @Config.Comment(value={"selected text rows"})
        @Config.RangeInt(min=1, max=8)
        public int Selected_Text_Rows = 6;
        @Config.LangKey(value="email.config.main.show_text_spacing")
        @Config.Comment(value={"selected text spacing"})
        @Config.RangeInt(min=0)
        public int Selected_Text_Spacing = 3;
        @Config.LangKey(value="email.config.main.vanilla_wrap")
        @Config.Comment(value={"use vanilla to wrap text if true, else will use Single char wrap."})
        public boolean Enable_Vanilla_Wrap_Text = true;
        @Config.LangKey(value="email.config.main.size")
        @Config.Comment(value={"inbox gui size"})
        public Size Size = new Size();
        @Config.LangKey(value="email.config.main.pos")
        @Config.Comment(value={"text position"})
        public Position Position = new Position();
        @Config.LangKey(value="email.config.main.number_of_words")
        @Config.Comment(value={"Number of words"})
        public NumberOfWords Number_Of_Words = new NumberOfWords();

        public class NumberOfWords {
            @Config.LangKey(value="email.config.main.number_of_words.current")
            @Config.Comment(value={"current message"})
            public CurrentEmail Current_Email = new CurrentEmail();
            @Config.LangKey(value="email.config.main.number_of_words.candidate")
            @Config.Comment(value={"candidate msgs"})
            public CandidateEmail Candidate_Email = new CandidateEmail();

            public class CandidateEmail {
                @Config.LangKey(value="email.config.sender")
                @Config.RangeInt(min=1)
                public int Sender = 44;
            }

            public class CurrentEmail {
                @Config.LangKey(value="email.config.msg")
                @Config.RangeInt(min=1)
                public int Message = 106;
                @Config.LangKey(value="email.config.title")
                @Config.RangeInt(min=1)
                public int Title = 125;
                @Config.LangKey(value="email.config.sender")
                @Config.RangeInt(min=1)
                public int Sender = 61;
            }
        }

        public class Position {
            @Config.LangKey(value="email.config.main.number_of_words.current")
            @Config.Comment(value={"current email position"})
            public CurrentEmail Current_Email = new CurrentEmail();
            @Config.LangKey(value="email.config.main.number_of_words.candidate")
            @Config.Comment(value={"candidate msgs"})
            public Pos Candidate_Email = new Pos(18, 11);

            public class CurrentEmail {
                @Config.LangKey(value="email.config.main.pos.row")
                @Config.Comment(value={"row position"})
                public Pos Row = new Pos(93, 33);
                @Config.LangKey(value="email.config.msg")
                @Config.Comment(value={"message position"})
                public Pos Msg = new Pos(101, 33);
                @Config.LangKey(value="email.config.sender")
                @Config.Comment(value={"sender position"})
                public Pos Sender = new Pos(88, 20);
                @Config.LangKey(value="email.config.main.pos.current.msgid")
                @Config.Comment(value={"current msg ID position"})
                public Pos MsgID = new Pos(80, 6);
                @Config.LangKey(value="email.config.main.pos.current.items")
                @Config.Comment(value={"items position"})
                public Pos Items = new Pos(48, 109);
                @Config.LangKey(value="email.config.title")
                @Config.Comment(value={"title position"})
                public Title Title = new Title();

                public class Title {
                    public int X = 88;
                    public int Y = 6;
                    @Config.LangKey(value="email.config.main.pos.title.time")
                    @Config.Comment(value={"send time position"})
                    public Pos Time = new Pos(161, 20);
                }
            }
        }

        public class Size {
            @Config.LangKey(value="email.config.main.size.width")
            @Config.Comment(value={"gui width"})
            public int Width = 236;
            @Config.LangKey(value="email.config.main.size.height")
            @Config.Comment(value={"gui height"})
            public int Height = 168;
        }
    }
}

