/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.util;

import cat.jiu.email.EmailAPI;
import cat.jiu.email.element.EmailFunction;
import cat.jiu.email.element.Inbox;
import cat.jiu.email.element.event.EventCondition;
import cat.jiu.email.element.event.EventElement;
import cat.jiu.email.event.EmailSendDevMessageEvent;
import cat.jiu.email.util.EmailUtils;
import cat.jiu.email.util.JsonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber
public class EmailExecuteEvent {
    private static final Map<String, List<EventElement>> events = Maps.newHashMap();
    private static final Map<String, Object> defaultValue = Maps.newHashMap();

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        List<EventElement> elements;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer && (elements = events.get("PlayerJoinWorld")) != null && !elements.isEmpty()) {
            Inbox inbox = Inbox.get((EntityPlayer)event.getEntity());
            for (EventElement e : elements) {
                if (e.condition != null) {
                    Object defaultValue = inbox.getCustom(e.condition.name);
                    Object conValue = e.condition.defaultValue;
                    if (conValue == null || !EmailExecuteEvent.check(defaultValue, conValue) || Integer.valueOf(e.condition.getArg()) != null && e.condition.getArg() != event.getEntity().field_71093_bK) continue;
                    inbox.addCustom(e.condition.name, e.condition.after);
                    EmailFunction function = EmailUtils.findFunction(e.emailFile);
                    if (function != null) {
                        inbox.addEmail(function.toEmail());
                    }
                    EmailUtils.saveInboxToDisk(inbox);
                    continue;
                }
                EmailFunction function = EmailUtils.findFunction(e.emailFile);
                if (function != null) {
                    inbox.addEmail(function.toEmail());
                }
                EmailUtils.saveInboxToDisk(inbox, 10);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        List<EventElement> elements;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer && (elements = events.get("PlayerDeath")) != null && !elements.isEmpty()) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            int deathCount = player.field_70170_p.func_73046_m().func_184103_al().func_152602_a(player).func_77444_a(StatList.field_188069_A) + 1;
            Inbox inbox = Inbox.get(player);
            for (EventElement e : elements) {
                if (e.condition != null) {
                    Object defaultValue = inbox.getCustom(e.condition.name);
                    Object conValue = e.condition.defaultValue;
                    if (conValue == null || !EmailExecuteEvent.check(defaultValue, conValue) || Integer.valueOf(e.condition.getArg()) != null && e.condition.getArg() != deathCount) continue;
                    inbox.addCustom(e.condition.name, e.condition.after);
                    EmailFunction function = EmailUtils.findFunction(e.emailFile);
                    if (function != null) {
                        inbox.addEmail(function.toEmail());
                    }
                    EmailUtils.saveInboxToDisk(inbox, 10);
                    continue;
                }
                EmailFunction function = EmailUtils.findFunction(e.emailFile);
                if (function != null) {
                    inbox.addEmail(function.toEmail());
                }
                EmailUtils.saveInboxToDisk(inbox, 10);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerCraftItem(PlayerEvent.ItemCraftedEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerSmeltedItem(PlayerEvent.ItemSmeltedEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(EmailSendDevMessageEvent event) {
        List<EventElement> elements = events.get("PlayerFirstLogin");
        if (elements != null && !elements.isEmpty()) {
            Inbox inbox = event.inbox;
            for (EventElement e : elements) {
                if (e.condition != null) {
                    Object value = inbox.getCustom(e.condition.name);
                    Object defaultValue = e.condition.defaultValue;
                    if (defaultValue == null || !EmailExecuteEvent.check(value, defaultValue)) continue;
                    inbox.addCustom(e.condition.name, e.condition.after);
                    EmailFunction function = EmailUtils.findFunction(e.emailFile);
                    if (function == null) continue;
                    inbox.addEmail(function.toEmail());
                    continue;
                }
                EmailFunction function = EmailUtils.findFunction(e.emailFile);
                if (function == null) continue;
                inbox.addEmail(function.toEmail());
            }
        }
    }

    public static void initDefaultCustomValue(Inbox inbox) {
        for (Map.Entry<String, Object> defaultValue : EmailExecuteEvent.defaultValue.entrySet()) {
            String key = defaultValue.getKey();
            Object value = defaultValue.getValue();
            if (inbox.hasCustomValue(key)) continue;
            inbox.addCustom(key, value);
        }
    }

    private static boolean check(Object value, Object condition) {
        if (value instanceof Boolean && condition instanceof Boolean) {
            return ((Boolean)value).booleanValue() == ((Boolean)condition).booleanValue();
        }
        if (value instanceof Integer && condition instanceof Integer) {
            return ((Integer)value).intValue() == ((Integer)condition).intValue();
        }
        if (value instanceof ItemStack && condition instanceof ItemStack) {
            return EmailUtils.equalsStack((ItemStack)value, (ItemStack)condition, true, true, true);
        }
        return false;
    }

    public static void init() {
        events.clear();
        defaultValue.clear();
        File dir = new File(EmailAPI.getTypePath() + "event" + File.separator);
        if (dir.exists() && dir.isDirectory()) {
            List<File> eventFiles = EmailUtils.getAllFiles(dir);
            for (File file : eventFiles) {
                Object e = JsonUtil.parse(file);
                if (e == null || !e.isJsonObject()) continue;
                for (Map.Entry events : e.getAsJsonObject().entrySet()) {
                    ArrayList elements = Lists.newArrayList();
                    JsonArray eventEntrys = ((JsonElement)events.getValue()).getAsJsonArray();
                    for (int i = 0; i < eventEntrys.size(); ++i) {
                        JsonObject function = eventEntrys.get(i).getAsJsonObject();
                        EventCondition condition = null;
                        if (function.has("condition")) {
                            JsonObject conditionJson = function.getAsJsonObject("condition");
                            Object defaultValue = null;
                            JsonElement valueElement = conditionJson.get("default");
                            if (valueElement.isJsonPrimitive()) {
                                JsonPrimitive pri = valueElement.getAsJsonPrimitive();
                                defaultValue = pri.isNumber() ? pri.getAsNumber() : (pri.isBoolean() ? Boolean.valueOf(pri.getAsBoolean()) : pri.getAsString());
                            }
                            EmailExecuteEvent.defaultValue.put(conditionJson.get("name").getAsString(), defaultValue);
                            Object after = null;
                            JsonElement afterElement = conditionJson.get("after");
                            if (afterElement.isJsonPrimitive()) {
                                JsonPrimitive pri = afterElement.getAsJsonPrimitive();
                                after = pri.isNumber() ? pri.getAsNumber() : (pri.isBoolean() ? Boolean.valueOf(pri.getAsBoolean()) : pri.getAsString());
                            }
                            condition = new EventCondition(conditionJson.get("name").getAsString(), defaultValue, after);
                            if (conditionJson.has("arg")) {
                                condition.setArg(conditionJson.getAsJsonPrimitive("arg").getAsInt());
                            }
                        }
                        elements.add(new EventElement(function.get("email").getAsString(), condition));
                    }
                    EmailExecuteEvent.events.put((String)events.getKey(), elements);
                }
            }
        }
    }
}

