/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.util;

import cat.jiu.email.EmailAPI;
import cat.jiu.email.EmailMain;
import cat.jiu.email.element.Email;
import cat.jiu.email.element.EmailFunction;
import cat.jiu.email.element.Inbox;
import cat.jiu.email.element.InboxSound;
import cat.jiu.email.element.InboxText;
import cat.jiu.email.element.InboxTime;
import cat.jiu.email.util.EmailConfigs;
import cat.jiu.email.util.JsonToStackUtil;
import cat.jiu.email.util.JsonUtil;
import cat.jiu.email.util.SizeReport;
import cat.jiu.sql.SQLDatabase;
import cat.jiu.sql.SQLOperator;
import cat.jiu.sql.SQLSelect;
import cat.jiu.sql.SQLSelectType;
import cat.jiu.sql.SQLTableKey;
import cat.jiu.sql.SQLValues;
import cat.jiu.sql.select.Where;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class EmailUtils {
    public static final JsonParser parser = new JsonParser();
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final HashMap<String, UUID> NameToUUID = Maps.newHashMap();
    private static final HashMap<UUID, String> UUIDToName = Maps.newHashMap();

    public static String getTime() {
        return dateFormat.format(new Date());
    }

    public static void sendMessage(EntityPlayer player, TextFormatting color, String key, Object ... args) {
        player.func_145747_a(EmailUtils.createTextComponent(color, key, args));
    }

    public static void sendMessage(EntityPlayer player, String key, Object ... args) {
        player.func_145747_a(EmailUtils.createTextComponent(key, args));
    }

    public static boolean saveInboxToDisk(Inbox inbox) {
        return EmailUtils.saveInboxToDisk(inbox, 10);
    }

    public static boolean saveInboxToDisk(Inbox inbox, int maxRetryCount) {
        int retry;
        if (EmailMain.proxy.isClient() && !Minecraft.func_71410_x().func_71387_A()) {
            EmailMain.log.error("Client can not save inbox to Server!");
            return false;
        }
        boolean succes = false;
        for (retry = 0; retry < maxRetryCount; ++retry) {
            if (!inbox.saveToDisk()) continue;
            succes = true;
            break;
        }
        if (succes) {
            return true;
        }
        EmailMain.log.error("Can not save Inbox to Disk! Owner: {}, UUID: {}, Retry count: {}", (Object)inbox.getOwner(), (Object)inbox.getOwnerAsUUID(), (Object)retry);
        return false;
    }

    public static List<File> getAllFiles(File dir) {
        ArrayList files = Lists.newArrayList();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                files.addAll(EmailUtils.getAllFiles(file));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    public static EmailFunction findFunction(String file) {
        Object e;
        File functionFile = EmailUtils.findFunctionFile(new File(EmailAPI.getTypePath()), file);
        if (functionFile != null && (e = JsonUtil.parse(functionFile)) != null && e.isJsonObject()) {
            int i;
            JsonObject function = e.getAsJsonObject();
            ArrayList msgs = null;
            if (function.has("msgs")) {
                msgs = Lists.newArrayList();
                JsonElement msgE = function.get("msgs");
                if (msgE.isJsonPrimitive()) {
                    msgs.add(new InboxText(msgE.getAsString(), new Object[0]));
                } else if (msgE.isJsonArray()) {
                    JsonArray msgsArray = msgE.getAsJsonArray();
                    for (i = 0; i < msgsArray.size(); ++i) {
                        msgs.add(new InboxText(msgsArray.get(i).getAsString(), new Object[0]));
                    }
                } else if (msgE.isJsonObject()) {
                    for (Map.Entry msg : msgE.getAsJsonObject().entrySet()) {
                        JsonArray argJson = ((JsonElement)msg.getValue()).getAsJsonArray();
                        Object[] arg = new Object[argJson.size()];
                        for (int i2 = 0; i2 < arg.length; ++i2) {
                            arg[i2] = argJson.get(i2).getAsString();
                        }
                        msgs.add(new InboxText((String)msg.getKey(), arg));
                    }
                }
            }
            List<Object> items = null;
            if (function.has("items")) {
                ItemStack stack;
                JsonElement itemE = function.get("items");
                if (itemE.isJsonPrimitive() && itemE.getAsJsonPrimitive().isString()) {
                    ItemStack stack2 = JsonToStackUtil.toStack(function.get("items"));
                    if (stack2 != null) {
                        items = Lists.newArrayList((Object[])new ItemStack[]{stack2});
                    } else {
                        String path = function.get("items").getAsString();
                        Object itemsE = JsonUtil.parse(EmailAPI.getExportPath() + path);
                        if (itemsE != null) {
                            items = JsonToStackUtil.toStacks(itemsE);
                        }
                    }
                } else if (itemE.isJsonObject()) {
                    items = Lists.newArrayList();
                    for (Map.Entry item : itemE.getAsJsonObject().entrySet()) {
                        if (((JsonElement)item.getValue()).isJsonPrimitive()) {
                            stack = JsonToStackUtil.toStack((JsonElement)item.getValue());
                            if (stack != null) {
                                items.add(stack);
                                continue;
                            }
                            Object itemsE = JsonUtil.parse(EmailAPI.getExportPath() + ((JsonElement)item.getValue()).getAsJsonPrimitive().getAsString());
                            if (itemsE == null) continue;
                            for (ItemStack stack0 : JsonToStackUtil.toStacks(itemsE)) {
                                if (stack0 == null) continue;
                                items.add(stack0);
                            }
                            continue;
                        }
                        items.add(JsonToStackUtil.toStack((JsonElement)item.getValue()));
                    }
                } else if (itemE.isJsonArray()) {
                    items = Lists.newArrayList();
                    for (i = 0; i < itemE.getAsJsonArray().size(); ++i) {
                        Map.Entry item;
                        item = itemE.getAsJsonArray().get(i);
                        if (item.isJsonPrimitive()) {
                            stack = JsonToStackUtil.toStack((JsonElement)item);
                            if (stack != null) {
                                items.add(stack);
                                continue;
                            }
                            Object itemsE = JsonUtil.parse(EmailAPI.getExportPath() + item.getAsJsonPrimitive().getAsString());
                            if (itemsE == null) continue;
                            for (ItemStack stack0 : JsonToStackUtil.toStacks(itemsE)) {
                                if (stack0 == null) continue;
                                items.add(stack0);
                            }
                            continue;
                        }
                        stack = JsonToStackUtil.toStack((JsonElement)item);
                        if (stack == null) continue;
                        items.add(stack);
                    }
                }
            }
            InboxSound sound = null;
            if (function.has("sound")) {
                JsonObject jsonSound = function.getAsJsonObject("sound");
                sound = new InboxSound(new InboxTime(jsonSound.get("millis").getAsLong()), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(jsonSound.get("name").getAsString())), jsonSound.get("volume").getAsFloat(), jsonSound.get("pitch").getAsFloat());
            }
            return new EmailFunction(new InboxText(function.get("sender")), function.get("addresser").getAsString(), new InboxText(function.get("title")), (List<ItemStack>)items, msgs, sound);
        }
        return null;
    }

    private static File findFunctionFile(File dir, String name) {
        if (dir == null || !dir.exists()) {
            return null;
        }
        for (File subFile : dir.listFiles()) {
            if (subFile.isDirectory() && !"export".equals(subFile.getName()) && !"event".equals(subFile.getName())) {
                File f = EmailUtils.findFunctionFile(subFile, name);
                if (f == null) continue;
                return f;
            }
            if (!subFile.getName().equals(name)) continue;
            return subFile;
        }
        return null;
    }

    public static ITextComponent createTextComponent(String arg, Object ... objs) {
        return new TextComponentTranslation(arg, objs);
    }

    public static ITextComponent createTextComponent(TextFormatting color, String arg, Object ... objs) {
        TextComponentTranslation text = new TextComponentTranslation(arg, objs);
        return text.func_150255_a(text.func_150256_b().func_150238_a(color));
    }

    public static SizeReport checkEmailSize(Email email) {
        long size;
        if (email == null) {
            return SizeReport.SUCCES;
        }
        if (email.hasItems()) {
            List<ItemStack> items = email.getItems();
            for (int slot = 0; slot < items.size(); ++slot) {
                long size2 = EmailUtils.getSize(items.get(slot).func_77955_b(new NBTTagCompound()));
                if (size2 < 0x200000L) continue;
                return new SizeReport(-1L, slot, size2);
            }
        }
        return (size = EmailUtils.getSize(email.writeTo(NBTTagCompound.class))) >= 0x200000L ? new SizeReport(-1L, -1, size) : SizeReport.SUCCES;
    }

    public static SizeReport checkInboxSize(Inbox inbox) {
        if (inbox == null || inbox.isEmptyInbox()) {
            return SizeReport.SUCCES;
        }
        for (long id : inbox.getEmailIDs()) {
            Email email = inbox.getEmail(id);
            if (email == null) {
                inbox.deleteEmail(id);
                continue;
            }
            long emailSize = EmailUtils.getSize(email.writeTo(NBTTagCompound.class));
            if (emailSize >= 0x200000L) {
                return new SizeReport(id, -1, emailSize);
            }
            if (!email.hasItems()) continue;
            List<ItemStack> items = email.getItems();
            for (int slot = 0; slot < items.size(); ++slot) {
                long size = EmailUtils.getSize(items.get(slot).func_77955_b(new NBTTagCompound()));
                if (size < 0x200000L) continue;
                return new SizeReport(id, slot, size);
            }
        }
        long size = inbox.getInboxSize();
        return size >= 0x200000L ? new SizeReport(-1L, -1, size) : SizeReport.SUCCES;
    }

    public static long getSize(NBTTagCompound nbt) {
        if (nbt == null) {
            return 0L;
        }
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
        pb.func_150786_a(nbt);
        int index = pb.readerIndex();
        if (pb.readByte() == 0) {
            return 0L;
        }
        pb.readerIndex(index);
        NBTSizeTracker tracker = new NBTSizeTracker(0L){

            public void func_152450_a(long bits) {
                this.field_152453_c += bits / 8L;
            }
        };
        try {
            CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)pb), (NBTSizeTracker)tracker);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tracker.field_152453_c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveInboxToDB(Inbox inbox) {
        if (EmailMain.SQLite_INIT) {
            SQLDatabase db = null;
            try {
                Class<EmailUtils> clazz = EmailUtils.class;
                synchronized (EmailUtils.class) {
                    db = new SQLDatabase("jdbc:sqlite:" + EmailAPI.getSaveEmailRootPath() + File.separator + "inbox.db");
                    db.prepared.createTable("inboxs", new SQLTableKey().put("uuid", db.createKey(JDBCType.VARCHAR).setNotNull(true).setPrimaryKey(true)).put("inbox", db.createKey(JDBCType.VARCHAR).setNotNull(true)));
                    db.prepared.delete("inboxs", new SQLSelect(SQLSelectType.WHERE, inbox.getOwner()).add(new Where("uuid", SQLOperator.EQUAL, "?", null)));
                    db.prepared.insert("inboxs", inbox.writeTo(SQLValues.class));
                    try {
                        db.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                EmailMain.log.error("{}", (Object)e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (db != null) {
                    try {
                        db.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject getInboxJson(String uid) {
        if (!EmailConfigs.Save_Inbox_To_SQL) {
            File email = new File(EmailAPI.getSaveInboxPath() + uid + ".json");
            if (!email.exists()) return new JsonObject();
            Object file = JsonUtil.parse(email);
            if (file == null) return new JsonObject();
            if (!file.isJsonObject()) return new JsonObject();
            return file.getAsJsonObject();
        }
        if (!EmailMain.SQLite_INIT) return new JsonObject();
        SQLDatabase db = null;
        Class<EmailUtils> clazz = EmailUtils.class;
        synchronized (EmailUtils.class) {
            db = new SQLDatabase("jdbc:sqlite:" + EmailAPI.getSaveEmailRootPath() + File.separator + "inbox.db");
            ResultSet rs = db.prepared.select("inboxs", new SQLSelect(SQLSelectType.WHERE, uid).add(new Where("uuid", SQLOperator.EQUAL, "?", null)));
            JsonObject json = null;
            if (rs.next()) {
                String str = rs.getString("inbox");
                json = str.isEmpty() ? new JsonObject() : JsonUtil.parser.parse(str).getAsJsonObject();
            }
            try {
                db.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JsonObject jsonObject = json;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return jsonObject;
        }
        {
            catch (Exception e) {
                EmailMain.log.warn("found inbox data has error: {}", (Object)e.getLocalizedMessage());
                return new JsonObject();
            }
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static void initNameAndUUID(@Nullable MinecraftServer server) {
        File file;
        if (EmailMain.proxy.isClient() && !Minecraft.func_71410_x().func_71387_A()) {
            return;
        }
        if (server != null) {
            server.func_152358_ax().func_152658_c();
            server.func_152358_ax().func_152657_b();
        }
        if ((file = new File("./usercache.json")).exists()) {
            NameToUUID.clear();
            UUIDToName.clear();
            try (FileInputStream in = new FileInputStream(file);){
                JsonArray array = parser.parse((Reader)new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)).getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject player = array.get(i).getAsJsonObject();
                    String name = player.get("name").getAsString();
                    UUID uid = UUID.fromString(player.get("uuid").getAsString());
                    NameToUUID.put(name, uid);
                    UUIDToName.put(uid, name);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean hasName(String name) {
        return NameToUUID.containsKey(name) && UUIDToName.containsValue(name);
    }

    public static boolean hasUUID(UUID uid) {
        return UUIDToName.containsKey(uid) && NameToUUID.containsValue(uid);
    }

    public static UUID getUUID(String name) {
        if (EmailUtils.hasName(name)) {
            UUID uid = NameToUUID.get(name);
            if (uid == null) {
                for (Map.Entry<UUID, String> uuid : UUIDToName.entrySet()) {
                    if (!uuid.getValue().equals(name)) continue;
                    uid = uuid.getKey();
                    NameToUUID.put(name, uid);
                    break;
                }
            }
            return uid;
        }
        return null;
    }

    public static String getName(UUID uid) {
        if (EmailUtils.hasUUID(uid)) {
            String name = UUIDToName.get(uid);
            if (name == null) {
                for (Map.Entry<String, UUID> names : NameToUUID.entrySet()) {
                    if (!names.getValue().equals(uid)) continue;
                    name = names.getKey();
                    UUIDToName.put(uid, name);
                    break;
                }
            }
            return name;
        }
        return null;
    }

    public static Set<UUID> getAllUUID() {
        return Sets.newHashSet(UUIDToName.keySet());
    }

    public static Set<String> getAllName() {
        return Sets.newHashSet(NameToUUID.keySet());
    }

    public static boolean equalsStack(ItemStack stackA, ItemStack stackB, boolean checkDamage, boolean checkAmout, boolean checkNBT) {
        if (stackA == null || stackB == null) {
            return false;
        }
        if (stackA.func_190926_b() || stackB.func_190926_b()) {
            return false;
        }
        if (stackA == stackB) {
            return true;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (checkDamage && stackA.func_77960_j() != stackB.func_77960_j()) {
            return false;
        }
        if (checkAmout && stackA.func_190916_E() != stackB.func_190916_E()) {
            return false;
        }
        if (checkNBT) {
            if (stackA.func_77978_p() != null && stackB.func_77978_p() != null) {
                if (!stackA.func_77978_p().equals((Object)stackB.func_77978_p())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static void spawnAsEntity(EntityPlayer player, List<ItemStack> stacks) {
        if (stacks == null || stacks.size() == 0) {
            return;
        }
        World worldIn = player.func_130014_f_();
        BlockPos pos = player.func_180425_c();
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            for (ItemStack stack : stacks) {
                if (stack == null) continue;
                EntityItem item = new EntityItem(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), stack.func_77946_l());
                item.field_70159_w = 0.0;
                item.field_70181_x = 0.0;
                item.field_70179_y = 0.0;
                item.func_174868_q();
                item.func_174873_u();
                worldIn.func_72838_d((Entity)item);
            }
        }
    }

    public static void spawnAsEntity(EntityPlayer player, ItemStackHandler handler) {
        if (handler == null || handler.getSlots() == 0) {
            return;
        }
        World world = player.func_130014_f_();
        Vec3d pos = player.func_174791_d();
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                EntityItem item = new EntityItem(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack);
                item.field_70159_w = 0.0;
                item.field_70181_x = 0.0;
                item.field_70179_y = 0.0;
                item.func_174868_q();
                item.func_174873_u();
                world.func_72838_d((Entity)item);
            }
        }
    }

    public static long getCoolingMillis() {
        EmailConfigs.Send.Cooling cooling = EmailConfigs.Send.cooling;
        return EmailUtils.parseTick(cooling.Day, cooling.Hour, cooling.Minute, cooling.Second, cooling.Tick) * 50L + (long)cooling.Millis;
    }

    public static long parseTick(long day, long h, long m, long s, long tick) {
        return (((day * 24L + h) * 60L + m) * 60L + s) * 20L + tick;
    }

    public static long parseMillis(long day, long h, long m, long s, long tick, long ms) {
        return EmailUtils.parseMillis(day, h, m, s, tick * 50L + ms);
    }

    public static long parseMillis(long day, long h, long m, long s, long ms) {
        return (((day * 24L + h) * 60L + m) * 60L + s) * 1000L + ms;
    }

    @Deprecated
    public static boolean isInfiniteSize() {
        return EmailConfigs.isInfiniteSize();
    }
}

