/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.email.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public final class JsonToStackUtil {
    static final JsonParser parser = new JsonParser();

    public static ItemStack toStack(JsonElement e) {
        if (e == null) {
            return null;
        }
        if (e.isJsonObject()) {
            return JsonToStackUtil.toStack(e.getAsJsonObject());
        }
        if (e.isJsonPrimitive()) {
            return JsonToStackUtil.toStack(e.getAsString());
        }
        return null;
    }

    public static List<ItemStack> toStacks(JsonElement e) {
        if (e == null) {
            return null;
        }
        if (e.isJsonObject()) {
            return JsonToStackUtil.toStacks(e.getAsJsonObject());
        }
        if (e.isJsonArray()) {
            return JsonToStackUtil.toStacks(e.getAsJsonArray());
        }
        return null;
    }

    public static JsonArray toJsonArray(List<ItemStack> stacks, boolean useStringStack) {
        JsonArray array = new JsonArray();
        stacks.stream().forEach(stack -> {
            if (useStringStack) {
                String s = JsonToStackUtil.toString(stack);
                if (s != null) {
                    array.add(s);
                }
            } else {
                JsonObject e = JsonToStackUtil.toJson(stack);
                if (e != null) {
                    array.add((JsonElement)e);
                }
            }
        });
        return array;
    }

    public static JsonObject toJsonObject(List<ItemStack> stacks, boolean useStringStack) {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            String slot = Integer.toString(i);
            if (useStringStack) {
                String s = JsonToStackUtil.toString(stack);
                if (s == null) continue;
                obj.addProperty(slot, s);
                continue;
            }
            JsonObject e = JsonToStackUtil.toJson(stack);
            if (e == null) continue;
            obj.add(slot, (JsonElement)e);
        }
        return obj;
    }

    public static JsonObject toJson(ItemStack arg) {
        JsonObject nbt;
        if (arg == null || arg.func_190926_b()) {
            return null;
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("name", arg.func_77973_b().getRegistryName().toString());
        obj.addProperty("count", (Number)arg.func_190916_E());
        obj.addProperty("meta", (Number)arg.func_77960_j());
        if (arg.func_77942_o() && (nbt = JsonToStackUtil.toJson(arg.func_77978_p())) != null) {
            obj.add("nbt", (JsonElement)nbt);
        }
        return obj;
    }

    private static String toString(ItemStack arg) {
        JsonObject nbt;
        if (arg == null || arg.func_190926_b()) {
            return null;
        }
        StringJoiner j = new StringJoiner("@");
        j.add(arg.func_77973_b().getRegistryName().toString());
        j.add(Integer.toString(arg.func_190916_E()));
        j.add(Integer.toString(arg.func_77960_j()));
        if (arg.func_77942_o() && (nbt = JsonToStackUtil.toJson(arg.func_77978_p())) != null) {
            j.add(nbt.toString());
        }
        return j.toString();
    }

    public static JsonArray toJson(NBTTagList list) {
        JsonArray array = new JsonArray();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            JsonElement e = JsonToStackUtil.toJson(list.func_179238_g(i));
            if (e == null) continue;
            array.add(e);
        }
        return array;
    }

    public static JsonObject toJson(NBTTagCompound nbt) {
        JsonObject obj = new JsonObject();
        for (String key : nbt.func_150296_c()) {
            JsonElement e = JsonToStackUtil.toJson(nbt.func_74781_a(key));
            if (e == null) continue;
            if (e.isJsonPrimitive()) {
                JsonPrimitive pri = (JsonPrimitive)e;
                if (pri.isNumber()) {
                    JsonToStackUtil.addNumber(obj, key, pri);
                    continue;
                }
                if (pri.isString()) {
                    if (!obj.has("string")) {
                        obj.add("string", (JsonElement)new JsonObject());
                    }
                    obj.get("string").getAsJsonObject().add(key, (JsonElement)pri);
                    continue;
                }
                if (!pri.isBoolean()) continue;
                if (!obj.has("boolean")) {
                    obj.add("boolean", (JsonElement)new JsonObject());
                }
                obj.get("boolean").getAsJsonObject().add(key, (JsonElement)pri);
                continue;
            }
            if (e.isJsonObject()) {
                if (!obj.has("tags")) {
                    obj.add("tags", (JsonElement)new JsonObject());
                }
                obj.get("tags").getAsJsonObject().add(key, e);
                continue;
            }
            if (!e.isJsonArray()) continue;
            obj.add(key, e);
        }
        return obj;
    }

    private static void addNumber(JsonObject obj, String key, JsonPrimitive pri) {
        Number num = pri.getAsNumber();
        if (num instanceof Integer) {
            if (!obj.has("int")) {
                obj.add("int", (JsonElement)new JsonObject());
            }
            obj.get("int").getAsJsonObject().add(key, (JsonElement)pri);
        } else if (num instanceof Float) {
            if (!obj.has("float")) {
                obj.add("float", (JsonElement)new JsonObject());
            }
            obj.get("float").getAsJsonObject().add(key, (JsonElement)pri);
        } else if (num instanceof Short) {
            if (!obj.has("short")) {
                obj.add("short", (JsonElement)new JsonObject());
            }
            obj.get("short").getAsJsonObject().add(key, (JsonElement)pri);
        } else if (num instanceof Byte) {
            if (!obj.has("byte")) {
                obj.add("byte", (JsonElement)new JsonObject());
            }
            obj.get("byte").getAsJsonObject().add(key, (JsonElement)pri);
        } else if (num instanceof Double) {
            if (!obj.has("double")) {
                obj.add("double", (JsonElement)new JsonObject());
            }
            obj.get("double").getAsJsonObject().add(key, (JsonElement)pri);
        } else if (num instanceof Long) {
            if (!obj.has("long")) {
                obj.add("long", (JsonElement)new JsonObject());
            }
            obj.get("long").getAsJsonObject().add(key, (JsonElement)pri);
        }
    }

    private static JsonElement toJson(NBTBase base) {
        if (base instanceof NBTPrimitive) {
            NBTPrimitive pri = (NBTPrimitive)base;
            if (pri instanceof NBTTagByte) {
                return new JsonPrimitive((Number)pri.func_150290_f());
            }
            if (pri instanceof NBTTagInt) {
                return new JsonPrimitive((Number)pri.func_150287_d());
            }
            if (pri instanceof NBTTagLong) {
                return new JsonPrimitive((Number)pri.func_150291_c());
            }
            if (pri instanceof NBTTagDouble) {
                return new JsonPrimitive((Number)pri.func_150286_g());
            }
            if (pri instanceof NBTTagFloat) {
                return new JsonPrimitive((Number)Float.valueOf(pri.func_150288_h()));
            }
            if (pri instanceof NBTTagShort) {
                return new JsonPrimitive((Number)pri.func_150289_e());
            }
        } else {
            if (base instanceof NBTTagString) {
                JsonArray num_array = JsonToStackUtil.getNumberArray((NBTTagString)base);
                if (num_array != null) {
                    return num_array;
                }
                return new JsonPrimitive(((NBTTagString)base).func_150285_a_());
            }
            if (base instanceof NBTTagCompound) {
                return JsonToStackUtil.toJson((NBTTagCompound)base);
            }
            if (base instanceof NBTTagList) {
                return JsonToStackUtil.toJson((NBTTagList)base);
            }
            if (base instanceof NBTTagIntArray) {
                JsonArray array = new JsonArray();
                for (int i : ((NBTTagIntArray)base).func_150302_c()) {
                    array.add((Number)i);
                }
                return array;
            }
            if (base instanceof NBTTagByteArray) {
                JsonArray array = new JsonArray();
                for (byte i : ((NBTTagByteArray)base).func_150292_c()) {
                    array.add((Number)i);
                }
                return array;
            }
        }
        return null;
    }

    private static JsonArray getNumberArray(NBTTagString str) {
        String s = str.func_150285_a_().toLowerCase();
        if (s.contains("short_array@")) {
            JsonArray num_array = new JsonArray();
            String[] num_strs = JsonToStackUtil.custemSplitString("@", s);
            if (num_strs.length >= 2) {
                String nums = num_strs[1];
                if (nums.contains(",")) {
                    for (Short num : (Short[])JsonToStackUtil.toNumberArray(Short.class, (String[])JsonToStackUtil.custemSplitString(",", nums))) {
                        num_array.add((Number)num);
                    }
                } else {
                    num_array.add((Number)Short.parseShort(nums));
                }
            }
            return num_array;
        }
        if (s.contains("double_array@")) {
            JsonArray num_array = new JsonArray();
            String[] num_strs = JsonToStackUtil.custemSplitString("@", s);
            if (num_strs.length >= 2) {
                String nums = num_strs[1];
                if (nums.contains(",")) {
                    for (Double num : (Double[])JsonToStackUtil.toNumberArray(Double.class, (String[])JsonToStackUtil.custemSplitString(",", nums))) {
                        num_array.add((Number)num);
                    }
                } else {
                    num_array.add((Number)Double.parseDouble(nums));
                }
            }
            return num_array;
        }
        if (s.contains("float_array@")) {
            JsonArray num_array = new JsonArray();
            String[] num_strs = JsonToStackUtil.custemSplitString("@", s);
            if (num_strs.length >= 2) {
                String nums = num_strs[1];
                if (nums.contains(",")) {
                    for (Float num : (Float[])JsonToStackUtil.toNumberArray(Float.class, (String[])JsonToStackUtil.custemSplitString(",", nums))) {
                        num_array.add((Number)num);
                    }
                } else {
                    num_array.add((Number)Float.valueOf(Float.parseFloat(nums)));
                }
            }
            return num_array;
        }
        return null;
    }

    private static String[] custemSplitString(String arg, String separator) {
        if (arg == null || arg.isEmpty() || arg.equals("")) {
            return new String[]{"null"};
        }
        return arg.split("\\" + separator);
    }

    private static <T extends Number> T[] toNumberArray(Class<T> num, String[] strs) {
        if (num == Long.class) {
            Long[] numss = new Long[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                numss[i] = Long.parseLong(strs[i]);
            }
            return numss;
        }
        if (num == Integer.class) {
            Integer[] numss = new Integer[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                numss[i] = Integer.parseInt(strs[i]);
            }
            return numss;
        }
        if (num == Short.class) {
            Short[] numss = new Short[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                numss[i] = Short.parseShort(strs[i]);
            }
            return numss;
        }
        if (num == Byte.class) {
            Byte[] numss = new Byte[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                numss[i] = Byte.parseByte(strs[i]);
            }
            return numss;
        }
        if (num == Double.class) {
            Double[] numss = new Double[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                numss[i] = Double.parseDouble(strs[i]);
            }
            return numss;
        }
        if (num == Float.class) {
            Float[] numss = new Float[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                numss[i] = Float.valueOf(Float.parseFloat(strs[i]));
            }
            return numss;
        }
        return null;
    }

    private static List<ItemStack> toStacks(JsonArray array) {
        if (array.size() == 0) {
            return null;
        }
        ArrayList stacks = Lists.newArrayList();
        array.forEach(e -> {
            if (e.isJsonArray()) {
                List<ItemStack> stackss = JsonToStackUtil.toStacks(e);
                if (stackss != null) {
                    stacks.addAll(stackss);
                }
            } else {
                ItemStack s = JsonToStackUtil.toStack(e);
                if (s != null && !s.func_190926_b()) {
                    stacks.add(s);
                }
            }
        });
        if (stacks.isEmpty()) {
            return null;
        }
        return stacks;
    }

    private static List<ItemStack> toStacks(JsonObject obj) {
        if (obj.size() == 0) {
            return null;
        }
        ArrayList stacks = Lists.newArrayList();
        obj.entrySet().stream().forEach(es -> {
            JsonElement e = (JsonElement)es.getValue();
            if (e.isJsonArray()) {
                List<ItemStack> stackss = JsonToStackUtil.toStacks(e);
                if (stackss != null) {
                    stacks.addAll(stackss);
                }
            } else {
                ItemStack s = JsonToStackUtil.toStack(e);
                if (s != null && !s.func_190926_b()) {
                    stacks.add(s);
                }
            }
        });
        if (stacks.isEmpty()) {
            return null;
        }
        return stacks;
    }

    private static ItemStack toStack(JsonObject obj) {
        int count;
        if (obj == null) {
            return null;
        }
        if (!obj.has("name") && !obj.has("id")) {
            return null;
        }
        String name = obj.has("name") ? obj.get("name").getAsString() : obj.get("id").getAsString();
        Item item = Item.func_111206_d((String)name);
        if (item == null) {
            return null;
        }
        int n = obj.has("count") ? obj.get("count").getAsInt() : (count = obj.has("amount") ? obj.get("amount").getAsInt() : 1);
        int meta = obj.has("meta") ? obj.get("meta").getAsInt() : (obj.has("data") ? obj.get("data").getAsInt() : 0);
        NBTTagCompound nbt = obj.has("nbt") ? JsonToStackUtil.toNBT(obj.get("nbt").getAsJsonObject()) : null;
        return JsonToStackUtil.setNBT(new ItemStack(item, count, meta), nbt);
    }

    public static NBTTagCompound toNBT(JsonObject obj) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry objTags : obj.entrySet()) {
            Object[] num_array;
            int i;
            JsonArray array;
            String key = (String)objTags.getKey();
            JsonElement value = (JsonElement)objTags.getValue();
            if ("string".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    nbt.func_74778_a((String)nbts.getKey(), ((JsonElement)nbts.getValue()).getAsString());
                }
                continue;
            }
            if ("boolean".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    nbt.func_74757_a((String)nbts.getKey(), ((JsonElement)nbts.getValue()).getAsBoolean());
                }
                continue;
            }
            if ("int".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    nbt.func_74768_a((String)nbts.getKey(), ((JsonElement)nbts.getValue()).getAsInt());
                }
                continue;
            }
            if ("long".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    nbt.func_74772_a((String)nbts.getKey(), ((JsonElement)nbts.getValue()).getAsLong());
                }
                continue;
            }
            if ("float".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    nbt.func_74776_a((String)nbts.getKey(), ((JsonElement)nbts.getValue()).getAsFloat());
                }
                continue;
            }
            if ("double".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    nbt.func_74780_a((String)nbts.getKey(), ((JsonElement)nbts.getValue()).getAsDouble());
                }
                continue;
            }
            if ("byte".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    nbt.func_74774_a((String)nbts.getKey(), ((JsonElement)nbts.getValue()).getAsByte());
                }
                continue;
            }
            if ("short".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    nbt.func_74777_a((String)nbts.getKey(), ((JsonElement)nbts.getValue()).getAsShort());
                }
                continue;
            }
            if ("int_array".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    array = ((JsonElement)nbts.getValue()).getAsJsonArray();
                    int[] int_array = new int[array.size()];
                    for (i = 0; i < array.size(); ++i) {
                        int_array[i] = array.get(i).getAsInt();
                    }
                    nbt.func_74783_a((String)nbts.getKey(), int_array);
                }
                continue;
            }
            if ("short_array".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    array = ((JsonElement)nbts.getValue()).getAsJsonArray();
                    num_array = new short[array.size()];
                    for (i = 0; i < array.size(); ++i) {
                        num_array[i] = array.get(i).getAsShort();
                    }
                    JsonToStackUtil.setNBT(nbt, (String)nbts.getKey(), num_array);
                }
                continue;
            }
            if ("byte_array".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    array = ((JsonElement)nbts.getValue()).getAsJsonArray();
                    num_array = new byte[array.size()];
                    for (i = 0; i < array.size(); ++i) {
                        num_array[i] = array.get(i).getAsByte();
                    }
                    nbt.func_74773_a((String)nbts.getKey(), (byte[])num_array);
                }
                continue;
            }
            if ("double_array".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    array = ((JsonElement)nbts.getValue()).getAsJsonArray();
                    num_array = new double[array.size()];
                    for (i = 0; i < array.size(); ++i) {
                        num_array[i] = (short)array.get(i).getAsDouble();
                    }
                    JsonToStackUtil.setNBT(nbt, (String)nbts.getKey(), (double[])num_array);
                }
                continue;
            }
            if ("float_array".equals(key)) {
                for (Map.Entry nbts : value.getAsJsonObject().entrySet()) {
                    array = ((JsonElement)nbts.getValue()).getAsJsonArray();
                    num_array = new float[array.size()];
                    for (i = 0; i < array.size(); ++i) {
                        num_array[i] = (short)array.get(i).getAsFloat();
                    }
                    JsonToStackUtil.setNBT(nbt, (String)nbts.getKey(), (float[])num_array);
                }
                continue;
            }
            if ("tags".equals(key)) {
                for (Map.Entry tags : value.getAsJsonObject().entrySet()) {
                    nbt.func_74782_a((String)tags.getKey(), (NBTBase)JsonToStackUtil.toNBT(((JsonElement)tags.getValue()).getAsJsonObject()));
                }
                continue;
            }
            if (value.isJsonObject()) {
                nbt.func_74782_a(key, (NBTBase)JsonToStackUtil.toNBT(value.getAsJsonObject()));
                continue;
            }
            if (!value.isJsonArray()) continue;
            nbt.func_74782_a(key, (NBTBase)JsonToStackUtil.toNBT(value.getAsJsonArray()));
        }
        return nbt;
    }

    public static NBTTagList toNBT(JsonArray array) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement array_element = array.get(i);
            if (array_element.isJsonObject()) {
                list.func_74742_a((NBTBase)JsonToStackUtil.toNBT(array_element.getAsJsonObject()));
                continue;
            }
            if (array_element.isJsonArray()) {
                list.func_74742_a((NBTBase)JsonToStackUtil.toNBT(array_element.getAsJsonArray()));
                continue;
            }
            if (!array_element.isJsonPrimitive()) continue;
            JsonPrimitive pri = array_element.getAsJsonPrimitive();
            if (pri.isString()) {
                list.func_74742_a((NBTBase)new NBTTagString(pri.getAsString()));
                continue;
            }
            if (pri.isBoolean()) {
                list.func_74742_a((NBTBase)new NBTTagByte(pri.getAsBoolean() ? (byte)1 : 0));
                continue;
            }
            if (!pri.isNumber()) continue;
            Number num = pri.getAsNumber();
            if (num instanceof Integer) {
                list.func_74742_a((NBTBase)new NBTTagInt(((Integer)num).intValue()));
                continue;
            }
            if (num instanceof Double) {
                list.func_74742_a((NBTBase)new NBTTagDouble(((Double)num).doubleValue()));
                continue;
            }
            if (num instanceof Byte) {
                list.func_74742_a((NBTBase)new NBTTagByte(((Byte)num).byteValue()));
                continue;
            }
            if (num instanceof Long) {
                list.func_74742_a((NBTBase)new NBTTagLong(((Long)num).longValue()));
                continue;
            }
            if (num instanceof Float) {
                list.func_74742_a((NBTBase)new NBTTagFloat(((Float)num).floatValue()));
                continue;
            }
            if (!(num instanceof Short)) continue;
            list.func_74742_a((NBTBase)new NBTTagShort(((Short)num).shortValue()));
        }
        return list;
    }

    private static ItemStack toStack(String stack) {
        if (stack.contains("@")) {
            String[] name = stack.split("@");
            Item item = Item.func_111206_d((String)name[0]);
            if (item != null) {
                int meta = 0;
                int amount = 1;
                NBTTagCompound nbt = null;
                switch (name.length) {
                    case 4: {
                        nbt = JsonToStackUtil.toNBT(parser.parse(name[3]).getAsJsonObject());
                    }
                    case 3: {
                        meta = Integer.parseInt(name[2]);
                    }
                    case 2: {
                        amount = Integer.parseInt(name[1]);
                    }
                }
                return JsonToStackUtil.setNBT(new ItemStack(item, amount, meta), nbt);
            }
        } else {
            return new ItemStack(Item.func_111206_d((String)stack));
        }
        return null;
    }

    private static NBTTagCompound setNBT(NBTTagCompound nbt, String nbtName, double[] value) {
        nbt.func_74778_a(nbtName, "double_array@" + JsonToStackUtil.toString(JsonToStackUtil.toArray(value)));
        return nbt;
    }

    private static NBTTagCompound setNBT(NBTTagCompound nbt, String nbtName, float[] value) {
        nbt.func_74778_a(nbtName, "float_array@" + JsonToStackUtil.toString(JsonToStackUtil.toArray(value)));
        return nbt;
    }

    private static NBTTagCompound setNBT(NBTTagCompound nbt, String nbtName, short[] value) {
        nbt.func_74778_a(nbtName, "short_array@" + JsonToStackUtil.toString(JsonToStackUtil.toArray(value)));
        return nbt;
    }

    private static ItemStack setNBT(ItemStack stack, NBTTagCompound nbt) {
        if (nbt != null) {
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    private static <T> String toString(T[] args) {
        if (args == null || args.length == 0) {
            return "null";
        }
        ArrayList l = Lists.newArrayList();
        for (T i : args) {
            l.add(i.toString());
        }
        return JsonToStackUtil.toString(l.toArray(new String[0]));
    }

    private static Short[] toArray(short[] args) {
        Short[] arg = new Short[args.length];
        for (int i = 0; i < arg.length; ++i) {
            arg[i] = args[i];
        }
        return arg;
    }

    private static Double[] toArray(double[] args) {
        Double[] arg = new Double[args.length];
        for (int i = 0; i < arg.length; ++i) {
            arg[i] = args[i];
        }
        return arg;
    }

    private static Float[] toArray(float[] args) {
        Float[] arg = new Float[args.length];
        for (int i = 0; i < arg.length; ++i) {
            arg[i] = Float.valueOf(args[i]);
        }
        return arg;
    }

    private static String toString(String[] args) {
        if (args == null || args.length == 0) {
            return "null";
        }
        StringJoiner j = new StringJoiner(",");
        for (String arg : args) {
            j.add(arg);
        }
        return j.toString();
    }
}

