/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.sql;

import cat.jiu.sql.SQLDatabaseDrvier;
import cat.jiu.sql.SQLKey;
import cat.jiu.sql.SQLPreparedStatement;
import cat.jiu.sql.SQLStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class SQLDatabase
implements AutoCloseable {
    protected final Connection connection;
    protected final SQLDatabaseDrvier drvier;
    public final SQLPreparedStatement prepared;
    public final SQLStatement statement;

    public SQLDatabase(Connection connection) {
        this.connection = connection;
        this.drvier = this.getDrvier(connection.getClass().getName());
        this.prepared = this.getSQLPreparedStatement();
        this.statement = this.getSQLStatement();
    }

    public SQLDatabase(String url) throws SQLException {
        this(DriverManager.getConnection(url));
    }

    public SQLDatabase(String url, String username, String password) throws SQLException {
        this(DriverManager.getConnection(url, username, password));
    }

    public SQLDatabase(String url, Properties info) throws SQLException {
        this(DriverManager.getConnection(url, info));
    }

    public PreparedStatement getPreparedStatement(String sql, Object[] whereArgs) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        for (int i = 1; whereArgs != null && i < whereArgs.length + 1; ++i) {
            stmt.setString(i, String.valueOf(whereArgs[i - 1]));
        }
        return stmt;
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public PreparedStatement getPreparedStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement getPreparedStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement getPreparedStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(sql, columnNames);
    }

    public PreparedStatement getPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement getPreparedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Statement getStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public Statement getStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement getStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public SQLKey createKey(JDBCType type) {
        return new SQLKey(this.drvier, type);
    }

    @Override
    public void close() throws SQLException {
        if (!this.connection.getAutoCommit() && !this.connection.isClosed()) {
            this.connection.commit();
            this.connection.close();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected SQLPreparedStatement getSQLPreparedStatement() {
        return new SQLPreparedStatement(this);
    }

    protected SQLStatement getSQLStatement() {
        return new SQLStatement(this);
    }

    protected SQLDatabaseDrvier getDrvier(String name) {
        if ((name = name.toLowerCase()).startsWith("org.sqlite")) {
            return SQLDatabaseDrvier.SQLite;
        }
        if (name.startsWith("com.mysql")) {
            return SQLDatabaseDrvier.MYSQL;
        }
        if (name.startsWith("com.microsoft.sqlserver")) {
            return SQLDatabaseDrvier.SQLServer;
        }
        if (name.startsWith("oracle.jdbc")) {
            return SQLDatabaseDrvier.Oracle;
        }
        if (name.startsWith("sun.jdbc.odbc")) {
            return SQLDatabaseDrvier.Microsoft_Access;
        }
        if (name.startsWith("com.ibm.db2")) {
            return SQLDatabaseDrvier.IBM_DB2;
        }
        if (name.startsWith("org.postgresql")) {
            return SQLDatabaseDrvier.PostgreSQL;
        }
        return SQLDatabaseDrvier.UNKNOW;
    }
}

