/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.sql;

import cat.jiu.sql.SQLDatabaseDrvier;
import java.sql.JDBCType;
import java.util.StringJoiner;

public class SQLKey {
    protected final SQLDatabaseDrvier database;
    protected JDBCType type;
    protected Integer length;
    protected boolean isPrimaryKey;
    protected boolean isAutoIncrement;
    protected boolean isNotNull;
    protected Object default_value;

    protected SQLKey(SQLDatabaseDrvier database, JDBCType type) {
        this.type = type;
        this.database = database;
    }

    public SQLKey setPrimaryKey(boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
        return this;
    }

    public SQLKey setLength(int length) {
        this.length = length;
        return this;
    }

    public SQLKey setAutoIncrement(boolean isAutoIncrement) {
        if (this.type == JDBCType.INTEGER) {
            this.isAutoIncrement = isAutoIncrement;
        }
        return this;
    }

    public SQLKey setNotNull(boolean isNotNull) {
        this.isNotNull = isNotNull;
        return this;
    }

    public SQLKey setDefaultValue(Object value) {
        this.default_value = value;
        return this;
    }

    public SQLKey setType(JDBCType type) {
        if (type != null) {
            this.type = type;
        }
        return this;
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(" ");
        StringBuilder type = new StringBuilder(this.type.getName());
        if (this.length != null && !this.isAutoIncrement) {
            type.append("(").append(this.length).append(")");
        }
        sb.add(type);
        if (this.isPrimaryKey) {
            sb.add("primary key");
        }
        if (this.isAutoIncrement) {
            sb.add(this.getAutoincrement());
        }
        if (this.isNotNull) {
            sb.add("not null");
        }
        if (this.default_value != null) {
            sb.add("default");
        }
        sb.add(String.valueOf(this.default_value));
        return sb.toString();
    }

    protected String getAutoincrement() {
        switch (this.database) {
            case MYSQL: {
                return "auto_increment";
            }
            case Microsoft_Access: 
            case SQLite: {
                return "autoincrement";
            }
            case SQLServer: {
                return "indentity";
            }
            case Oracle: {
                return "increment";
            }
            case IBM_DB2: {
                return "generated always as identity";
            }
            case PostgreSQL: {
                return "serial";
            }
        }
        return "";
    }
}

