/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.sql;

import cat.jiu.sql.SQLDatabase;
import cat.jiu.sql.SQLJoinType;
import cat.jiu.sql.SQLSelect;
import cat.jiu.sql.SQLTableKey;
import cat.jiu.sql.SQLValues;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringJoiner;

public class SQLPreparedStatement {
    protected final SQLDatabase db;
    protected static final String[] keys = new String[]{"*"};

    protected SQLPreparedStatement(SQLDatabase db) {
        this.db = db;
    }

    public int insert(String table, SQLValues values) throws SQLException {
        return this.db.getPreparedStatement("insert into " + values.toTable(table)).executeUpdate();
    }

    public int delete(String table, SQLSelect where) throws SQLException {
        StringJoiner sql = new StringJoiner(" ", "", ";").add("DELETE FROM").add(table);
        if (where != null) {
            sql.add(where.type.name()).add(where.toString());
        }
        return this.db.getPreparedStatement(sql.toString(), where != null ? where.getArgs() : null).executeUpdate();
    }

    public int update(String table, SQLValues values, SQLSelect where) throws SQLException {
        StringJoiner sql = new StringJoiner(" ", "", ";").add("UPDATE").add(table).add("SET").add(values.toString());
        if (where != null) {
            sql.add(where.type.name()).add(where.toString());
        }
        return this.db.getPreparedStatement(sql.toString(), where != null ? where.getArgs() : null).executeUpdate();
    }

    public ResultSet select(String table, SQLSelect where) throws SQLException {
        return this.select(table, keys, where);
    }

    public ResultSet select(String table, String[] keys, SQLSelect where) throws SQLException {
        StringJoiner key = new StringJoiner(",");
        for (int i = 0; i < keys.length; ++i) {
            key.add(keys[i]);
        }
        StringJoiner sql = new StringJoiner(" ", "", ";").add("SELECT").add(key.toString()).add("FROM").add(table);
        if (where != null) {
            sql.add(where.type.name()).add(where.toString());
        }
        return this.db.getPreparedStatement(sql.toString(), where != null ? where.getArgs() : null).executeQuery();
    }

    public ResultSet joinSelect(String table1, String table2, SQLJoinType joinType, SQLSelect where) throws SQLException {
        return this.joinSelect(table1, table2, keys, joinType, where);
    }

    public ResultSet joinSelect(String table1, String table2, String[] keys, SQLJoinType joinType, SQLSelect where) throws SQLException {
        StringJoiner key = new StringJoiner(",");
        for (int i = 0; i < keys.length; ++i) {
            key.add(keys[i]);
        }
        StringJoiner sql = new StringJoiner(" ", "", ";").add("SELECT").add(key.toString()).add("FROM").add(table1).add(joinType.sql).add(table2);
        if (where != null) {
            sql.add(where.type.name()).add(where.toString());
        }
        return this.db.getPreparedStatement(sql.toString(), where != null ? where.getArgs() : null).executeQuery();
    }

    public boolean createTable(String name, SQLTableKey table) throws SQLException {
        StringJoiner sql = new StringJoiner(" ", "", ";").add("CREATE TABLE if not exists").add(name).add(table.toString());
        return this.execute(sql.toString());
    }

    public boolean dropIndex(String table, String index) throws SQLException {
        switch (this.db.drvier) {
            case MYSQL: {
                return this.execute("ALTER TABLE " + table + " DROP INDEX " + index);
            }
            case SQLServer: {
                return this.execute("DROP INDEX " + table + "." + index);
            }
        }
        return false;
    }

    public boolean dropTable(String name) throws SQLException {
        return this.execute("DROP TABLE if exists " + name);
    }

    public boolean dropTableAllValues(String name) throws SQLException {
        return this.execute("DELETE FROM " + name);
    }

    public boolean dropDatabase(String name) throws SQLException {
        return this.execute("DROP DATABASE if exists " + name);
    }

    public boolean execute(String sql) throws SQLException {
        return this.db.connection.prepareStatement(sql).execute();
    }

    public boolean execute(String sql, Object[] whereArgs) throws SQLException {
        return this.db.getPreparedStatement(sql, whereArgs).execute();
    }
}

