/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;

public class SQLValues {
    private final TreeMap<String, Object> values = new TreeMap();

    public SQLValues() {
    }

    public SQLValues(Map<String, Object> values) {
        this.values.putAll(values);
    }

    public SQLValues(SQLValues values) {
        this.values.putAll(values.values);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public void remove(String key) {
        this.values.remove(key);
    }

    public void clear() {
        this.values.clear();
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public Set<Map.Entry<String, Object>> valueSet() {
        return this.values.entrySet();
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public SQLValues putNull(String key) {
        this.values.put(key, null);
        return this;
    }

    public SQLValues put(String key, Object value) {
        this.values.put(key, value);
        return this;
    }

    public String getAsString(String key, String failBack) {
        Object o = this.values.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        return o != null ? o.toString() : failBack;
    }

    public Number getAsNumber(String key, Number failBack) {
        Object o = this.values.get(key);
        if (o instanceof Number) {
            return (Number)o;
        }
        return failBack;
    }

    public Byte getAsByte(String key, Byte failBack) {
        Number num = this.getAsNumber(key, failBack);
        if (num != null) {
            if (num instanceof Byte) {
                return (Byte)num;
            }
            return num.byteValue();
        }
        Object o = this.values.get(key);
        if (o instanceof CharSequence) {
            try {
                return Byte.valueOf(o.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return failBack;
    }

    public Short getAsShort(String key, Short failBack) {
        Number num = this.getAsNumber(key, failBack);
        if (num != null) {
            if (num instanceof Short) {
                return (Short)num;
            }
            return num.shortValue();
        }
        Object o = this.values.get(key);
        if (o instanceof CharSequence) {
            try {
                return Short.valueOf(o.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return failBack;
    }

    public Integer getAsInt(String key, Integer failBack) {
        Number num = this.getAsNumber(key, failBack);
        if (num != null) {
            if (num instanceof Integer) {
                return (Integer)num;
            }
            return num.intValue();
        }
        Object o = this.values.get(key);
        if (o instanceof CharSequence) {
            try {
                return Integer.valueOf(o.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return failBack;
    }

    public Long getAsLong(String key, Long failBack) {
        Number num = this.getAsNumber(key, failBack);
        if (num != null) {
            if (num instanceof Long) {
                return (Long)num;
            }
            return num.longValue();
        }
        Object o = this.values.get(key);
        if (o instanceof CharSequence) {
            try {
                return Long.valueOf(o.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return failBack;
    }

    public Float getAsFloat(String key, Float failBack) {
        Number num = this.getAsNumber(key, failBack);
        if (num != null) {
            if (num instanceof Float) {
                return (Float)num;
            }
            return Float.valueOf(num.floatValue());
        }
        Object o = this.values.get(key);
        if (o instanceof CharSequence) {
            try {
                return Float.valueOf(o.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return failBack;
    }

    public Double getAsDouble(String key, Double failBack) {
        Number num = this.getAsNumber(key, failBack);
        if (num != null) {
            if (num instanceof Double) {
                return (Double)num;
            }
            return num.doubleValue();
        }
        Object o = this.values.get(key);
        if (o instanceof CharSequence) {
            try {
                return Double.valueOf(o.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return failBack;
    }

    public Boolean getAsBoolean(String key, Boolean failBack) {
        Object o = this.values.get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof CharSequence) {
            try {
                return Boolean.valueOf(o.toString()) != false || "1".equals(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (o instanceof Number) {
            return this.getAsInt(key, failBack != false ? 1 : 0) != 0;
        }
        return failBack;
    }

    public byte[] getAsByteArray(String key, byte[] failBack) {
        Object o = this.values.get(key);
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        return failBack;
    }

    public ArrayList<String> getAsStringList(String key) {
        Object obj;
        ArrayList list;
        Iterator iterator;
        Object o = this.values.get(key);
        if (o instanceof ArrayList && (iterator = (list = (ArrayList)o).iterator()).hasNext() && (obj = iterator.next()) instanceof String) {
            return list;
        }
        return null;
    }

    public String toTable(String table) {
        StringJoiner sb = new StringJoiner(" ", "", ";");
        sb.add(table);
        StringJoiner keys = new StringJoiner(",", "(", ")");
        StringJoiner values = new StringJoiner(",", "(", ")");
        for (Map.Entry<String, Object> value : this.valueSet()) {
            keys.add(value.getKey());
            values.add("'" + String.valueOf(value.getValue()) + "'");
        }
        sb.add(keys.toString()).add("values").add(values.toString());
        return sb.toString();
    }

    public String toString() {
        StringJoiner s = new StringJoiner(",");
        for (String name : this.values.keySet()) {
            s.add(name + "='" + String.valueOf(this.get(name)) + "'");
        }
        return s.toString();
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLValues other = (SQLValues)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }
}

