/*
 * Decompiled with CFR 0.152.
 */
package cat.jiu.sql.select;

import cat.jiu.sql.SQLLogicOperator;
import cat.jiu.sql.SQLOperator;
import cat.jiu.sql.select.ISQLWhere;
import java.util.StringJoiner;

public class Where
implements ISQLWhere {
    protected final String id;
    protected final SQLOperator operator;
    protected final String wildcard;
    protected final SQLLogicOperator nextOperator;

    public Where(String id, SQLOperator operator, String wildcard, SQLLogicOperator nextOperator) {
        this.id = id;
        this.operator = operator;
        this.wildcard = this.operator == SQLOperator.IS_NULL ? "" : wildcard;
        this.nextOperator = nextOperator;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SQLOperator getOperator() {
        return this.operator;
    }

    @Override
    public SQLLogicOperator getNextOperator() {
        return this.nextOperator;
    }

    @Override
    public String toSQL() {
        StringJoiner sb = new StringJoiner(" ");
        sb.add(this.id);
        sb.add(this.operator.sql);
        if (this.operator == SQLOperator.LIKE || this.operator == SQLOperator.NOT_LIKE) {
            sb.add(new StringBuilder().append("'").append(this.wildcard).append("'"));
        } else if (this.operator != SQLOperator.IS_NULL || this.operator != SQLOperator.EXISTS || this.operator != SQLOperator.NOT_EXISTS) {
            sb.add(this.wildcard);
        }
        return sb.toString();
    }
}

