/*
 * Decompiled with CFR 0.152.
 */
package io.github.mribby.endercompass;

import io.github.mribby.endercompass.ItemEnderCompass;
import io.github.mribby.endercompass.network.CMessageGetStrongholdPos;
import io.github.mribby.endercompass.network.SMessageSetStrongholdPos;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="endercompass", name="Ender Compass", version="1.0", acceptedMinecraftVersions="*")
public class EnderCompass {
    public static final String ID = "endercompass";
    public static final String NAME = "Ender Compass";
    public static final String VERSION = "1.0";
    public static final String MINECRAFT_VERSIONS = "*";
    public static final Item ENDER_COMPASS = (Item)new ItemEnderCompass().func_77655_b("ender_compass").func_77637_a(CreativeTabs.field_78040_i).setRegistryName("ender_compass");
    public static SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel(ID);
        network.registerMessage((IMessageHandler)new CMessageGetStrongholdPos(), CMessageGetStrongholdPos.class, 0, Side.SERVER);
        network.registerMessage((IMessageHandler)new SMessageSetStrongholdPos(), SMessageSetStrongholdPos.class, 1, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ENDER_COMPASS);
    }

    public static boolean containsCompass(IInventory inventory) {
        if (EnderCompassConfig.checkInventory) {
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                ItemStack stack = inventory.func_70301_a(slot);
                if (stack.func_190926_b() || stack.func_77973_b() != ENDER_COMPASS) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Mod.EventBusSubscriber
    @Config(modid="endercompass")
    public static class EnderCompassConfig {
        @Config.LangKey(value="endercompass.configgui.checkInventory")
        @Config.Comment(value={"Set this to true if the player should have an ender compass in their inventory in order for it to work"})
        public static boolean checkInventory = false;

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals(EnderCompass.ID)) {
                ConfigManager.sync((String)EnderCompass.ID, (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

