/*
 * Decompiled with CFR 0.152.
 */
package io.github.mribby.endercompass.client;

import io.github.mribby.endercompass.client.EnderCompassClient;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderCompassAngleGetter
implements IItemPropertyGetter {
    private double prevAngle = 0.0;
    private double prevWobble = 0.0;
    private long prevWorldTime = 0L;

    @SideOnly(value=Side.CLIENT)
    public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase livingEntity) {
        double angle;
        BlockPos strongholdPos;
        EntityLivingBase entity;
        boolean isLiving;
        boolean bl = isLiving = livingEntity != null;
        if (!isLiving && !stack.func_82839_y()) {
            return 0.0f;
        }
        Object object = entity = isLiving ? livingEntity : stack.func_82836_z();
        if (world == null) {
            world = entity.field_70170_p;
        }
        if ((strongholdPos = EnderCompassClient.getStrongholdPos()) != null) {
            double entityAngle = isLiving ? (double)entity.field_70177_z : this.getFrameAngle((EntityItemFrame)entity);
            entityAngle /= 360.0;
            entityAngle = MathHelper.func_191273_b((double)entityAngle, (double)1.0);
            double posAngle = this.getPosToAngle(strongholdPos, (Entity)entity);
            angle = 0.5 - (entityAngle - 0.25 - (posAngle /= Math.PI * 2));
        } else {
            angle = Math.random();
        }
        if (isLiving) {
            angle = this.wobble(world, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private double wobble(World world, double angle) {
        long worldTime = world.func_82737_E();
        if (worldTime != this.prevWorldTime) {
            this.prevWorldTime = worldTime;
            double angleDifference = angle - this.prevAngle;
            angleDifference = MathHelper.func_191273_b((double)(angleDifference + 0.5), (double)1.0) - 0.5;
            this.prevWobble += angleDifference * 0.1;
            this.prevWobble *= 0.8;
            this.prevAngle = MathHelper.func_191273_b((double)(this.prevAngle + this.prevWobble), (double)1.0);
        }
        return this.prevAngle;
    }

    @SideOnly(value=Side.CLIENT)
    private double getFrameAngle(EntityItemFrame entity) {
        return MathHelper.func_188209_b((int)(180 + entity.field_174860_b.func_176736_b() * 90));
    }

    @SideOnly(value=Side.CLIENT)
    private double getPosToAngle(BlockPos pos, Entity entity) {
        return Math.atan2((double)pos.func_177952_p() - entity.field_70161_v, (double)pos.func_177958_n() - entity.field_70165_t);
    }
}

