/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.minecraft_enhanced_snowman;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class Configs {
    public static final Common COMMON;
    static final ForgeConfigSpec confSpec;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        LogManager.getLogger().debug("Loaded enhanced snowman config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        LogManager.getLogger().fatal("Enhanced snowman config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        confSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.DoubleValue snowballDamage;
        public final ForgeConfigSpec.BooleanValue onlyHostile;
        public final ForgeConfigSpec.BooleanValue playersDealDamage;
        public final ForgeConfigSpec.BooleanValue convert;
        public final ForgeConfigSpec.DoubleValue convert_chance;
        public final ForgeConfigSpec.BooleanValue slowness;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Snowman common settings");
            builder.push("common");
            this.snowballDamage = builder.comment("Damage dealt by one snowman snowball").defineInRange("snowballDamage", 1.0, 0.0, 100.0);
            this.onlyHostile = builder.comment("Only deal damage to hostile creatures").define("onlyHostile", true);
            this.playersDealDamage = builder.comment("Allow players to deal damage with snowballs").define("playersDealDamage", false);
            this.convert = builder.comment("Convert creatures killed by snowmen to a snowman").define("convert", false);
            this.convert_chance = builder.comment("Chance of converting killed creature to snowman if enabled").defineInRange("convert_chance", 1.0, 0.0, 1.0);
            this.slowness = builder.comment("Add a short freeze/slowness to a creature hit by a snowball").define("slowness", true);
            builder.pop();
        }
    }
}

