/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.minecraft_enhanced_snowman;

import de.maxanier.minecraft_enhanced_snowman.Configs;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;

@Mod(value="enhanced_snowman")
public class ModEnhancedSnowman {
    public static final String MOD_ID = "enhanced_snowman";
    public static ModEnhancedSnowman INSTANCE;

    public ModEnhancedSnowman() {
        INSTANCE = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configs.confSpec);
        modEventBus.register(Configs.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Optional opt = ModList.get().getModContainerById(MOD_ID);
        if (opt.isPresent()) {
            LogManager.getLogger().info("Preparing Enhanced Snowman {}", (Object)((ModContainer)opt.get()).getModInfo().getVersion());
        } else {
            LogManager.getLogger().error("Somehow Enhanced Snowman could not be found");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        if (((Boolean)Configs.COMMON.convert.get()).booleanValue() && event.getSource().func_76346_g() instanceof SnowGolemEntity && (Double)Configs.COMMON.convert_chance.get() > Math.random()) {
            SnowGolemEntity snowman = new SnowGolemEntity(EntityType.field_200745_ak, event.getEntityLiving().func_130014_f_());
            snowman.func_82149_j((Entity)event.getEntityLiving());
            event.getEntityLiving().func_130014_f_().func_217376_c((Entity)snowman);
        }
    }

    @SubscribeEvent
    public void onLivingBaseAttack(LivingAttackEvent event) {
        if (event.getAmount() == 0.0f && event.getSource().func_76364_f() instanceof SnowballEntity) {
            SnowballEntity ball;
            if (event.getEntityLiving().func_130014_f_().field_72995_K) {
                return;
            }
            if ((event.getSource().func_76346_g() instanceof SnowGolemEntity || ((Boolean)Configs.COMMON.playersDealDamage.get()).booleanValue() && event.getSource().func_76346_g() instanceof PlayerEntity) && (event.getEntityLiving() instanceof IMob || !((Boolean)Configs.COMMON.onlyHostile.get()).booleanValue()) && !(ball = (SnowballEntity)event.getSource().func_76364_f()).getPersistentData().func_74764_b("dealt_damage")) {
                ball.getPersistentData().func_74757_a("dealt_damage", true);
                event.getEntityLiving().func_70097_a((DamageSource)new IndirectEntityDamageSource("thrown", event.getSource().func_76364_f(), event.getSource().func_76346_g()), ((Double)Configs.COMMON.snowballDamage.get()).floatValue());
                if (((Boolean)Configs.COMMON.slowness.get()).booleanValue()) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 1));
                }
            }
        }
    }
}

