/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class PieBlock
extends Block {
    public static final IntegerProperty BITES = IntegerProperty.func_177719_a((String)"bites", (int)0, (int)3);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)8.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)8.0, (double)8.0, (double)4.0, (double)14.0)), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)8.0), Block.func_208617_a((double)8.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)8.0)};
    public final Supplier<Item> pieSlice;

    public PieBlock(Block.Properties properties, Supplier<Item> pieSlice) {
        super(properties);
        this.pieSlice = pieSlice;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BITES, (Comparable)Integer.valueOf(0)));
    }

    public int getBiteHunger() {
        return 3;
    }

    public float getBiteSaturation() {
        return 0.3f;
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((IItemProvider)this.pieSlice.get());
    }

    public EffectInstance getPieEffect() {
        return new EffectInstance(Effects.field_76424_c, 1800, 0);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((IProperty)BITES)];
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            if (ModTags.KNIVES.func_199685_a_((Object)itemstack.func_77973_b())) {
                return this.cutSlice(worldIn, pos, state);
            }
            if (this.consumeBite(worldIn, pos, state, player) == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            if (itemstack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        if (ModTags.KNIVES.func_199685_a_((Object)itemstack.func_77973_b())) {
            return this.cutSlice(worldIn, pos, state);
        }
        return this.consumeBite(worldIn, pos, state, player);
    }

    private ActionResultType consumeBite(World worldIn, BlockPos pos, BlockState state, PlayerEntity playerIn) {
        int i;
        if (!playerIn.func_71043_e(false)) {
            return ActionResultType.PASS;
        }
        playerIn.func_71024_bL().func_75122_a(this.getBiteHunger(), this.getBiteSaturation());
        if (this.getPieEffect() != null) {
            playerIn.func_195064_c(this.getPieEffect());
        }
        if ((i = ((Integer)state.func_177229_b((IProperty)BITES)).intValue()) < this.getMaxBites() - 1) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            worldIn.func_217377_a(pos, false);
        }
        worldIn.func_184133_a(null, pos, SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.8f, 0.8f);
        return ActionResultType.SUCCESS;
    }

    private ActionResultType cutSlice(World worldIn, BlockPos pos, BlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)BITES);
        if (i < this.getMaxBites() - 1) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            worldIn.func_217377_a(pos, false);
        }
        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.getPieSliceItem());
        worldIn.func_184133_a(null, pos, SoundEvents.field_187546_ae, SoundCategory.PLAYERS, 0.8f, 0.8f);
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BITES});
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.func_177229_b((IProperty)BITES);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public int getMaxBites() {
        return 4;
    }
}

