/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CookingPotRecipe
implements IRecipe<IInventory> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static IRecipeType<CookingPotRecipe> TYPE = IRecipeType.func_222147_a((String)"farmersdelight:cooking");
    public static final Serializer SERIALIZER = new Serializer();
    public static final int INPUT_SLOTS = 6;
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ItemStack container;
    private final float experience;
    private final int cookTime;

    public CookingPotRecipe(ResourceLocation id, String group, NonNullList<Ingredient> inputItems, ItemStack output, ItemStack container, float experience, int cookTime) {
        this.id = id;
        this.group = group;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.func_190926_b() ? container : (!output.getContainerItem().func_190926_b() ? output.getContainerItem() : ItemStack.field_190927_a);
        this.experience = experience;
        this.cookTime = cookTime;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputItems;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack getOutputContainer() {
        return this.container;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output.func_77946_l();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CookingPotRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("farmersdelight", "cooking"));
        }

        public CookingPotRecipe read(ResourceLocation recipeId, JsonObject json) {
            String groupIn = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cooking recipe");
            }
            if (inputItemsIn.size() > 6) {
                throw new JsonParseException("Too many ingredients for cooking recipe! The max is 6");
            }
            ItemStack outputIn = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            ItemStack container = JSONUtils.func_151204_g((JsonObject)json, (String)"container") ? ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"container")) : ItemStack.field_190927_a;
            float experienceIn = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
            int cookTimeIn = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)200);
            return new CookingPotRecipe(recipeId, groupIn, inputItemsIn, outputIn, container, experienceIn, cookTimeIn);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public CookingPotRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String groupIn = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList inputItemsIn = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack outputIn = buffer.func_150791_c();
            ItemStack container = buffer.func_150791_c();
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.func_150792_a();
            return new CookingPotRecipe(recipeId, groupIn, (NonNullList<Ingredient>)inputItemsIn, outputIn, container, experienceIn, cookTimeIn);
        }

        public void write(PacketBuffer buffer, CookingPotRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
            buffer.func_150788_a(recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.func_150787_b(recipe.cookTime);
        }
    }
}

