/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.items.MealItem;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.registry.ModParticleTypes;
import vectorwing.farmersdelight.utils.MathUtils;
import vectorwing.farmersdelight.utils.TextUtils;

public class DogFoodItem
extends MealItem {
    public static final List<EffectInstance> EFFECTS = Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76424_c, 6000, 0), new EffectInstance(Effects.field_76420_g, 6000, 0), new EffectInstance(Effects.field_76429_m, 6000, 0)});

    public DogFoodItem(Item.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ITextComponent whenFeeding = TextUtils.getTranslation("tooltip.dog_food.when_feeding", new Object[0]);
        tooltip.add(whenFeeding.func_211708_a(TextFormatting.GRAY));
        ArrayList list1 = Lists.newArrayList();
        for (EffectInstance effectinstance : EFFECTS) {
            StringTextComponent effectDescription = new StringTextComponent(" ");
            TranslationTextComponent effectName = new TranslationTextComponent(effectinstance.func_76453_d(), new Object[0]);
            effectDescription.func_150257_a((ITextComponent)effectName);
            Effect effect = effectinstance.func_188419_a();
            Map map = effect.func_111186_k();
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                    list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                }
            }
            if (effectinstance.func_76458_c() > 0) {
                effectDescription.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c(), new Object[0]));
            }
            if (effectinstance.func_76459_b() > 20) {
                effectDescription.func_150258_a(" (").func_150258_a(EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)1.0f)).func_150258_a(")");
            }
            tooltip.add(effectDescription.func_211708_a(effect.func_220303_e().func_220306_a()));
        }
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (target instanceof WolfEntity) {
            WolfEntity wolf = (WolfEntity)target;
            return wolf.func_70089_S() && wolf.func_70909_n();
        }
        return false;
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class DogFoodEvent {
        @SubscribeEvent
        public static void onDogFoodApplied(PlayerInteractEvent.EntityInteract event) {
            WolfEntity wolf;
            PlayerEntity player = event.getPlayer();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof WolfEntity && (wolf = (WolfEntity)target).func_70089_S() && wolf.func_70909_n() && itemStack.func_77973_b().equals(ModItems.DOG_FOOD.get())) {
                wolf.func_70606_j(wolf.func_110138_aP());
                for (EffectInstance effect : EFFECTS) {
                    wolf.func_195064_c(new EffectInstance(effect));
                }
                wolf.field_70170_p.func_184133_a(null, target.func_180425_c(), SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.8f, 0.8f);
                for (int i = 0; i < 5; ++i) {
                    double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                    wolf.field_70170_p.func_195594_a((IParticleData)ModParticleTypes.STAR_PARTICLE.get(), wolf.func_226282_d_(1.0), wolf.func_226279_cv_() + 0.5, wolf.func_226287_g_(1.0), d0, d1, d2);
                }
                if (itemStack.getContainerItem() != ItemStack.field_190927_a && !player.func_184812_l_()) {
                    player.func_191521_c(itemStack.getContainerItem());
                    itemStack.func_190918_g(1);
                }
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

