/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.blockproperties.Props;
import com.draco18s.hardlib.util.RecipesUtils;
import com.draco18s.ores.OresBase;
import com.draco18s.ores.block.ore.BlockHardOreBase;
import com.draco18s.ores.networking.Packets;
import com.draco18s.ores.networking.ToClientMessageOreParticles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public class OreEventHandler {
    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        boolean stoneTools;
        IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)event.getRegistry();
        boolean hardOption = OresBase.config.getBoolean("RequireMillingFlour", "MILLING", false, "");
        if (hardOption) {
            RecipesUtils.RemoveRecipe((IForgeRegistryModifiable)modRegistry, (ResourceLocation)new ResourceLocation("minecraft:bread"), (String)"Hard Ores");
            RecipesUtils.RemoveRecipe((IForgeRegistryModifiable)modRegistry, (ResourceLocation)new ResourceLocation("minecraft:cookie"), (String)"Hard Ores");
            RecipesUtils.RemoveRecipe((IForgeRegistryModifiable)modRegistry, (ResourceLocation)new ResourceLocation("minecraft:cake"), (String)"Hard Ores");
        }
        if (stoneTools = OresBase.config.getBoolean("useDioriteStoneTools", "GENERAL", true, "If true, cobblestone cannot be used to create stone tools,\ninstead diorite is used. This prolongs the life of wood tools so it isn't \"make a wood pickaxe to\nmine 3 stone and upgrade.\"")) {
            RecipesUtils.RemoveRecipe((IForgeRegistryModifiable)modRegistry, (ResourceLocation)new ResourceLocation("minecraft:stone_axe"), (String)"Harder Ores");
            RecipesUtils.RemoveRecipe((IForgeRegistryModifiable)modRegistry, (ResourceLocation)new ResourceLocation("minecraft:stone_pickaxe"), (String)"Harder Ores");
            RecipesUtils.RemoveRecipe((IForgeRegistryModifiable)modRegistry, (ResourceLocation)new ResourceLocation("minecraft:stone_shovel"), (String)"Harder Ores");
            RecipesUtils.RemoveRecipe((IForgeRegistryModifiable)modRegistry, (ResourceLocation)new ResourceLocation("minecraft:stone_hoe"), (String)"Harder Ores");
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer() != null) {
            int level;
            EntityPlayer harvester = event.getEntityPlayer();
            IBlockState state = event.getState();
            BlockPos pos = event.getPos();
            if (state.func_177228_b().containsKey((Object)Props.ORE_DENSITY) && (level = EnchantmentHelper.func_77506_a((Enchantment)OresBase.enchShatter, (ItemStack)harvester.func_184614_ca())) > 0) {
                event.setNewSpeed(event.getNewSpeed() / 2.0f);
            }
        }
    }

    @SubscribeEvent
    public void harvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null) {
            int level;
            EntityPlayer harvester = event.getHarvester();
            IBlockState state = event.getState();
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            if (state.func_177228_b().containsKey((Object)Props.ORE_DENSITY) && (level = EnchantmentHelper.func_77506_a((Enchantment)OresBase.enchShatter, (ItemStack)harvester.func_184614_ca())) > 0) {
                float rollover = 0.0f;
                ++level;
                while (level > 0) {
                    int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)harvester.func_184614_ca());
                    List drps = HardLibAPI.hardOres.mineHardOreOnce(world, pos, fortune);
                    if (drps != null) {
                        if ((rollover += 0.75f) >= 0.75f) {
                            harvester.func_184614_ca().func_77972_a(1, (EntityLivingBase)harvester);
                            rollover -= 1.0f;
                        }
                        event.getDrops().addAll(drps);
                    }
                    --level;
                }
            }
            if (state.func_177228_b().containsKey((Object)Props.ORE_DENSITY)) {
                int max;
                level = EnchantmentHelper.func_77506_a((Enchantment)OresBase.enchCracker, (ItemStack)harvester.func_184614_ca());
                float rollover = 0.0f;
                level *= 2;
                for (max = 0; max < 12 && level > 0; ++max) {
                    EnumFacing dir = EnumFacing.field_82609_l[world.field_73012_v.nextInt(6)];
                    if (state.func_177230_c() != world.func_180495_p(pos.func_177967_a(dir, 1)).func_177230_c()) continue;
                    --level;
                    List drps = HardLibAPI.hardOres.mineHardOreOnce(world, pos.func_177967_a(dir, 1), 0);
                    if (drps == null) continue;
                    if ((rollover += 0.75f) >= 0.75f) {
                        harvester.func_184614_ca().func_77972_a(1, (EntityLivingBase)harvester);
                        rollover -= 1.0f;
                    }
                    event.getDrops().addAll(drps);
                }
                level = EnchantmentHelper.func_77506_a((Enchantment)OresBase.enchPulverize, (ItemStack)harvester.func_184614_ca());
                if (level > 0 && (Integer)state.func_177229_b((IProperty)Props.ORE_DENSITY) <= level * 2 + 3) {
                    Iterator it = event.getDrops().iterator();
                    ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
                    max = 2 + level;
                    while (it.hasNext()) {
                        ItemStack stk = (ItemStack)it.next();
                        ItemStack out = HardLibAPI.oreMachines.getMillResult(stk);
                        if (out.func_190926_b()) continue;
                        ItemStack dustStack = out.func_77946_l();
                        int n = dustStack.func_190916_E();
                        dustStack.func_190920_e(0);
                        for (int s = Math.min(stk.func_190916_E(), max); s > 0; --s) {
                            dustStack.func_190917_f(n);
                            --max;
                            stk.func_190918_g(1);
                        }
                        newItems.add(dustStack);
                        if (stk.func_190916_E() != 0) continue;
                        it.remove();
                    }
                    event.getDrops().addAll(newItems);
                }
            }
            if (state.func_185904_a() == Material.field_151576_e) {
                level = EnchantmentHelper.func_77506_a((Enchantment)OresBase.enchProspector, (ItemStack)harvester.func_184592_cb());
                if (harvester.func_184614_ca() != null && harvester.func_184614_ca().func_77973_b() != Items.field_151111_aL) {
                    level = Math.max(level, EnchantmentHelper.func_77506_a((Enchantment)OresBase.enchProspector, (ItemStack)harvester.func_184614_ca()));
                }
                if (level > 0) {
                    int llevel = level * 2 + 1;
                    boolean anyOre = state.func_177228_b().containsKey((Object)Props.ORE_DENSITY);
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        if (!world.func_180495_p(pos).func_177228_b().containsKey((Object)Props.ORE_DENSITY)) continue;
                        anyOre = true;
                    }
                    if (!anyOre) {
                        Iterable cube = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-llevel, -llevel, -llevel), (BlockPos)pos.func_177982_a(llevel, llevel, llevel));
                        for (BlockPos p : cube) {
                            IBlockState st = world.func_180495_p(p);
                            if (!HardLibAPI.hardOres.isHardOre(st)) continue;
                            ToClientMessageOreParticles packet = new ToClientMessageOreParticles(Packets.PROSPECTING, pos, p);
                            OresBase.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)event.getHarvester());
                            if (level < 3 || world.field_73012_v.nextInt(20) > level - 3) continue;
                            List list = HardLibAPI.hardOres.getHardOreDropsOnce(world, p, 0);
                            ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
                            for (ItemStack s : list) {
                                ItemStack milled = HardLibAPI.oreMachines.getMillResult(s);
                                if (milled == null) continue;
                                toDrop.add(milled.func_77946_l());
                            }
                            for (ItemStack s : toDrop) {
                                s.func_190920_e(1);
                                float rx = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
                                float ry = world.field_73012_v.nextFloat() * 0.2f + 0.6f - 1.0f;
                                float rz = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
                                EntityItem ent = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), s);
                                world.func_72838_d((Entity)ent);
                                ent.field_70159_w = 0.0;
                                ent.field_70181_x = -0.2f;
                                ent.field_70179_y = 0.0;
                            }
                        }
                    }
                }
            }
        }
    }

    private void dropStack(World worldIn, BlockPos pos, ItemStack stack) {
        float f = 0.7f;
        double d0 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        for (EnumFacing dir : BlockHardOreBase.DROP_SEARCH_DIRECTIONS) {
            if (worldIn.func_180495_p(pos.func_177972_a(dir)).func_185915_l() && dir != EnumFacing.DOWN) continue;
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0 + (double)dir.func_82601_c(), (double)pos.func_177956_o() + d1 + (double)dir.func_96559_d(), (double)pos.func_177952_p() + d2 + (double)dir.func_82599_e(), stack);
            entityitem.func_174869_p();
            worldIn.func_72838_d((Entity)entityitem);
            return;
        }
    }
}

