/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores;

import com.draco18s.hardlib.CogHelper;
import com.draco18s.hardlib.EasyRegistry;
import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.blockproperties.ores.EnumOreType;
import com.draco18s.hardlib.api.capability.CapabilityMechanicalPower;
import com.draco18s.hardlib.api.internal.IMetaLookup;
import com.draco18s.hardlib.util.AdvancementUtils;
import com.draco18s.hardlib.util.RecipesUtils;
import com.draco18s.ores.CommonProxy;
import com.draco18s.ores.OreGuiHandler;
import com.draco18s.ores.block.BlockAxel;
import com.draco18s.ores.block.BlockDummyOre;
import com.draco18s.ores.block.BlockMillstone;
import com.draco18s.ores.block.BlockPackager;
import com.draco18s.ores.block.BlockSifter;
import com.draco18s.ores.block.BlockSluice;
import com.draco18s.ores.block.BlockWindvane;
import com.draco18s.ores.block.ore.BlockHardDiamond;
import com.draco18s.ores.block.ore.BlockHardOreBase;
import com.draco18s.ores.block.ore.BlockLimonite;
import com.draco18s.ores.enchantments.EnchantmentProspector;
import com.draco18s.ores.enchantments.EnchantmentPulverize;
import com.draco18s.ores.enchantments.EnchantmentShatter;
import com.draco18s.ores.enchantments.EnchantmentVeinCracker;
import com.draco18s.ores.entities.EntityOreMinecart;
import com.draco18s.ores.entities.TileEntityAxel;
import com.draco18s.ores.entities.TileEntityBasicSluice;
import com.draco18s.ores.entities.TileEntityMillstone;
import com.draco18s.ores.entities.TileEntityPackager;
import com.draco18s.ores.entities.TileEntitySifter;
import com.draco18s.ores.integration.FlowerIntegration;
import com.draco18s.ores.item.ItemDiamondStudAxe;
import com.draco18s.ores.item.ItemDiamondStudHoe;
import com.draco18s.ores.item.ItemDiamondStudPickaxe;
import com.draco18s.ores.item.ItemDiamondStudShovel;
import com.draco18s.ores.item.ItemDustLarge;
import com.draco18s.ores.item.ItemDustSmall;
import com.draco18s.ores.item.ItemEntityOreCart;
import com.draco18s.ores.item.ItemOreBlock;
import com.draco18s.ores.item.ItemRawOre;
import com.draco18s.ores.networking.ClientOreParticleHandler;
import com.draco18s.ores.networking.ServerOreCartHandler;
import com.draco18s.ores.networking.ToClientMessageOreParticles;
import com.draco18s.ores.networking.ToServerMessageOreCart;
import com.draco18s.ores.recipes.OreProcessingRecipes;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="harderores", name="HarderOres", version="7.0.0a", dependencies="required-after:hardlib@[7,];required-after:oreflowers", acceptedMinecraftVersions="[1.12.1]")
public class OresBase {
    @Mod.Instance(value="harderores")
    public static OresBase instance;
    @SidedProxy(clientSide="com.draco18s.ores.client.ClientProxy", serverSide="com.draco18s.ores.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static Block oreLimonite;
    public static Block oreIron;
    public static Block oreGold;
    public static Block oreDiamond;
    public static Block oreTin;
    public static Block oreCopper;
    public static Block oreLead;
    public static Block oreUranium;
    public static Block oreSilver;
    public static Block oreNickel;
    public static Block oreAluminum;
    public static Block orePlatinum;
    public static Block oreZinc;
    public static Block oreOsmium;
    public static Block oreQuartz;
    public static Block dummyOreIron;
    public static Block dummyOreGold;
    public static Block dummyOreDiamond;
    public static Block dummyOreTin;
    public static Block dummyOreCopper;
    public static Block dummyOreLead;
    public static Block dummyOreUranium;
    public static Block dummyOreSilver;
    public static Block dummyOreNickel;
    public static Block dummyOreAluminum;
    public static Block dummyOrePlatinum;
    public static Block dummyOreZinc;
    public static Block dummyOreOsmium;
    public static Block dummyOreQuartz;
    public static Block millstone;
    public static Block axel;
    public static Block windvane;
    public static Block sifter;
    public static Block sluice;
    public static Block pressurePackager;
    public static Item rawOre;
    public static Item smallDust;
    public static Item largeDust;
    public static Item diaStudPick;
    public static Item diaStudShovel;
    public static Item diaStudHoe;
    public static Item diaStudAxe;
    public static Item oreMinecart;
    public static Enchantment enchPulverize;
    public static Enchantment enchCracker;
    public static Enchantment enchShatter;
    public static Enchantment enchProspector;
    public static Item.ToolMaterial toolMaterialDiamondStud;
    public static EntityMinecart.Type oreCartEnum;
    public static SimpleNetworkWrapper networkWrapper;
    public static Configuration config;
    public static boolean sluiceAllowDirt;
    public static boolean useSounds;
    private boolean stoneTools;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        CogHelper.addCogModule((String)"HarderVanillaOres.xml");
        CogHelper.addCogModule((String)"HarderExtraOres.xml");
        CogHelper.addCogModule((String)"HarderLimonite.xml");
        CapabilityMechanicalPower.register();
        HardLibAPI.oreMachines = new OreProcessingRecipes();
        oreIron = new BlockHardOreBase(EnumOreType.IRON, 1, new Color(14200723));
        oreIron.func_149711_c(6.0f).setHarvestLevel("pickaxe", 1);
        EasyRegistry.registerBlockWithCustomItem((Block)oreIron, (ItemBlock)new ItemOreBlock(oreIron), (String)"ore_hardiron");
        oreGold = new BlockHardOreBase(EnumOreType.GOLD, 1, new Color(16437051));
        oreGold.func_149711_c(9.0f).setHarvestLevel("pickaxe", 2);
        EasyRegistry.registerBlockWithCustomItem((Block)oreGold, (ItemBlock)new ItemOreBlock(oreGold), (String)"ore_hardgold");
        oreDiamond = new BlockHardDiamond();
        EasyRegistry.registerBlockWithCustomItem((Block)oreDiamond, (ItemBlock)new ItemOreBlock(oreDiamond), (String)"ore_harddiamond");
        oreLimonite = new BlockLimonite();
        EasyRegistry.registerBlockWithItem((Block)oreLimonite, (String)"ore_limonite");
        dummyOreIron = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreIron, (String)"dummy_ore_iron");
        dummyOreGold = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreGold, (String)"dummy_ore_gold");
        dummyOreDiamond = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreDiamond, (String)"dummy_ore_diamond");
        oreTin = new BlockHardOreBase(EnumOreType.TIN, 1, new Color(0xDBDBBD));
        oreTin.func_149711_c(6.0f).setHarvestLevel("pickaxe", 1);
        EasyRegistry.registerBlockWithCustomItem((Block)oreTin, (ItemBlock)new ItemOreBlock(oreTin), (String)"ore_hardtin");
        dummyOreTin = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreTin, (String)"dummy_ore_tin");
        oreCopper = new BlockHardOreBase(EnumOreType.COPPER, 1, new Color(10705961));
        oreCopper.func_149711_c(6.0f).setHarvestLevel("pickaxe", 1);
        EasyRegistry.registerBlockWithCustomItem((Block)oreCopper, (ItemBlock)new ItemOreBlock(oreCopper), (String)"ore_hardcopper");
        dummyOreCopper = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreCopper, (String)"dummy_ore_copper");
        oreLead = new BlockHardOreBase(EnumOreType.LEAD, 1, new Color(12179161));
        oreLead.func_149711_c(6.0f).setHarvestLevel("pickaxe", 2);
        EasyRegistry.registerBlockWithCustomItem((Block)oreLead, (ItemBlock)new ItemOreBlock(oreLead), (String)"ore_hardlead");
        dummyOreLead = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreLead, (String)"dummy_ore_lead");
        oreUranium = new BlockHardOreBase(EnumOreType.URANIUM, 1, new Color(7656723));
        oreUranium.func_149711_c(6.0f).setHarvestLevel("pickaxe", 2);
        EasyRegistry.registerBlockWithCustomItem((Block)oreUranium, (ItemBlock)new ItemOreBlock(oreUranium), (String)"ore_harduranium");
        dummyOreUranium = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreUranium, (String)"dummy_ore_uranium");
        oreSilver = new BlockHardOreBase(EnumOreType.SILVER, 1, new Color(11324913));
        oreSilver.func_149711_c(4.0f).setHarvestLevel("pickaxe", 2);
        EasyRegistry.registerBlockWithCustomItem((Block)oreSilver, (ItemBlock)new ItemOreBlock(oreSilver), (String)"ore_hardsilver");
        dummyOreSilver = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreSilver, (String)"dummy_ore_silver");
        oreNickel = new BlockHardOreBase(EnumOreType.NICKEL, 1, new Color(15131830));
        oreNickel.func_149711_c(4.0f).setHarvestLevel("pickaxe", 2);
        EasyRegistry.registerBlockWithCustomItem((Block)oreNickel, (ItemBlock)new ItemOreBlock(oreNickel), (String)"ore_hardnickel");
        dummyOreNickel = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreNickel, (String)"dummy_ore_nickel");
        oreAluminum = new BlockHardOreBase(EnumOreType.ALUMINUM, 1, new Color(5390386));
        oreAluminum.func_149711_c(3.0f).setHarvestLevel("shovel", 1);
        EasyRegistry.registerBlockWithCustomItem((Block)oreAluminum, (ItemBlock)new ItemOreBlock(oreAluminum), (String)"ore_hardbauxite");
        dummyOreAluminum = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreAluminum, (String)"dummy_ore_bauxite");
        orePlatinum = new BlockHardOreBase(EnumOreType.PLATINUM, 1, new Color(969456));
        orePlatinum.func_149711_c(5.0f).setHarvestLevel("pickaxe", 2);
        EasyRegistry.registerBlockWithCustomItem((Block)orePlatinum, (ItemBlock)new ItemOreBlock(orePlatinum), (String)"ore_hardplatinum");
        dummyOrePlatinum = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOrePlatinum, (String)"dummy_ore_platinum");
        oreZinc = new BlockHardOreBase(EnumOreType.ZINC, 1, new Color(0xC3C3C3));
        oreZinc.func_149711_c(5.0f).setHarvestLevel("pickaxe", 1);
        EasyRegistry.registerBlockWithCustomItem((Block)oreZinc, (ItemBlock)new ItemOreBlock(oreZinc), (String)"ore_hardzinc");
        dummyOreZinc = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreZinc, (String)"dummy_ore_zinc");
        oreQuartz = new BlockHardOreBase(EnumOreType.QUARTZ, 1, new Color(14084338));
        oreQuartz.func_149711_c(2.0f).setHarvestLevel("pickaxe", 1);
        EasyRegistry.registerBlockWithCustomItem((Block)oreQuartz, (ItemBlock)new ItemOreBlock(oreQuartz), (String)"ore_hardquartz");
        dummyOreQuartz = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreQuartz, (String)"dummy_ore_quartz");
        oreOsmium = new BlockHardOreBase(EnumOreType.OSMIUM, 1, new Color(4615880));
        oreOsmium.func_149711_c(6.0f).setHarvestLevel("pickaxe", 1);
        EasyRegistry.registerBlockWithCustomItem((Block)oreOsmium, (ItemBlock)new ItemOreBlock(oreOsmium), (String)"ore_hardosmium");
        dummyOreOsmium = new BlockDummyOre();
        EasyRegistry.registerBlockWithItem((Block)dummyOreOsmium, (String)"dummy_ore_osmium");
        millstone = new BlockMillstone();
        EasyRegistry.registerBlockWithItem((Block)millstone, (String)"millstone");
        GameRegistry.registerTileEntity(TileEntityMillstone.class, (String)"harderores:millstone");
        axel = new BlockAxel();
        EasyRegistry.registerBlockWithItem((Block)axel, (String)"axel");
        GameRegistry.registerTileEntity(TileEntityAxel.class, (String)"harderores:axel");
        windvane = new BlockWindvane();
        EasyRegistry.registerBlockWithItem((Block)windvane, (String)"windvane");
        sifter = new BlockSifter();
        EasyRegistry.registerBlockWithItem((Block)sifter, (String)"sifter");
        GameRegistry.registerTileEntity(TileEntitySifter.class, (String)"harderores:sifter");
        sluice = new BlockSluice();
        EasyRegistry.registerBlockWithItem((Block)sluice, (String)"basic_sluice");
        GameRegistry.registerTileEntity(TileEntityBasicSluice.class, (String)"harderores:basic_sluice");
        pressurePackager = new BlockPackager();
        EasyRegistry.registerBlockWithItem((Block)pressurePackager, (String)"packager");
        GameRegistry.registerTileEntity(TileEntityPackager.class, (String)"harderores:packager");
        rawOre = new ItemRawOre();
        EasyRegistry.registerItemWithVariants((Item)rawOre, (String)"orechunks", (IMetaLookup)EnumOreType.IRON);
        smallDust = new ItemDustSmall();
        EasyRegistry.registerItemWithVariants((Item)smallDust, (String)"tinydust", (IMetaLookup)EnumOreType.IRON);
        largeDust = new ItemDustLarge();
        EasyRegistry.registerItemWithVariants((Item)largeDust, (String)"largedust", (IMetaLookup)EnumOreType.IRON);
        toolMaterialDiamondStud = EnumHelper.addToolMaterial((String)"DIAMOND_STUD", (int)3, (int)750, (float)7.0f, (float)2.0f, (int)5);
        toolMaterialDiamondStud.setRepairItem(new ItemStack(rawOre, 1, EnumOreType.DIAMOND.meta));
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("harderores:oreMinecart"), EntityOreMinecart.class, (String)"harderores:oreMinecart", (int)0, (Object)this, (int)80, (int)3, (boolean)true);
        diaStudPick = new ItemDiamondStudPickaxe(toolMaterialDiamondStud);
        EasyRegistry.registerItem((Item)diaStudPick, (String)"diamondstud_pickaxe");
        diaStudShovel = new ItemDiamondStudShovel(toolMaterialDiamondStud);
        EasyRegistry.registerItem((Item)diaStudShovel, (String)"diamondstud_shovel");
        diaStudHoe = new ItemDiamondStudHoe(toolMaterialDiamondStud);
        EasyRegistry.registerItem((Item)diaStudHoe, (String)"diamondstud_hoe");
        diaStudAxe = new ItemDiamondStudAxe(toolMaterialDiamondStud);
        EasyRegistry.registerItem((Item)diaStudAxe, (String)"diamondstud_axe");
        oreMinecart = new ItemEntityOreCart(oreCartEnum);
        EasyRegistry.registerItem((Item)oreMinecart, (String)"orecart");
        EntityEquipmentSlot[] slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND};
        enchPulverize = new EnchantmentPulverize(slots);
        enchPulverize.setRegistryName("pulverize");
        enchPulverize.func_77322_b(enchPulverize.getRegistryName().toString());
        EasyRegistry.registerOther((IForgeRegistryEntry)enchPulverize);
        enchCracker = new EnchantmentVeinCracker(slots);
        enchCracker.setRegistryName("cracker");
        enchCracker.func_77322_b(enchCracker.getRegistryName().toString());
        EasyRegistry.registerOther((IForgeRegistryEntry)enchCracker);
        enchShatter = new EnchantmentShatter(slots);
        enchShatter.setRegistryName("shatter");
        enchShatter.func_77322_b(enchShatter.getRegistryName().toString());
        EasyRegistry.registerOther((IForgeRegistryEntry)enchShatter);
        slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.OFFHAND};
        enchProspector = new EnchantmentProspector(slots);
        enchProspector.setRegistryName("prospector");
        enchProspector.func_77322_b(enchProspector.getRegistryName().toString());
        EasyRegistry.registerOther((IForgeRegistryEntry)enchProspector);
        proxy.registerEventHandlers();
        proxy.registerRenderers();
        int serverMessageID = 1;
        int clientMessageID = 2;
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("harderores");
        networkWrapper.registerMessage(ServerOreCartHandler.class, ToServerMessageOreCart.class, serverMessageID, Side.SERVER);
        networkWrapper.registerMessage(ClientOreParticleHandler.class, ToClientMessageOreParticles.class, clientMessageID, Side.CLIENT);
        FlowerIntegration.registerFlowerGen();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"rawOreChunkLimonite", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.LIMONITE.meta));
        OreDictionary.registerOre((String)"rawOreChunkIron", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.IRON.meta));
        OreDictionary.registerOre((String)"rawOreChunkGold", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.GOLD.meta));
        OreDictionary.registerOre((String)"rawOreChunkDiamond", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.DIAMOND.meta));
        OreDictionary.registerOre((String)"rawOreChunkTin", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.TIN.meta));
        OreDictionary.registerOre((String)"rawOreChunkCopper", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.COPPER.meta));
        OreDictionary.registerOre((String)"rawOreChunkLead", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.LEAD.meta));
        OreDictionary.registerOre((String)"rawOreChunkUranium", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.URANIUM.meta));
        OreDictionary.registerOre((String)"rawOreChunkSilver", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.SILVER.meta));
        OreDictionary.registerOre((String)"rawOreChunkNickel", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.NICKEL.meta));
        OreDictionary.registerOre((String)"rawOreChunkAluminum", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.ALUMINUM.meta));
        OreDictionary.registerOre((String)"rawOreChunkPlatinum", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.PLATINUM.meta));
        OreDictionary.registerOre((String)"rawOreChunkZinc", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.ZINC.meta));
        OreDictionary.registerOre((String)"rawOreChunkOsmium", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.OSMIUM.meta));
        OreDictionary.registerOre((String)"gemBlueQuartz", (ItemStack)new ItemStack(rawOre, 1, EnumOreType.QUARTZ.meta));
        OreDictionary.registerOre((String)"dustTinyIron", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.IRON.meta));
        OreDictionary.registerOre((String)"dustTinyGold", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.GOLD.meta));
        OreDictionary.registerOre((String)"dustTinyFlour", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.FLOUR.meta));
        OreDictionary.registerOre((String)"dustTinySugar", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.SUGAR.meta));
        OreDictionary.registerOre((String)"dustTinyTin", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.TIN.meta));
        OreDictionary.registerOre((String)"dustTinyCopper", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.COPPER.meta));
        OreDictionary.registerOre((String)"dustTinyLead", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.LEAD.meta));
        OreDictionary.registerOre((String)"dustTinySilver", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.SILVER.meta));
        OreDictionary.registerOre((String)"dustTinyNickel", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.NICKEL.meta));
        OreDictionary.registerOre((String)"dustTinyAluminum", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.ALUMINUM.meta));
        OreDictionary.registerOre((String)"dustTinyPlatinum", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.PLATINUM.meta));
        OreDictionary.registerOre((String)"dustTinyZinc", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.ZINC.meta));
        OreDictionary.registerOre((String)"dustTinyOsmium", (ItemStack)new ItemStack(smallDust, 1, EnumOreType.OSMIUM.meta));
        OreDictionary.registerOre((String)"dustIron", (ItemStack)new ItemStack(largeDust, 1, EnumOreType.IRON.meta));
        OreDictionary.registerOre((String)"dustGold", (ItemStack)new ItemStack(largeDust, 1, EnumOreType.GOLD.meta));
        OreDictionary.registerOre((String)"dustFlour", (ItemStack)new ItemStack(largeDust, 1, EnumOreType.FLOUR.meta));
        OreDictionary.registerOre((String)"oreIronHard", (Block)oreIron);
        OreDictionary.registerOre((String)"oreGoldHard", (Block)oreGold);
        OreDictionary.registerOre((String)"oreDiamondHard", (Block)oreDiamond);
        OreDictionary.registerOre((String)"oreIron", (Block)dummyOreIron);
        OreDictionary.registerOre((String)"oreGold", (Block)dummyOreGold);
        OreDictionary.registerOre((String)"oreDiamond", (Block)dummyOreDiamond);
        GameRegistry.addSmelting((ItemStack)new ItemStack(rawOre, 1, EnumOreType.LIMONITE.meta), (ItemStack)new ItemStack(rawOre, 1, EnumOreType.IRON.meta), (float)0.05f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(rawOre, 1, EnumOreType.IRON.meta), (ItemStack)new ItemStack(Items.field_191525_da), (float)0.08f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(rawOre, 1, EnumOreType.GOLD.meta), (ItemStack)new ItemStack(Items.field_151074_bl, 1), (float)0.11f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(rawOre, 1, EnumOreType.QUARTZ.meta), (ItemStack)new ItemStack(Blocks.field_150410_aZ, 1), (float)0.11f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(smallDust, 1, EnumOreType.IRON.meta), (ItemStack)new ItemStack(Items.field_191525_da), (float)0.08f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(smallDust, 1, EnumOreType.GOLD.meta), (ItemStack)new ItemStack(Items.field_151074_bl, 1), (float)0.11f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(largeDust, 1, EnumOreType.IRON.meta), (ItemStack)new ItemStack(Items.field_151042_j, 1), (float)0.7f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(largeDust, 1, EnumOreType.GOLD.meta), (ItemStack)new ItemStack(Items.field_151043_k, 1), (float)1.0f);
        GameRegistry.addSmelting((Block)dummyOreIron, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.7f);
        GameRegistry.addSmelting((Block)dummyOreGold, (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((Block)dummyOreDiamond, (ItemStack)new ItemStack(Items.field_151045_i), (float)1.0f);
        GameRegistry.addSmelting((Block)dummyOreQuartz, (ItemStack)new ItemStack(Blocks.field_150359_w, 3), (float)1.0f);
        useSounds = config.getBoolean("Use Sounds", "GENERAL", true, "If true, then the millstone will make noise.");
        sluiceAllowDirt = config.getBoolean("sluiceAllowsDirt", "SLUICE", false, "Set to true to allow dirt to be used in the sluice.");
        int cycle = config.getInt("sluiceCycleTime", "SLUICE", 2, 1, 20, "Time it takes for the sluice to make 1 operation.  This value is multiplied by 75 ticks.");
        TileEntityBasicSluice.cycleLength = cycle * 15;
        if (config.get("SLUICE", "canFindIron", true).getBoolean()) {
            HardLibAPI.oreMachines.addSluiceRecipe(oreIron);
            HardLibAPI.oreMachines.addSluiceRecipe(oreIron);
            HardLibAPI.oreMachines.addSluiceRecipe(oreIron);
        }
        if (config.get("SLUICE", "canFindGold", true).getBoolean()) {
            HardLibAPI.oreMachines.addSluiceRecipe(oreGold);
            HardLibAPI.oreMachines.addSluiceRecipe(oreGold);
            HardLibAPI.oreMachines.addSluiceRecipe(oreGold);
        }
        if (config.get("SLUICE", "canFindDiamond", false).getBoolean()) {
            HardLibAPI.oreMachines.addSluiceRecipe(oreDiamond);
        }
        if (config.get("SLUICE", "canFindRedstone", true).getBoolean()) {
            HardLibAPI.oreMachines.addSluiceRecipe(Blocks.field_150450_ax);
            HardLibAPI.oreMachines.addSluiceRecipe(Blocks.field_150450_ax);
        }
        HardLibAPI.oreMachines.addMillRecipe(new ItemStack(rawOre, 1, EnumOreType.IRON.meta), new ItemStack(smallDust, 2, EnumOreType.IRON.meta));
        HardLibAPI.oreMachines.addMillRecipe(new ItemStack(rawOre, 1, EnumOreType.GOLD.meta), new ItemStack(smallDust, 2, EnumOreType.GOLD.meta));
        config.addCustomCategoryComment("MILLING", "Enable (hard mode) these to remove vanilla recipes for items and instead require the millstone. In general,\neasy means the millstone doubles resources, while hard is near-vanilla.");
        boolean hardOption = config.getBoolean("RequireMillingFlour", "MILLING", false, "");
        String oreIn = "dustFlour";
        if (hardOption) {
            HardLibAPI.oreMachines.addMillRecipe(new ItemStack(Items.field_151015_O), new ItemStack(smallDust, 4, EnumOreType.FLOUR.meta));
            HardLibAPI.oreMachines.addMillRecipe(new ItemStack(Items.field_151014_N), new ItemStack(smallDust, 1, EnumOreType.FLOUR.meta));
        } else {
            HardLibAPI.oreMachines.addMillRecipe(new ItemStack(Items.field_151015_O), new ItemStack(smallDust, 18, EnumOreType.FLOUR.meta));
            HardLibAPI.oreMachines.addMillRecipe(new ItemStack(Items.field_151014_N), new ItemStack(smallDust, 2, EnumOreType.FLOUR.meta));
        }
        hardOption = config.getBoolean("RequireMillingSugar", "MILLING", false, "If enabled, sugarcane cannot be crafted into sugar");
        int sugarMulti = config.getInt("MillingMultiplierSugar", "MILLING", 6, 1, 12, "Sugar is a easy-to-get resource and rare-to-use, so it may be desirable to reduce the production.\nOutput of milling sugar (in tiny piles) is this value in hard-milling and 2x this value in\neasy-milling.\nVanilla Equivalence is 9.");
        if (hardOption) {
            HardLibAPI.oreMachines.addMillRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(smallDust, sugarMulti, EnumOreType.SUGAR.meta));
        } else {
            HardLibAPI.oreMachines.addMillRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(smallDust, 2 * sugarMulti, EnumOreType.SUGAR.meta));
        }
        hardOption = config.getBoolean("RequireMillingBonemeal", "MILLING", false, "");
        if (hardOption) {
            RecipesUtils.RemoveRecipe((Item)Items.field_151100_aR, (int)3, (int)EnumDyeColor.WHITE.func_176767_b(), (String)"Hard Ores");
            HardLibAPI.oreMachines.addMillRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.WHITE.func_176767_b()));
        } else {
            HardLibAPI.oreMachines.addMillRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.WHITE.func_176767_b()));
        }
        ItemStack bonemeal = new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b());
        HardLibAPI.oreMachines.addSiftRecipe(bonemeal, bonemeal, false);
        HardLibAPI.oreMachines.addSiftRecipe(new ItemStack(smallDust, 8, EnumOreType.IRON.meta), new ItemStack(largeDust, 1, EnumOreType.IRON.meta));
        HardLibAPI.oreMachines.addSiftRecipe(new ItemStack(smallDust, 8, EnumOreType.GOLD.meta), new ItemStack(largeDust, 1, EnumOreType.GOLD.meta));
        HardLibAPI.oreMachines.addSiftRecipe(new ItemStack(smallDust, 8, EnumOreType.FLOUR.meta), new ItemStack(largeDust, 1, EnumOreType.FLOUR.meta));
        HardLibAPI.oreMachines.addSiftRecipe(new ItemStack(smallDust, 8, EnumOreType.SUGAR.meta), new ItemStack(Items.field_151102_aT, 1));
        HardLibAPI.oreMachines.addPressurePackRecipe(new ItemStack(rawOre, 9, EnumOreType.IRON.meta), new ItemStack(dummyOreIron));
        HardLibAPI.oreMachines.addPressurePackRecipe(new ItemStack(rawOre, 9, EnumOreType.GOLD.meta), new ItemStack(dummyOreGold));
        HardLibAPI.oreMachines.addPressurePackRecipe(new ItemStack(rawOre, 9, EnumOreType.DIAMOND.meta), new ItemStack(dummyOreDiamond));
        this.addPressurePackRecipes();
        HardLibAPI.oreMachines.addPressurePackRecipe(new ItemStack(Blocks.field_150432_aD, 9), new ItemStack(Blocks.field_150403_cj));
        HardLibAPI.oreMachines.addPressurePackRecipe(new ItemStack(Blocks.field_150433_aE, 9), new ItemStack(Blocks.field_150432_aD));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new OreGuiHandler());
        config.save();
    }

    private void addPressurePackRecipes() {
        List allStacks = RecipesUtils.getAllStorageRecipes();
        for (IRecipe recip : allStacks) {
            if (!HardLibAPI.oreMachines.getSiftResult(recip.func_77571_b(), false).func_190926_b()) continue;
            Ingredient ingred = null;
            for (Ingredient s : recip.func_192400_c()) {
                if (s == Ingredient.field_193370_a) continue;
                ingred = s;
            }
            for (ItemStack stack : ingred.func_193365_a()) {
                if (recip.func_77571_b().func_190926_b() || !HardLibAPI.oreMachines.getPressurePackResult(stack, false).func_190926_b() || stack.func_77973_b() == Items.field_179555_bs || recip.func_77571_b().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150415_aT) || recip.func_77571_b().func_77973_b() == Item.func_150898_a((Block)Blocks.field_180400_cw) || recip.func_77571_b().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai) || recip.func_77571_b().func_190916_E() == recip.func_192400_c().size()) continue;
                ItemStack stack2 = stack.func_77946_l();
                stack2.func_190920_e(recip.func_192400_c().size());
                HardLibAPI.oreMachines.addPressurePackRecipe(stack2, recip.func_77571_b());
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        int addedOres = 9;
        NonNullList oreDictReq = OreDictionary.getOres((String)"oreTin");
        if (oreDictReq.size() > 0) {
            this.addExtraOre("Tin", EnumOreType.TIN, oreTin, dummyOreTin, 3, true);
            addedOres += 3;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"oreCopper")).size() > 0) {
            this.addExtraOre("Copper", EnumOreType.COPPER, oreCopper, dummyOreCopper, 3, true);
            addedOres += 3;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"oreLead")).size() > 0) {
            this.addExtraOre("Lead", EnumOreType.LEAD, oreLead, dummyOreLead, 2, true);
            addedOres += 2;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"oreUranium")).size() > 0) {
            this.addExtraOre("Uranium", EnumOreType.URANIUM, oreUranium, dummyOreUranium, 1, false);
            ++addedOres;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"oreSilver")).size() > 0) {
            this.addExtraOre("Silver", EnumOreType.SILVER, oreSilver, dummyOreSilver, 3, true);
            addedOres += 3;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"oreNickel")).size() > 0) {
            this.addExtraOre("Nickel", EnumOreType.NICKEL, oreNickel, dummyOreNickel, 3, true);
            addedOres += 3;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"oreAluminum")).size() > 0) {
            this.addExtraOre("Aluminum", EnumOreType.ALUMINUM, oreAluminum, dummyOreAluminum, 1, true);
            ++addedOres;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"orePlatinum")).size() > 0) {
            this.addExtraOre("Platinum", EnumOreType.PLATINUM, orePlatinum, dummyOrePlatinum, 2, true);
            addedOres += 2;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"oreOsmium")).size() > 0) {
            this.addExtraOre("Osmium", EnumOreType.OSMIUM, oreOsmium, dummyOreOsmium, 2, false);
            addedOres += 2;
        }
        if ((oreDictReq = OreDictionary.getOres((String)"oreZinc")).size() > 0) {
            this.addExtraOre("Zinc", EnumOreType.ZINC, oreZinc, dummyOreZinc, 2, true);
            addedOres += 2;
            this.addExtraOre("Quartz", EnumOreType.QUARTZ, oreQuartz, dummyOreQuartz, 1, true);
            ++addedOres;
        }
        while (addedOres > 0) {
            HardLibAPI.oreMachines.addSluiceRecipe(Blocks.field_150351_n);
            addedOres -= 3;
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        boolean stoneTools;
        AdvancementUtils.reparentAdvancement((ResourceLocation)new ResourceLocation("minecraft:story/upgrade_tools"), (ResourceLocation)new ResourceLocation("harderores:alternate_stone"), (String)"Harder Ores", (boolean)true);
        boolean hardOption = config.getBoolean("RequireMillingFlour", "MILLING", false, "");
        if (hardOption) {
            // empty if block
        }
        if (stoneTools = config.getBoolean("useDioriteStoneTools", "GENERAL", true, "If true, cobblestone cannot be used to create stone tools,\ninstead diorite is used. This prolongs the life of wood tools so it isn't \"make a wood pickaxe to\nmine 3 stone and upgrade.\"")) {
            AdvancementUtils.removeAdvancement((ResourceLocation)new ResourceLocation("minecraft:recipes/tools/stone_axe"), (String)"Harder Ores");
            AdvancementUtils.removeAdvancement((ResourceLocation)new ResourceLocation("minecraft:recipes/tools/stone_pickaxe"), (String)"Harder Ores");
            AdvancementUtils.removeAdvancement((ResourceLocation)new ResourceLocation("minecraft:recipes/tools/stone_shovel"), (String)"Harder Ores");
            AdvancementUtils.removeAdvancement((ResourceLocation)new ResourceLocation("minecraft:recipes/tools/stone_hoe"), (String)"Harder Ores");
        }
    }

    private void addExtraOre(String oreName, EnumOreType oreType, Block oreBlock, Block dummyOre, int sluiceWeight, boolean canFindDefault) {
        if (!oreType.set) {
            NonNullList ingotStack;
            if (config.get("SLUICE", "canFind" + oreName, canFindDefault).getBoolean()) {
                for (int i = sluiceWeight; i > 0; --i) {
                    HardLibAPI.oreMachines.addSluiceRecipe(oreBlock);
                }
            }
            String oreIn = "dustTiny" + oreName;
            ItemStack rawOreIn = new ItemStack(rawOre, 1, oreType.meta);
            NonNullList dustStack = OreDictionary.getOres((String)("dust" + oreName));
            NonNullList tinyDusktStack = OreDictionary.getOres((String)oreIn);
            NonNullList nuggetStack = OreDictionary.getOres((String)("nugget" + oreName));
            if (dustStack.size() > 0 && tinyDusktStack.size() > 0) {
                ItemStack instk = ((ItemStack)tinyDusktStack.get(0)).func_77946_l();
                if (nuggetStack.size() > 0) {
                    GameRegistry.addSmelting((ItemStack)instk, (ItemStack)((ItemStack)nuggetStack.get(0)), (float)0.1f);
                    GameRegistry.addSmelting((ItemStack)rawOreIn, (ItemStack)((ItemStack)nuggetStack.get(0)), (float)0.1f);
                }
                instk.func_190920_e(2);
                HardLibAPI.oreMachines.addMillRecipe(rawOreIn, instk);
                HardLibAPI.oreMachines.addSiftRecipe(oreIn, 8, (ItemStack)dustStack.get(0));
            }
            if ((ingotStack = OreDictionary.getOres((String)("ingot" + oreName))).size() > 0) {
                GameRegistry.addSmelting((Block)dummyOre, (ItemStack)((ItemStack)ingotStack.get(0)), (float)0.7f);
            }
            HardLibAPI.oreMachines.addPressurePackRecipe(rawOreIn, new ItemStack(dummyOre));
            OreDictionary.registerOre((String)("ore" + oreName), (Block)dummyOre);
            OreDictionary.registerOre((String)("ore" + oreName + "Hard"), (Block)oreBlock);
            oreType.set = true;
        }
    }
}

