/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.block;

import com.draco18s.hardlib.api.blockproperties.Props;
import com.draco18s.hardlib.api.blockproperties.ores.AxelOrientation;
import com.draco18s.hardlib.api.capability.CapabilityMechanicalPower;
import com.draco18s.ores.OresBase;
import com.draco18s.ores.entities.TileEntityAxel;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class BlockAxel
extends Block {
    private static boolean debug = false;
    private static EnumFacing[] checkDirs = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST};

    public BlockAxel() {
        super(Material.field_151575_d, MapColor.field_151650_B);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 1);
        this.func_149752_b(2.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Props.AXEL_ORIENTATION, (Comparable)AxelOrientation.NONE).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing dir = BlockAxel.getFacingFromEntity(pos, placer);
        IBlockState state = this.func_176223_P();
        if (dir == EnumFacing.UP || dir == EnumFacing.DOWN) {
            dir = EnumFacing.NORTH;
            state = state.func_177226_a((IProperty)Props.AXEL_ORIENTATION, (Comparable)AxelOrientation.UP);
        }
        world.func_180497_b(pos, (Block)this, 1, 10);
        state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)dir);
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Props.AXEL_ORIENTATION, BlockHorizontal.field_185512_D});
    }

    public IBlockState func_176203_a(int meta) {
        int face = (meta & 3) + 2;
        return this.func_176223_P().func_177226_a((IProperty)Props.AXEL_ORIENTATION, (Comparable)AxelOrientation.values()[meta >> 2]).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.field_82609_l[face]);
    }

    public int func_176201_c(IBlockState state) {
        int axel = ((AxelOrientation)state.func_177229_b((IProperty)Props.AXEL_ORIENTATION)).getOrdinal() << 2;
        int face = ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176745_a() - 2;
        if (face < 0) {
            face = 0;
        }
        return axel | face;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.HUB;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state.func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.HUB) {
            return new TileEntityAxel();
        }
        return null;
    }

    public static EnumFacing getFacingFromEntity(BlockPos pos, EntityLivingBase p_185647_1_) {
        if (MathHelper.func_76135_e((float)((float)p_185647_1_.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)p_185647_1_.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
            double d = p_185647_1_.field_70163_u + (double)p_185647_1_.func_70047_e();
        }
        return p_185647_1_.func_174811_aO().func_176734_d();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkPlacement(worldIn, pos, state);
    }

    public boolean checkPlacement(World worldIn, BlockPos pos, IBlockState stateIn) {
        IBlockState state = stateIn;
        EnumFacing facing = (EnumFacing)stateIn.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        BlockAxel.logMessage("Checking, is [" + facing + "]");
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            BlockAxel.logMessage("Should point up");
            if (stateIn.func_177229_b((IProperty)Props.AXEL_ORIENTATION) != AxelOrientation.UP) {
                worldIn.func_180497_b(pos.func_177984_a(), (Block)this, 1, 10);
            }
            state = state.func_177226_a((IProperty)Props.AXEL_ORIENTATION, (Comparable)AxelOrientation.UP);
        } else {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                BlockAxel.logMessage("Should be gears; " + facing);
                BlockAxel.logMessage(worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() + ":" + worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c());
                if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this && worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() == this) {
                    BlockAxel.logMessage("Flopping");
                    state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing.func_176734_d());
                    worldIn.func_180497_b(pos.func_177972_a(facing.func_176734_d()), (Block)this, 1, 10);
                }
                if (stateIn.func_177229_b((IProperty)Props.AXEL_ORIENTATION) != AxelOrientation.GEARS) {
                    worldIn.func_180497_b(pos.func_177977_b(), (Block)this, 1, 10);
                }
                state = state.func_177226_a((IProperty)Props.AXEL_ORIENTATION, (Comparable)AxelOrientation.GEARS);
            } else if (worldIn.func_175625_s(pos.func_177977_b()) != null && worldIn.func_175625_s(pos.func_177977_b()).hasCapability(CapabilityMechanicalPower.MECHANICAL_POWER_CAPABILITY, EnumFacing.DOWN)) {
                BlockAxel.logMessage("Should be gears (power user); " + facing);
                BlockAxel.logMessage(worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() + ":" + worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c());
                if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this && worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() == this) {
                    BlockAxel.logMessage("Flopping");
                    state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing.func_176734_d());
                    worldIn.func_180497_b(pos.func_177972_a(facing.func_176734_d()), (Block)this, 1, 10);
                }
                state = state.func_177226_a((IProperty)Props.AXEL_ORIENTATION, (Comparable)AxelOrientation.GEARS);
                worldIn.func_180497_b(pos.func_177967_a(facing, 1), (Block)this, 1, 10);
            } else {
                BlockAxel.logMessage("Hub?");
                int numMatching = 0;
                for (EnumFacing dir : checkDirs) {
                    if (worldIn.func_180495_p(pos.func_177967_a(dir, 1)).func_177230_c() != OresBase.windvane || worldIn.func_180495_p(pos.func_177967_a(dir, 2)).func_177230_c() != OresBase.windvane || worldIn.func_180495_p(pos.func_177967_a(dir.func_176734_d(), 1)).func_177230_c() != OresBase.windvane || worldIn.func_180495_p(pos.func_177967_a(dir.func_176734_d(), 2)).func_177230_c() != OresBase.windvane) continue;
                    ++numMatching;
                }
                if (numMatching == 2) {
                    BlockAxel.logMessage("\tYes");
                    state = state.func_177226_a((IProperty)Props.AXEL_ORIENTATION, (Comparable)AxelOrientation.HUB);
                    for (EnumFacing dir : checkDirs) {
                        IBlockState newstate = OresBase.windvane.func_176223_P();
                        if (worldIn.func_180495_p(pos.func_177967_a(dir, 1)).func_177230_c() != OresBase.windvane) continue;
                        worldIn.func_175656_a(pos.func_177967_a(dir, 1), newstate.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)dir));
                        worldIn.func_175656_a(pos.func_177967_a(dir, 2), newstate.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)dir));
                        worldIn.func_175656_a(pos.func_177967_a(dir.func_176734_d(), 1), newstate.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)dir.func_176734_d()));
                        worldIn.func_175656_a(pos.func_177967_a(dir.func_176734_d(), 2), newstate.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)dir.func_176734_d()));
                    }
                } else {
                    BlockAxel.logMessage("\tNo");
                    state = state.func_177226_a((IProperty)Props.AXEL_ORIENTATION, (Comparable)AxelOrientation.NONE);
                }
            }
            if (worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() != this) {
                BlockAxel.logMessage("Rotating because not coming from axel");
                EnumFacing check = facing;
                do {
                    check = check.func_176746_e();
                    BlockAxel.logMessage("   " + check.func_176734_d() + " is " + worldIn.func_180495_p(pos.func_177972_a(check.func_176734_d())).func_177230_c());
                    IBlockState checkState = worldIn.func_180495_p(pos.func_177972_a(check.func_176734_d()));
                    if (checkState.func_177230_c() != this) continue;
                    if (checkState.func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.GEARS) {
                        BlockAxel.logMessage("Neighbor is gears, adopting neighbor's facing");
                        state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)check);
                        worldIn.func_180497_b(pos.func_177972_a(check.func_176734_d()), (Block)this, 1, 10);
                    } else if (state.func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.GEARS) {
                        BlockAxel.logMessage("I am gears, forcing my facing on neighbor");
                        state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)check.func_176734_d());
                        worldIn.func_180497_b(pos.func_177972_a(check.func_176734_d()), (Block)this, 1, 10);
                    } else if (checkState.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == check.func_176734_d()) {
                        BlockAxel.logMessage("Adopting neighbor's facing");
                        state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)check.func_176734_d());
                    } else {
                        BlockAxel.logMessage("Forcing my facing on neighbor");
                        state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)check);
                        worldIn.func_180497_b(pos.func_177972_a(check), (Block)this, 1, 10);
                    }
                    break;
                } while (facing != check);
            } else {
                if (worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177229_b((IProperty)BlockHorizontal.field_185512_D) != facing) {
                    worldIn.func_180497_b(pos.func_177972_a(facing.func_176734_d()), (Block)this, 1, 10);
                }
                if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == this && worldIn.func_180495_p(pos.func_177972_a(facing)).func_177229_b((IProperty)BlockHorizontal.field_185512_D) == facing.func_176734_d()) {
                    state = state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing.func_176734_d());
                    worldIn.func_180497_b(pos.func_177972_a(facing.func_176734_d()), (Block)this, 1, 10);
                }
            }
        }
        facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        BlockAxel.logMessage("Setting to [" + facing + "]");
        worldIn.func_180501_a(pos, state, 3);
        return false;
    }

    private static void logMessage(String message) {
        if (debug) {
            OresBase.logger.log(Level.DEBUG, message);
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (blockIn != this) {
            worldIn.func_180497_b(pos, (Block)this, 1, 10);
        } else if (state.func_177229_b((IProperty)Props.AXEL_ORIENTATION) == AxelOrientation.GEARS) {
            worldIn.func_180497_b(pos, (Block)this, 1, 10);
        }
    }
}

