/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.block;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.blockproperties.Props;
import com.draco18s.hardlib.api.blockproperties.ores.MillstoneOrientation;
import com.draco18s.hardlib.util.BlockTileEntityUtils;
import com.draco18s.ores.entities.TileEntityMillstone;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockMillstone
extends Block {
    public BlockMillstone() {
        super(Material.field_151576_e, MapColor.field_151665_m);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149752_b(2.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Props.MILL_ORIENTATION, (Comparable)MillstoneOrientation.NONE));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Props.MILL_ORIENTATION});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Props.MILL_ORIENTATION, (Comparable)MillstoneOrientation.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((MillstoneOrientation)state.func_177229_b((IProperty)Props.MILL_ORIENTATION)).getOrdinal();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMillstone();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            TileEntityMillstone te = (TileEntityMillstone)world.func_175625_s(pos);
            IItemHandler inventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            if (inventory == null) {
                return false;
            }
            ItemStack stack = heldItem.func_77946_l();
            stack.func_190920_e(1);
            stack = inventory.insertItem(0, stack, true);
            if (stack.func_190926_b()) {
                stack = inventory.insertItem(0, heldItem.func_77979_a(1), false);
                MillstoneOrientation millpos = (MillstoneOrientation)world.func_180495_p(pos).func_177229_b((IProperty)Props.MILL_ORIENTATION);
                TileEntityMillstone center = (TileEntityMillstone)world.func_175625_s(te.func_174877_v().func_177982_a(millpos.offset.func_177958_n(), 0, millpos.offset.func_177952_p()));
                if (center != null && center.getPower() > 0.0f && player instanceof EntityPlayerMP) {
                    HardLibAPI.Advancements.MILL_BUILT.trigger((EntityPlayerMP)player, center.getPower());
                }
                return true;
            }
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        BlockTileEntityUtils.dropItems((World)world, (BlockPos)pos);
        MillstoneOrientation millpos = (MillstoneOrientation)world.func_180495_p(pos).func_177229_b((IProperty)Props.MILL_ORIENTATION);
        if (millpos != MillstoneOrientation.NONE) {
            Iterable list = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1 + millpos.offset.func_177958_n(), 0, -1 + millpos.offset.func_177952_p()), (BlockPos)pos.func_177982_a(1 + millpos.offset.func_177958_n(), 0, 1 + millpos.offset.func_177952_p()));
            for (BlockPos p : list) {
                if (world.func_180495_p(p).func_177230_c() != this) continue;
                world.func_180501_a(p, state.func_177226_a((IProperty)Props.MILL_ORIENTATION, (Comparable)MillstoneOrientation.NONE), 3);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        world.func_180497_b(pos, (Block)this, 1, 10);
        return this.func_176203_a(meta);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        block1: {
            BlockPos p;
            if (this.checkPlacement(worldIn, pos, false)) break block1;
            Iterable list = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1));
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (worldIn.func_180495_p(p = (BlockPos)iterator.next()).func_177230_c() != this || !this.checkPlacement(worldIn, p, false))) {
            }
        }
    }

    public boolean checkPlacement(World world, BlockPos pos, boolean destructive) {
        Iterable list = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1));
        int count = 0;
        for (BlockPos p : list) {
            IBlockState state = world.func_180495_p(p);
            if (state.func_177230_c() != this || state.func_177229_b((IProperty)Props.MILL_ORIENTATION) != MillstoneOrientation.NONE) continue;
            ++count;
        }
        if (count == 9) {
            System.out.println("Nine");
            for (BlockPos p : list) {
                Vec3i q = new Vec3i(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                BlockPos off = pos.func_177973_b(q);
                System.out.println("  " + off);
                for (MillstoneOrientation orient : MillstoneOrientation.values()) {
                    if (orient.offset.func_177958_n() != off.func_177958_n() || orient.offset.func_177952_p() != off.func_177952_p()) continue;
                    world.func_175656_a(p, this.func_176223_P().func_177226_a((IProperty)Props.MILL_ORIENTATION, (Comparable)orient));
                }
            }
        }
        return false;
    }
}

