/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.block;

import com.draco18s.ores.entities.TileEntityBasicSluice;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSluice
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB PARTIAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

    public BlockSluice() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 1);
        this.func_149752_b(2.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING}, (IUnlistedProperty[])BlockFluidBase.FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public int func_176201_c(IBlockState state) {
        int fc = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return fc;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        int fc = meta;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[fc]);
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        int j;
        int i;
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        TileEntityBasicSluice te = (TileEntityBasicSluice)worldIn.func_175625_s(pos);
        boolean hasWater = te.getWaterAmount() > 0;
        float dir = BlockSluice.getFlowDirection(oldState);
        state = state.withProperty((IUnlistedProperty)BlockFluidBase.FLOW_DIRECTION, (Object)Float.valueOf(dir));
        float waterHeight = (float)te.getWaterAmount() * 14.0f / 16.0f;
        float[][] corner = new float[2][2];
        corner[0][0] = this.getCorner(worldIn, pos, oldState, EnumFacing.NORTH, EnumFacing.WEST);
        corner[0][1] = this.getCorner(worldIn, pos, oldState, EnumFacing.SOUTH, EnumFacing.WEST);
        corner[1][1] = this.getCorner(worldIn, pos, oldState, EnumFacing.SOUTH, EnumFacing.EAST);
        corner[1][0] = this.getCorner(worldIn, pos, oldState, EnumFacing.NORTH, EnumFacing.EAST);
        boolean anyZero = false;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                if (corner[i][j] != 0.0f) continue;
                anyZero = true;
            }
        }
        if (anyZero) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    if (corner[i][j] != 0.0f) continue;
                    corner[i][j] = 0.0f;
                }
            }
        }
        state = state.withProperty((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[0], (Object)Float.valueOf(corner[0][0]));
        state = state.withProperty((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[1], (Object)Float.valueOf(corner[0][1]));
        state = state.withProperty((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[2], (Object)Float.valueOf(corner[1][1]));
        state = state.withProperty((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[3], (Object)Float.valueOf(corner[1][0]));
        return state;
    }

    private float getCorner(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing NS, EnumFacing EW) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        TileEntityBasicSluice teSelf = (TileEntityBasicSluice)world.func_175625_s(pos);
        if (teSelf.getWaterAmount() <= 0) {
            return 0.001f;
        }
        if (dir != NS && dir != EW) {
            IBlockState upstream = world.func_180495_p(pos.func_177967_a(dir.func_176734_d(), 1));
            if (upstream.func_177230_c() == this) {
                TileEntityBasicSluice teUp = (TileEntityBasicSluice)world.func_175625_s(pos.func_177967_a(dir.func_176734_d(), 1));
                return (float)(teUp.getWaterAmount() - 1) * 3.0f / 32.0f;
            }
            if (upstream.func_177230_c() == Blocks.field_150355_j) {
                return (1.0f - (float)((Integer)upstream.func_177229_b((IProperty)BlockDynamicLiquid.field_176367_b)).intValue() * 2.0f / 16.0f) * 0.885f;
            }
            if (upstream.func_177230_c() == Blocks.field_150358_i) {
                return (1.0f - (float)((Integer)upstream.func_177229_b((IProperty)BlockDynamicLiquid.field_176367_b)).intValue() * 2.0f / 16.0f) * 0.885f;
            }
        } else {
            IBlockState downstream = world.func_180495_p(pos.func_177967_a(dir, 1));
            if (downstream.func_177230_c() == this) {
                TileEntityBasicSluice teDown = (TileEntityBasicSluice)world.func_175625_s(pos.func_177967_a(dir, 1));
                if (teDown.getWaterAmount() == 0) {
                    return 0.125f;
                }
                return (float)(teDown.getWaterAmount() + 1) * 3.0f / 32.0f;
            }
            if (downstream.isSideSolid(world, pos, dir)) {
                return 0.125f;
            }
            if (!downstream.isSideSolid(world, pos, dir.func_176734_d())) {
                return 0.125f;
            }
        }
        return 0.0f;
    }

    public static Vec3d getFlowVec(IBlockState blockState) {
        EnumFacing dir = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        return new Vec3d((double)(dir.func_82601_c() * 1), 0.0, (double)(dir.func_82599_e() * 1));
    }

    public static float getFlowDirection(IBlockState blockState) {
        Vec3d vec = BlockSluice.getFlowVec(blockState);
        return (float)(Math.atan2(vec.field_72449_c, vec.field_72450_a) - 1.5707963267948966);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBasicSluice();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getUpdatedState((IBlockAccess)world, pos, this.func_176223_P());
    }

    private IBlockState getUpdatedState(IBlockAccess world, BlockPos pos, IBlockState thisState) {
        IBlockState bl;
        for (EnumFacing face : EnumFacing.field_176754_o) {
            bl = world.func_180495_p(pos.func_177967_a(face, 1));
            if (bl.func_177230_c() != Blocks.field_150355_j || (Integer)bl.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) continue;
            return thisState.func_177226_a((IProperty)FACING, (Comparable)face.func_176734_d());
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            bl = world.func_180495_p(pos.func_177967_a(face, 1));
            if (bl.func_177230_c() == Blocks.field_150358_i) {
                return thisState.func_177226_a((IProperty)FACING, (Comparable)face.func_176734_d());
            }
            if (bl.func_177230_c() != Blocks.field_150355_j) continue;
            return thisState.func_177226_a((IProperty)FACING, (Comparable)face.func_176734_d());
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            bl = world.func_180495_p(pos.func_177967_a(face, 1));
            if (bl.func_177230_c() != this || bl.func_177229_b((IProperty)FACING) != face.func_176734_d()) continue;
            return thisState.func_177226_a((IProperty)FACING, (Comparable)face.func_176734_d());
        }
        return thisState.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PARTIAL_AABB;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && !world.field_72995_K) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return;
        }
        world.func_180501_a(pos, this.getUpdatedState((IBlockAccess)world, pos, world.func_180495_p(pos)), 3);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (!worldIn.field_72995_K && worldIn.func_180495_p(pos.func_177972_a(dir).func_177977_b()).func_185904_a() == Material.field_151586_h) {
            IBlockState st = Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockDynamicLiquid.field_176367_b, (Comparable)Integer.valueOf(1));
            worldIn.func_180501_a(pos.func_177972_a(dir).func_177977_b(), st, 3);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return super.removedByPlayer(state, worldIn, pos, player, willHarvest);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntityBasicSluice te = (TileEntityBasicSluice)worldIn.func_175625_s(pos);
        if (te.getWaterAmount() > 0 && te.getTime() <= 0) {
            this.spawnParticles(worldIn, pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    private void spawnParticles(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        for (int i = 0; i < 5; ++i) {
            double d1 = (double)((float)pos.func_177958_n() + random.nextFloat() / 2.0f) + 0.25;
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (double)((float)pos.func_177952_p() + random.nextFloat() / 2.0f) + 0.25;
            worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState stateAtPos = world.func_180495_p(pos.func_177967_a(face, 1));
        Block bl = stateAtPos.func_177230_c();
        if (bl == Blocks.field_150355_j || bl == Blocks.field_150358_i || bl == this) {
            return ((TileEntityBasicSluice)world.func_175625_s(pos)).getWaterAmount() != 0;
        }
        if (face == EnumFacing.UP) {
            return true;
        }
        return state.func_185914_p();
    }
}

