/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.block.ore;

import com.draco18s.hardlib.api.blockproperties.Props;
import com.draco18s.hardlib.api.blockproperties.ores.EnumOreType;
import com.draco18s.hardlib.api.interfaces.IBlockMultiBreak;
import com.draco18s.ores.OresBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHardOreBase
extends Block
implements IBlockMultiBreak {
    public static final EnumFacing[] DROP_SEARCH_DIRECTIONS = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN};
    public final int metaChange;
    public final EnumOreType oreType;
    Color color = Color.WHITE;

    public BlockHardOreBase(EnumOreType type, int metaDecrement, Color particleColor) {
        super(Material.field_151576_e, MapColor.field_151665_m);
        this.func_149752_b(5.0f);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Props.ORE_DENSITY, (Comparable)Integer.valueOf(1)));
        this.oreType = type;
        this.metaChange = metaDecrement;
        this.color = particleColor;
    }

    public int getDensityChangeOnBreak(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        return this.metaChange;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 15));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Props.ORE_DENSITY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Props.ORE_DENSITY, (Comparable)Integer.valueOf(meta + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)Props.ORE_DENSITY) - 1;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return OresBase.rawOre;
    }

    public int func_180651_a(IBlockState state) {
        return this.oreType.meta;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1 + random.nextInt(fortune + ((Integer)state.func_177229_b((IProperty)Props.ORE_DENSITY) - 1) / 6 + 1);
    }

    public Color getProspectorParticleColor(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        return this.color;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.func_180643_i(state);
    }

    @Nullable
    protected ItemStack func_180643_i(IBlockState state) {
        Item item = Item.func_150898_a((Block)this);
        int i = this.func_176201_c(state);
        return new ItemStack(item, 1, i);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player != null && player.field_71075_bZ.field_75098_d && player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            if (!world.field_72995_K) {
                int m = (Integer)state.func_177229_b((IProperty)Props.ORE_DENSITY);
                if ((m -= player.func_70093_af() ? 1 : 4) < 1) {
                    m += 16;
                }
                world.func_180501_a(pos, state.func_177226_a((IProperty)Props.ORE_DENSITY, (Comparable)Integer.valueOf(m)), 3);
            }
            return true;
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        Item item = this.func_180660_a(state, rand, fortune);
        ret.add(new ItemStack(item, count, this.func_180651_a(state)));
        int metadata = (Integer)state.func_177229_b((IProperty)Props.ORE_DENSITY);
        for (int m = metadata - this.metaChange; m >= 1; m -= this.metaChange) {
            ArrayList<ItemStack> extra = this.getDropsStandard(world, pos, state.func_177226_a((IProperty)Props.ORE_DENSITY, (Comparable)Integer.valueOf(metadata)), fortune, rand);
            for (ItemStack ex : extra) {
                int c;
                float f = (float)ex.func_190916_E() * 0.75f;
                if ((f -= (float)(c = (int)Math.floor(f))) > 0.0f && rand.nextFloat() < f) {
                    ++c;
                }
                ex.func_190920_e(c);
            }
            ret.addAll(extra);
        }
        return ret;
    }

    protected ArrayList<ItemStack> getDropsStandard(IBlockAccess world, BlockPos pos, IBlockState state, int fortune, Random rand) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = this.func_180660_a(state, rand, fortune);
        int count = this.quantityDropped(state, fortune, rand);
        ret.add(new ItemStack(item, count, this.func_180651_a(state)));
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player != null && player.field_71075_bZ.field_75098_d) {
            world.func_175698_g(pos);
            return true;
        }
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            int m = (Integer)state.func_177229_b((IProperty)Props.ORE_DENSITY);
            if ((m -= this.metaChange) < 1) {
                return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)Props.ORE_DENSITY, (Comparable)Integer.valueOf(m)), 3);
            ItemStack itemstack1 = player.func_184614_ca();
            ItemStack itemstack2 = itemstack1 == null ? null : itemstack1.func_77946_l();
            this.func_180657_a(world, player, pos, state, null, itemstack2);
            return false;
        }
        return true;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            ArrayList<ItemStack> items = this.getDropsStandard((IBlockAccess)worldIn, pos, state, fortune, worldIn.field_73012_v);
            chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockHardOreBase.spawnAsEntity(worldIn, pos, item);
            }
        }
    }

    public static void spawnAsEntity(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.field_72995_K && worldIn.func_82736_K().func_82766_b("doTileDrops") && !worldIn.restoringBlockSnapshots) {
            if (((Boolean)captureDrops.get()).booleanValue()) {
                ((NonNullList)capturedDrops.get()).add((Object)stack);
                return;
            }
            float f = 0.5f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            if (!worldIn.func_180495_p(pos).func_185915_l()) {
                EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                worldIn.func_72838_d((Entity)entityitem);
                return;
            }
            for (EnumFacing dir : DROP_SEARCH_DIRECTIONS) {
                if (worldIn.func_180495_p(pos.func_177972_a(dir)).func_185915_l() && dir != EnumFacing.DOWN) continue;
                EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0 + (double)dir.func_82601_c(), (double)pos.func_177956_o() + d1 + (double)dir.func_96559_d(), (double)pos.func_177952_p() + d2 + (double)dir.func_82599_e(), stack);
                entityitem.func_174869_p();
                worldIn.func_72838_d((Entity)entityitem);
                return;
            }
        }
    }
}

