/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.client;

import com.draco18s.hardlib.api.interfaces.IBlockMultiBreak;
import com.draco18s.hardlib.api.internal.ChunkCoords;
import com.draco18s.hardlib.client.ModelsCache;
import com.draco18s.ores.CommonProxy;
import com.draco18s.ores.OresBase;
import com.draco18s.ores.client.OreClientEventHandler;
import com.draco18s.ores.client.ProspectorParticle;
import com.draco18s.ores.client.ProspectorParticleDust;
import com.draco18s.ores.client.SoundWindmill;
import com.draco18s.ores.client.rendering.RenderOreCart;
import com.draco18s.ores.entities.EntityOreMinecart;
import com.draco18s.ores.entities.TileEntityMillstone;
import com.draco18s.ores.networking.ClientOreParticleHandler;
import com.draco18s.ores.networking.ToClientMessageOreParticles;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    private HashMap<ChunkCoords, SoundWindmill> sounds = new HashMap();

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityOreMinecart.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderOreCart(manager);
            }
        });
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        OreClientEventHandler handler = new OreClientEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)ModelsCache.INSTANCE);
    }

    @Override
    public void handleMessage(final ToClientMessageOreParticles message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
                ClientProxy.drawParticle(p.field_70170_p, ClientProxy.getParticle(p.field_70170_p, message.oreAt, message.eventAt, ClientOreParticleHandler.RADAR, 0));
                ClientProxy.drawParticle(p.field_70170_p, ClientProxy.getParticle(p.field_70170_p, message.oreAt, message.eventAt, ClientOreParticleHandler.DUST, 0));
                ClientProxy.drawParticle(p.field_70170_p, ClientProxy.getParticle(p.field_70170_p, message.oreAt, message.eventAt, ClientOreParticleHandler.DUST, -4));
            }
        });
    }

    @Override
    public void startMillSound(TileEntityMillstone te) {
        if (!OresBase.useSounds) {
            return;
        }
        ChunkCoords tepos = new ChunkCoords(te.func_145831_w().field_73011_w.getDimension(), te.func_174877_v());
        if (!this.sounds.containsKey(tepos)) {
            SoundWindmill snd = new SoundWindmill(new ResourceLocation("harderores:grain-mill-loop"), SoundCategory.BLOCKS, te);
            OreClientEventHandler.soundsToStart.put(snd, 0);
            this.sounds.put(tepos, snd);
        } else {
            SoundWindmill snd = this.sounds.get(tepos);
            if (snd.func_147667_k()) {
                this.sounds.remove(tepos);
                snd = new SoundWindmill(new ResourceLocation("harderores:grain-mill-loop"), SoundCategory.BLOCKS, te);
                OreClientEventHandler.soundsToStart.put(snd, 0);
                this.sounds.put(tepos, snd);
            }
        }
    }

    private static void drawParticle(World world, Particle particle) {
        if (particle != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
    }

    public static Particle getParticle(World world, BlockPos oreAt, BlockPos eventAt, int id, int startingAge) {
        Color c;
        Block block;
        IBlockState state;
        float z;
        float y;
        float x;
        Particle particle = null;
        if (id == ClientOreParticleHandler.RADAR) {
            x = (float)((int)((float)Math.random() * 4.0f)) / 5.0f + 0.1f;
            y = 0.5f + (float)Math.random() * 0.75f;
            z = (float)((int)((float)Math.random() * 4.0f)) / 5.0f + 0.1f;
            particle = new ProspectorParticle(world, (float)oreAt.func_177958_n() + x, (float)oreAt.func_177956_o() + y, (float)oreAt.func_177952_p() + z, 0.0, 0.0, 0.0);
            state = world.func_180495_p(oreAt);
            block = state.func_177230_c();
            if (block instanceof IBlockMultiBreak) {
                c = ((IBlockMultiBreak)block).getProspectorParticleColor((IBlockAccess)world, oreAt, state);
                particle.func_70538_b((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            }
        }
        if (id == ClientOreParticleHandler.DUST) {
            x = (float)((int)((float)Math.random() * 8.0f)) / 10.0f + 0.1f;
            y = 0.5f + (float)Math.random() * 0.5f;
            z = (float)((int)((float)Math.random() * 8.0f)) / 10.0f + 0.1f;
            particle = new ProspectorParticleDust(world, (float)eventAt.func_177958_n() + x, (float)eventAt.func_177956_o() + y, (float)eventAt.func_177952_p() + z, 0.0, 0.0, 0.0, startingAge);
            state = world.func_180495_p(oreAt);
            block = state.func_177230_c();
            if (block instanceof IBlockMultiBreak) {
                c = ((IBlockMultiBreak)block).getProspectorParticleColor((IBlockAccess)world, oreAt, state);
                particle.func_70538_b((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            }
        }
        return particle;
    }
}

